/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import soot.AnySubType;
import soot.ArrayType;
import soot.NullType;
import soot.RefLikeType;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.jimple.SpecialInvokeExpr;
import soot.util.ConcurrentHashMultiMap;
import soot.util.MultiMap;

public class FastHierarchy {
    protected MultiMap<SootClass, SootClass> classToSubclasses = new ConcurrentHashMultiMap<SootClass, SootClass>();
    protected MultiMap<SootClass, SootClass> interfaceToSubinterfaces = new ConcurrentHashMultiMap<SootClass, SootClass>();
    protected MultiMap<SootClass, SootClass> interfaceToImplementers = new ConcurrentHashMultiMap<SootClass, SootClass>();
    protected MultiMap<SootClass, SootClass> interfaceToAllSubinterfaces = new ConcurrentHashMultiMap<SootClass, SootClass>();
    protected MultiMap<SootClass, SootClass> interfaceToAllImplementers = new ConcurrentHashMultiMap<SootClass, SootClass>();
    protected Map<SootClass, Interval> classToInterval = new HashMap<SootClass, Interval>();
    protected Scene sc = Scene.v();

    protected int dfsVisit(int start, SootClass c) {
        Interval r = new Interval();
        r.lower = start++;
        Set<SootClass> col = this.classToSubclasses.get(c);
        if (col != null) {
            for (SootClass sc : col) {
                if (sc.isInterface()) continue;
                start = this.dfsVisit(start, sc);
            }
        }
        r.upper = start++;
        if (c.isInterface()) {
            throw new RuntimeException("Attempt to dfs visit interface " + c);
        }
        if (!this.classToInterval.containsKey(c)) {
            this.classToInterval.put(c, r);
        }
        return start;
    }

    public FastHierarchy() {
        for (SootClass cl : this.sc.getClasses()) {
            if (cl.resolvingLevel() < 1) continue;
            if (!cl.isInterface() && cl.hasSuperclass()) {
                this.classToSubclasses.put(cl.getSuperclass(), cl);
            }
            for (SootClass supercl : cl.getInterfaces()) {
                if (cl.isInterface()) {
                    this.interfaceToSubinterfaces.put(supercl, cl);
                    continue;
                }
                this.interfaceToImplementers.put(supercl, cl);
            }
        }
        this.dfsVisit(0, Scene.v().getSootClass("java.lang.Object"));
        for (SootClass phantomClass : Scene.v().getPhantomClasses()) {
            if (phantomClass.isInterface()) continue;
            this.dfsVisit(0, phantomClass);
        }
    }

    public boolean isSubclass(SootClass child, SootClass parent) {
        child.checkLevel(1);
        parent.checkLevel(1);
        Interval parentInterval = this.classToInterval.get(parent);
        Interval childInterval = this.classToInterval.get(child);
        return parentInterval.isSubrange(childInterval);
    }

    public Set<SootClass> getAllImplementersOfInterface(SootClass parent) {
        parent.checkLevel(1);
        if (!this.interfaceToAllImplementers.containsKey(parent)) {
            for (SootClass subinterface : this.getAllSubinterfaces(parent)) {
                if (subinterface == parent) continue;
                this.interfaceToAllImplementers.putAll(parent, this.getAllImplementersOfInterface(subinterface));
            }
            this.interfaceToAllImplementers.putAll(parent, this.interfaceToImplementers.get(parent));
        }
        return this.interfaceToAllImplementers.get(parent);
    }

    public Set<SootClass> getAllSubinterfaces(SootClass parent) {
        parent.checkLevel(1);
        if (!parent.isInterface()) {
            return Collections.emptySet();
        }
        if (!this.interfaceToAllSubinterfaces.containsKey(parent)) {
            this.interfaceToAllSubinterfaces.put(parent, parent);
            for (SootClass si : this.interfaceToSubinterfaces.get(parent)) {
                this.interfaceToAllSubinterfaces.putAll(parent, this.getAllSubinterfaces(si));
            }
        }
        return this.interfaceToAllSubinterfaces.get(parent);
    }

    public boolean canStoreType(Type child, Type parent) {
        if (child.equals(parent)) {
            return true;
        }
        if (parent instanceof NullType) {
            return false;
        }
        if (child instanceof NullType) {
            return parent instanceof RefLikeType;
        }
        if (child instanceof RefType) {
            if (parent.equals(Scene.v().getObjectType())) {
                return true;
            }
            if (parent instanceof RefType) {
                return this.canStoreClass(((RefType)child).getSootClass(), ((RefType)parent).getSootClass());
            }
            return false;
        }
        if (child instanceof AnySubType) {
            if (!(parent instanceof RefLikeType)) {
                throw new RuntimeException("Unhandled type " + parent);
            }
            if (parent instanceof ArrayType) {
                RefType base = ((AnySubType)child).getBase();
                return ((Object)base).equals(RefType.v("java.lang.Object")) || ((Object)base).equals(RefType.v("java.io.Serializable")) || ((Object)base).equals(RefType.v("java.lang.Cloneable"));
            }
            SootClass base = ((AnySubType)child).getBase().getSootClass();
            SootClass parentClass = ((RefType)parent).getSootClass();
            LinkedList<SootClass> worklist = new LinkedList<SootClass>();
            if (base.isInterface()) {
                worklist.addAll(this.getAllImplementersOfInterface(base));
            } else {
                worklist.add(base);
            }
            HashSet<SootClass> workset = new HashSet<SootClass>();
            while (!worklist.isEmpty()) {
                SootClass cl = (SootClass)worklist.removeFirst();
                if (!workset.add(cl)) continue;
                if (cl.isConcrete() && this.canStoreClass(cl, parentClass)) {
                    return true;
                }
                worklist.addAll(this.getSubclassesOf(cl));
            }
            return false;
        }
        if (child instanceof ArrayType) {
            ArrayType achild = (ArrayType)child;
            if (parent instanceof RefType) {
                return parent.equals(RefType.v("java.lang.Object")) || parent.equals(RefType.v("java.io.Serializable")) || parent.equals(RefType.v("java.lang.Cloneable"));
            }
            if (!(parent instanceof ArrayType)) {
                return false;
            }
            ArrayType aparent = (ArrayType)parent;
            if (achild.numDimensions == aparent.numDimensions) {
                if (achild.baseType.equals(aparent.baseType)) {
                    return true;
                }
                if (!(achild.baseType instanceof RefType)) {
                    return false;
                }
                if (!(aparent.baseType instanceof RefType)) {
                    return false;
                }
                return this.canStoreType(achild.baseType, aparent.baseType);
            }
            if (achild.numDimensions > aparent.numDimensions) {
                if (aparent.baseType.equals(RefType.v("java.lang.Object"))) {
                    return true;
                }
                if (aparent.baseType.equals(RefType.v("java.io.Serializable"))) {
                    return true;
                }
                return aparent.baseType.equals(RefType.v("java.lang.Cloneable"));
            }
            return false;
        }
        return false;
    }

    protected boolean canStoreClass(SootClass child, SootClass parent) {
        parent.checkLevel(1);
        child.checkLevel(1);
        Interval parentInterval = this.classToInterval.get(parent);
        Interval childInterval = this.classToInterval.get(child);
        if (parentInterval != null && childInterval != null) {
            return parentInterval.isSubrange(childInterval);
        }
        if (childInterval == null) {
            if (parentInterval != null) {
                return parent.equals(Scene.v().getObjectType().getSootClass());
            }
            return this.getAllSubinterfaces(parent).contains(child);
        }
        Set<SootClass> impl = this.getAllImplementersOfInterface(parent);
        Iterator<SootClass> it = impl.iterator();
        while (it.hasNext()) {
            parentInterval = this.classToInterval.get(it.next());
            if (parentInterval == null || !parentInterval.isSubrange(childInterval)) continue;
            return true;
        }
        return false;
    }

    public Collection<SootMethod> resolveConcreteDispatchWithoutFailing(Collection<Type> concreteTypes, SootMethod m, RefType declaredTypeOfBase) {
        HashSet<SootMethod> ret = new HashSet<SootMethod>();
        SootClass declaringClass = declaredTypeOfBase.getSootClass();
        declaringClass.checkLevel(1);
        for (Type t : concreteTypes) {
            SootMethod concreteM;
            if (t instanceof AnySubType) {
                HashSet<SootClass> s = new HashSet<SootClass>();
                s.add(declaringClass);
                while (!s.isEmpty()) {
                    SootClass c = (SootClass)s.iterator().next();
                    s.remove(c);
                    if (!c.isInterface() && !c.isAbstract() && this.canStoreClass(c, declaringClass) && (concreteM = this.resolveConcreteDispatch(c, m)) != null) {
                        ret.add(concreteM);
                    }
                    if (this.classToSubclasses.containsKey(c)) {
                        s.addAll(this.classToSubclasses.get(c));
                    }
                    if (this.interfaceToSubinterfaces.containsKey(c)) {
                        s.addAll(this.interfaceToSubinterfaces.get(c));
                    }
                    if (!this.interfaceToImplementers.containsKey(c)) continue;
                    s.addAll(this.interfaceToImplementers.get(c));
                }
                return ret;
            }
            if (t instanceof RefType) {
                RefType concreteType = (RefType)t;
                SootClass concreteClass = concreteType.getSootClass();
                if (!this.canStoreClass(concreteClass, declaringClass)) continue;
                concreteM = null;
                try {
                    concreteM = this.resolveConcreteDispatch(concreteClass, m);
                }
                catch (Exception e) {
                    concreteM = null;
                }
                if (concreteM == null) continue;
                ret.add(concreteM);
                continue;
            }
            if (t instanceof ArrayType) {
                SootMethod concreteM2 = null;
                try {
                    concreteM2 = this.resolveConcreteDispatch(RefType.v("java.lang.Object").getSootClass(), m);
                }
                catch (Exception e) {
                    concreteM2 = null;
                }
                if (concreteM2 == null) continue;
                ret.add(concreteM2);
                continue;
            }
            throw new RuntimeException("Unrecognized reaching type " + t);
        }
        return ret;
    }

    public Collection<SootMethod> resolveConcreteDispatch(Collection<Type> concreteTypes, SootMethod m, RefType declaredTypeOfBase) {
        HashSet<SootMethod> ret = new HashSet<SootMethod>();
        SootClass declaringClass = declaredTypeOfBase.getSootClass();
        declaringClass.checkLevel(1);
        for (Type t : concreteTypes) {
            SootMethod concreteM;
            if (t instanceof AnySubType) {
                HashSet<SootClass> s = new HashSet<SootClass>();
                s.add(declaringClass);
                while (!s.isEmpty()) {
                    SootClass c = (SootClass)s.iterator().next();
                    s.remove(c);
                    if (!c.isInterface() && !c.isAbstract() && this.canStoreClass(c, declaringClass) && (concreteM = this.resolveConcreteDispatch(c, m)) != null) {
                        ret.add(concreteM);
                    }
                    if (this.classToSubclasses.containsKey(c)) {
                        s.addAll(this.classToSubclasses.get(c));
                    }
                    if (this.interfaceToSubinterfaces.containsKey(c)) {
                        s.addAll(this.interfaceToSubinterfaces.get(c));
                    }
                    if (!this.interfaceToImplementers.containsKey(c)) continue;
                    s.addAll(this.interfaceToImplementers.get(c));
                }
                return ret;
            }
            if (t instanceof RefType) {
                RefType concreteType = (RefType)t;
                SootClass concreteClass = concreteType.getSootClass();
                if (!this.canStoreClass(concreteClass, declaringClass) || (concreteM = this.resolveConcreteDispatch(concreteClass, m)) == null) continue;
                ret.add(concreteM);
                continue;
            }
            if (t instanceof ArrayType) {
                SootMethod concreteM2 = this.resolveConcreteDispatch(RefType.v("java.lang.Object").getSootClass(), m);
                if (concreteM2 == null) continue;
                ret.add(concreteM2);
                continue;
            }
            throw new RuntimeException("Unrecognized reaching type " + t);
        }
        return ret;
    }

    private boolean isVisible(SootClass from, SootMethod m) {
        from.checkLevel(1);
        if (m.isPublic()) {
            return true;
        }
        if (m.isPrivate()) {
            return from.equals(m.getDeclaringClass());
        }
        if (m.isProtected()) {
            return this.canStoreClass(from, m.getDeclaringClass());
        }
        return from.getJavaPackageName().equals(m.getDeclaringClass().getJavaPackageName());
    }

    public Set<SootMethod> resolveAbstractDispatch(SootClass abstractType, SootMethod m) {
        String methodSig = m.getSubSignature();
        HashSet<SootClass> resolved = new HashSet<SootClass>();
        HashSet<SootMethod> ret = new HashSet<SootMethod>();
        LinkedList<SootClass> worklist = new LinkedList<SootClass>();
        worklist.add(abstractType);
        block0: while (!worklist.isEmpty()) {
            SootClass concreteType;
            SootClass savedConcreteType = concreteType = (SootClass)worklist.removeFirst();
            if (concreteType.isInterface()) {
                worklist.addAll(this.getAllImplementersOfInterface(concreteType));
                continue;
            }
            Set<SootClass> c = this.classToSubclasses.get(concreteType);
            if (c != null) {
                worklist.addAll(c);
            }
            if (concreteType.isAbstract()) continue;
            while (!resolved.contains(concreteType)) {
                resolved.add(concreteType);
                SootMethod method = concreteType.getMethodUnsafe(methodSig);
                if (method != null && this.isVisible(concreteType, m)) {
                    if (method.isAbstract()) {
                        throw new RuntimeException("abstract dispatch resolved to abstract method!\nAbstract Type: " + abstractType + "\nConcrete Type: " + savedConcreteType + "\nMethod: " + m);
                    }
                    ret.add(method);
                    continue block0;
                }
                if (!concreteType.hasSuperclass()) {
                    if (concreteType.isPhantom()) continue block0;
                    throw new RuntimeException("could not resolve abstract dispatch!\nAbstract Type: " + abstractType + "\nConcrete Type: " + savedConcreteType + "\nMethod: " + m);
                }
                concreteType = concreteType.getSuperclass();
            }
        }
        return ret;
    }

    public SootMethod resolveConcreteDispatch(SootClass concreteType, SootMethod m) {
        concreteType.checkLevel(1);
        if (concreteType.isInterface()) {
            throw new RuntimeException("A concrete type cannot be an interface: " + concreteType);
        }
        String methodSig = m.getSubSignature();
        while (true) {
            SootMethod method;
            if ((method = concreteType.getMethodUnsafe(methodSig)) != null && this.isVisible(concreteType, m)) {
                if (method.isAbstract()) {
                    throw new RuntimeException("Error: Method call resolves to abstract method!");
                }
                return method;
            }
            if (!concreteType.hasSuperclass()) break;
            concreteType = concreteType.getSuperclass();
        }
        return null;
    }

    public SootMethod resolveSpecialDispatch(SpecialInvokeExpr ie, SootMethod container2) {
        SootMethod target = ie.getMethod();
        if (target.getName().equals("<init>") || target.isPrivate()) {
            return target;
        }
        if (this.isSubclass(target.getDeclaringClass(), container2.getDeclaringClass())) {
            return this.resolveConcreteDispatch(container2.getDeclaringClass(), target);
        }
        return target;
    }

    public Collection<SootClass> getSubclassesOf(SootClass c) {
        c.checkLevel(1);
        Set<SootClass> ret = this.classToSubclasses.get(c);
        if (ret == null) {
            return Collections.emptyList();
        }
        return ret;
    }

    protected class Interval {
        int lower;
        int upper;

        protected Interval() {
        }

        boolean isSubrange(Interval potentialSubrange) {
            if (potentialSubrange == null) {
                return false;
            }
            if (this.lower > potentialSubrange.lower) {
                return false;
            }
            return this.upper >= potentialSubrange.upper;
        }
    }
}

