/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.dexbacked.raw;

import org.jf.dexlib2.dexbacked.BaseDexBuffer;

public class OdexHeaderItem {
    public static final int ITEM_SIZE = 40;
    public static final byte[][] MAGIC_VALUES = new byte[][]{{100, 101, 121, 10, 48, 51, 53, 0}, {100, 101, 121, 10, 48, 51, 54, 0}};
    public static final int MAGIC_OFFSET = 0;
    public static final int MAGIC_LENGTH = 8;
    public static final int DEX_OFFSET = 8;
    public static final int DEX_LENGTH_OFFSET = 12;
    public static final int DEPENDENCIES_OFFSET = 16;
    public static final int DEPENDENCIES_LENGTH_OFFSET = 20;
    public static final int AUX_OFFSET = 24;
    public static final int AUX_LENGTH_OFFSET = 28;
    public static final int FLAGS_OFFSET = 32;

    public static int getVersion(byte[] magic) {
        if (magic.length < 8) {
            return 0;
        }
        boolean matches = true;
        for (int i = 0; i < MAGIC_VALUES.length; ++i) {
            byte[] expected = MAGIC_VALUES[i];
            matches = true;
            for (int j = 0; j < 8; ++j) {
                if (magic[j] == expected[j]) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            return i == 0 ? 35 : 36;
        }
        return 0;
    }

    public static boolean verifyMagic(byte[] buf) {
        return OdexHeaderItem.getVersion(buf) != 0;
    }

    public static int getDexOffset(byte[] buf) {
        BaseDexBuffer bdb = new BaseDexBuffer(buf);
        return bdb.readSmallUint(8);
    }

    public static int getDependenciesOffset(byte[] buf) {
        BaseDexBuffer bdb = new BaseDexBuffer(buf);
        return bdb.readSmallUint(16);
    }
}

