/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.dexbacked;

import com.google.common.io.ByteStreams;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import javax.annotation.Nonnull;
import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.dexbacked.BaseDexBuffer;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.dexbacked.DexReader;
import org.jf.dexlib2.dexbacked.raw.OdexHeaderItem;
import org.jf.dexlib2.dexbacked.util.VariableSizeList;

public class DexBackedOdexFile
extends DexBackedDexFile {
    private static final int DEPENDENCY_COUNT_OFFSET = 12;
    private static final int DEPENDENCY_START_OFFSET = 16;
    private final byte[] odexBuf;

    public DexBackedOdexFile(@Nonnull Opcodes opcodes, @Nonnull byte[] odexBuf, byte[] dexBuf) {
        super(opcodes, dexBuf);
        this.odexBuf = odexBuf;
    }

    @Override
    public boolean isOdexFile() {
        return true;
    }

    public List<String> getDependencies() {
        int dexOffset = OdexHeaderItem.getDexOffset(this.odexBuf);
        int dependencyOffset = OdexHeaderItem.getDependenciesOffset(this.odexBuf) - dexOffset;
        BaseDexBuffer buf = new BaseDexBuffer(this.buf);
        int dependencyCount = buf.readInt(dependencyOffset + 12);
        return new VariableSizeList<String>((DexBackedDexFile)this, dependencyOffset + 16, dependencyCount){

            @Override
            protected String readNextItem(@Nonnull DexReader reader, int index) {
                int length = reader.readInt();
                int offset = reader.getOffset();
                reader.moveRelative(length + 20);
                try {
                    return new String(DexBackedOdexFile.this.buf, offset, length - 1, "US-ASCII");
                }
                catch (UnsupportedEncodingException ex) {
                    throw new RuntimeException(ex);
                }
            }
        };
    }

    public static DexBackedOdexFile fromInputStream(@Nonnull Opcodes opcodes, @Nonnull InputStream is) throws IOException {
        if (!is.markSupported()) {
            throw new IllegalArgumentException("InputStream must support mark");
        }
        is.mark(8);
        byte[] partialHeader = new byte[8];
        try {
            ByteStreams.readFully(is, partialHeader);
        }
        catch (EOFException ex) {
            throw new DexBackedDexFile.NotADexFile("File is too short");
        }
        finally {
            is.reset();
        }
        DexBackedOdexFile.verifyMagic(partialHeader);
        is.reset();
        byte[] odexBuf = new byte[40];
        ByteStreams.readFully(is, odexBuf);
        int dexOffset = OdexHeaderItem.getDexOffset(odexBuf);
        if (dexOffset > 40) {
            ByteStreams.skipFully(is, dexOffset - 40);
        }
        byte[] dexBuf = ByteStreams.toByteArray(is);
        return new DexBackedOdexFile(opcodes, odexBuf, dexBuf);
    }

    private static void verifyMagic(byte[] buf) {
        if (!OdexHeaderItem.verifyMagic(buf)) {
            StringBuilder sb = new StringBuilder("Invalid magic value:");
            for (int i = 0; i < 8; ++i) {
                sb.append(String.format(" %02x", buf[i]));
            }
            throw new NotAnOdexFile(sb.toString());
        }
    }

    public int getOdexVersion() {
        return OdexHeaderItem.getVersion(this.odexBuf);
    }

    public static class NotAnOdexFile
    extends RuntimeException {
        public NotAnOdexFile() {
        }

        public NotAnOdexFile(Throwable cause) {
            super(cause);
        }

        public NotAnOdexFile(String message) {
            super(message);
        }

        public NotAnOdexFile(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

