/*
 * Decompiled with CFR 0.152.
 */
package org.apache.thrift;

import java.util.Collections;
import java.util.Map;
import org.apache.thrift.AsyncProcessFunction;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TAsyncProcessor;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.TProcessor;
import org.apache.thrift.async.AsyncMethodCallback;
import org.apache.thrift.protocol.TMessage;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.server.AbstractNonblockingServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TBaseAsyncProcessor<I>
implements TAsyncProcessor,
TProcessor {
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass().getName());
    final I iface;
    final Map<String, AsyncProcessFunction<I, ? extends TBase, ?>> processMap;

    public TBaseAsyncProcessor(I iface, Map<String, AsyncProcessFunction<I, ? extends TBase, ?>> processMap) {
        this.iface = iface;
        this.processMap = processMap;
    }

    public Map<String, AsyncProcessFunction<I, ? extends TBase, ?>> getProcessMapView() {
        return Collections.unmodifiableMap(this.processMap);
    }

    @Override
    public boolean process(AbstractNonblockingServer.AsyncFrameBuffer fb) throws TException {
        TProtocol in = fb.getInputProtocol();
        TProtocol out = fb.getOutputProtocol();
        TMessage msg = in.readMessageBegin();
        AsyncProcessFunction<I, TBase, ?> fn = this.processMap.get(msg.name);
        if (fn == null) {
            TProtocolUtil.skip(in, (byte)12);
            in.readMessageEnd();
            if (!fn.isOneway()) {
                TApplicationException x = new TApplicationException(1, "Invalid method name: '" + msg.name + "'");
                out.writeMessageBegin(new TMessage(msg.name, 3, msg.seqid));
                x.write(out);
                out.writeMessageEnd();
                out.getTransport().flush();
            }
            fb.responseReady();
            return true;
        }
        TBase args2 = fn.getEmptyArgsInstance();
        try {
            args2.read(in);
        }
        catch (TProtocolException e) {
            in.readMessageEnd();
            if (!fn.isOneway()) {
                TApplicationException x = new TApplicationException(7, e.getMessage());
                out.writeMessageBegin(new TMessage(msg.name, 3, msg.seqid));
                x.write(out);
                out.writeMessageEnd();
                out.getTransport().flush();
            }
            fb.responseReady();
            return true;
        }
        in.readMessageEnd();
        if (fn.isOneway()) {
            fb.responseReady();
        }
        AsyncMethodCallback<?> resultHandler = fn.getResultHandler(fb, msg.seqid);
        try {
            fn.start(this.iface, args2, resultHandler);
        }
        catch (Exception e) {
            resultHandler.onError(e);
        }
        return true;
    }

    @Override
    public boolean process(TProtocol in, TProtocol out) throws TException {
        return false;
    }
}

