/*
 * Decompiled with CFR 0.152.
 */
package no.ntnu.ihb.fmi4j.util;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0010\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\u0011\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0012\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000fR\u0011\u0010\u0013\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000fR\u0011\u0010\u0014\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\fR\u0011\u0010\u0016\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\fR\u0011\u0010\u0018\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\fR\u0011\u0010\u001a\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\fR\u0011\u0010\u001c\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\f\u00a8\u0006\u001e"}, d2={"Lno/ntnu/ihb/fmi4j/util/OsUtil;", "", "()V", "LINUX_FOLDER", "", "LINUX_LIBRARY_EXTENSION", "MAC_OS_FOLDER", "MAC_OS_LIBRARY_EXTENSION", "WINDOWS_FOLDER", "WINDOWS_LIBRARY_EXTENSION", "currentOS", "getCurrentOS", "()Ljava/lang/String;", "is32Bit", "", "()Z", "is64Bit", "isLinux", "isMac", "isWindows", "libExtension", "getLibExtension", "libPrefix", "getLibPrefix", "libraryFolderName", "getLibraryFolderName", "osName", "getOsName", "platformBitness", "getPlatformBitness", "fmi-import"})
public final class OsUtil {
    private static final String MAC_OS_FOLDER = "darwin";
    private static final String WINDOWS_FOLDER = "win";
    private static final String LINUX_FOLDER = "linux";
    private static final String MAC_OS_LIBRARY_EXTENSION = "dylib";
    private static final String WINDOWS_LIBRARY_EXTENSION = "dll";
    private static final String LINUX_LIBRARY_EXTENSION = "so";
    @NotNull
    private static final String osName;
    @NotNull
    private static final String platformBitness;
    public static final OsUtil INSTANCE;

    @NotNull
    public final String getOsName() {
        return osName;
    }

    @NotNull
    public final String getPlatformBitness() {
        return platformBitness;
    }

    public final boolean is32Bit() {
        return Intrinsics.areEqual(platformBitness, "32");
    }

    public final boolean is64Bit() {
        return Intrinsics.areEqual(platformBitness, "64");
    }

    public final boolean isWindows() {
        return StringsKt.startsWith$default(osName, "Windows", false, 2, null);
    }

    public final boolean isLinux() {
        return StringsKt.startsWith$default(osName, "Linux", false, 2, null);
    }

    public final boolean isMac() {
        return StringsKt.startsWith$default(osName, "Mac", false, 2, null) || StringsKt.startsWith$default(osName, "Darwin", false, 2, null);
    }

    @NotNull
    public final String getCurrentOS() {
        String string;
        if (this.isMac()) {
            string = MAC_OS_FOLDER + platformBitness;
        } else if (this.isLinux()) {
            string = LINUX_FOLDER + platformBitness;
        } else if (this.isWindows()) {
            string = WINDOWS_FOLDER + platformBitness;
        } else {
            throw (Throwable)new RuntimeException("Unsupported OS: " + osName);
        }
        return string;
    }

    @NotNull
    public final String getLibPrefix() {
        String string;
        if (this.isMac()) {
            string = "";
        } else if (this.isLinux()) {
            string = "lib";
        } else if (this.isWindows()) {
            string = "";
        } else {
            throw (Throwable)new RuntimeException("Unsupported OS: " + osName);
        }
        return string;
    }

    @NotNull
    public final String getLibExtension() {
        String string;
        if (this.isMac()) {
            string = MAC_OS_LIBRARY_EXTENSION;
        } else if (this.isLinux()) {
            string = LINUX_LIBRARY_EXTENSION;
        } else if (this.isWindows()) {
            string = WINDOWS_LIBRARY_EXTENSION;
        } else {
            throw (Throwable)new RuntimeException("Unsupported OS: " + osName);
        }
        return string;
    }

    @NotNull
    public final String getLibraryFolderName() {
        String string;
        if (this.isWindows()) {
            string = WINDOWS_FOLDER;
        } else if (this.isLinux()) {
            string = LINUX_FOLDER;
        } else if (this.isMac()) {
            string = MAC_OS_FOLDER;
        } else {
            throw (Throwable)new UnsupportedOperationException("OS '" + osName + "' is unsupported!");
        }
        return string;
    }

    private OsUtil() {
    }

    static {
        OsUtil osUtil;
        INSTANCE = osUtil = new OsUtil();
        String string = System.getProperty("os.name");
        Intrinsics.checkExpressionValueIsNotNull(string, "System.getProperty(\"os.name\")");
        osName = string;
        String string2 = System.getProperty("sun.arch.data.model");
        Intrinsics.checkExpressionValueIsNotNull(string2, "System.getProperty(\"sun.arch.data.model\")");
        platformBitness = string2;
    }
}

