"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.VpcEndpointService = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const region_info_1 = require("@aws-cdk/region-info");
const ec2_generated_1 = require("./ec2.generated");
/**
 * A VPC endpoint service.
 *
 * @stability stable
 * @resource AWS::EC2::VPCEndpointService
 */
class VpcEndpointService extends core_1.Resource {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _b, _c, _d, _e;
        super(scope, id);
        if (props.vpcEndpointServiceLoadBalancers === undefined || props.vpcEndpointServiceLoadBalancers.length === 0) {
            throw new Error('VPC Endpoint Service must have at least one load balancer specified.');
        }
        this.vpcEndpointServiceLoadBalancers = props.vpcEndpointServiceLoadBalancers;
        this.acceptanceRequired = (_b = props.acceptanceRequired) !== null && _b !== void 0 ? _b : true;
        if (props.allowedPrincipals && props.whitelistedPrincipals) {
            throw new Error('`whitelistedPrincipals` is deprecated; please use `allowedPrincipals` instead');
        }
        this.allowedPrincipals = (_d = (_c = props.allowedPrincipals) !== null && _c !== void 0 ? _c : props.whitelistedPrincipals) !== null && _d !== void 0 ? _d : [];
        this.whitelistedPrincipals = this.allowedPrincipals;
        this.endpointService = new ec2_generated_1.CfnVPCEndpointService(this, id, {
            networkLoadBalancerArns: this.vpcEndpointServiceLoadBalancers.map(lb => lb.loadBalancerArn),
            acceptanceRequired: this.acceptanceRequired,
        });
        this.vpcEndpointServiceId = this.endpointService.ref;
        const { region } = core_1.Stack.of(this);
        const serviceNamePrefix = !core_1.Token.isUnresolved(region) ?
            ((_e = region_info_1.RegionInfo.get(region).vpcEndpointServiceNamePrefix) !== null && _e !== void 0 ? _e : region_info_1.Default.VPC_ENDPOINT_SERVICE_NAME_PREFIX) :
            region_info_1.Default.VPC_ENDPOINT_SERVICE_NAME_PREFIX;
        this.vpcEndpointServiceName = core_1.Fn.join('.', [serviceNamePrefix, core_1.Aws.REGION, this.vpcEndpointServiceId]);
        if (this.allowedPrincipals.length > 0) {
            new ec2_generated_1.CfnVPCEndpointServicePermissions(this, 'Permissions', {
                serviceId: this.endpointService.ref,
                allowedPrincipals: this.allowedPrincipals.map(x => x.arn),
            });
        }
    }
}
exports.VpcEndpointService = VpcEndpointService;
_a = JSII_RTTI_SYMBOL_1;
VpcEndpointService[_a] = { fqn: "@aws-cdk/aws-ec2.VpcEndpointService", version: "1.127.0" };
//# sourceMappingURL=data:application/json;base64,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