# Generated by Django 3.1 on 2020-08-21 15:09

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import isc_common.fields.code_field
import isc_common.fields.related


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('ckk', '0248_auto_20200821_1509'),
        ('production', '0318_auto_20200820_0312'),
        ('planing', '0227_auto_20200820_0559'),
    ]

    operations = [
        migrations.CreateModel(
            name='Tmp_operation_value_view',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False, verbose_name='Идентификатор')),
                ('deleted_at', models.DateTimeField(blank=True, db_index=True, null=True, verbose_name='Дата мягкого удаления')),
                ('editing', models.BooleanField(default=True, verbose_name='Возможность редактирования')),
                ('deliting', models.BooleanField(default=True, verbose_name='Возможность удаления')),
                ('lastmodified', models.DateTimeField(db_index=True, default=django.utils.timezone.now, editable=False, verbose_name='Последнее обновление')),
                ('value_sum', models.DecimalField(decimal_places=4, max_digits=19, verbose_name='Количество по документации')),
                ('value_odd', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True, verbose_name='Количество Остаток')),
                ('value1_sum', models.DecimalField(decimal_places=4, max_digits=19, verbose_name='Количество на еденицу продукции')),
                ('section', isc_common.fields.code_field.CodeField(blank=True, null=True)),
                ('isFolder', models.BooleanField()),
                ('value', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True, verbose_name='Кроличество на комплектацию')),
            ],
            options={
                'verbose_name': 'Временное хранилище для занесения выполнения',
                'db_table': 'planing_tmp_operation_value_view',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='Tmp_operation_value',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False, verbose_name='Идентификатор')),
                ('deleted_at', models.DateTimeField(blank=True, db_index=True, null=True, verbose_name='Дата мягкого удаления')),
                ('editing', models.BooleanField(default=True, verbose_name='Возможность редактирования')),
                ('deliting', models.BooleanField(default=True, verbose_name='Возможность удаления')),
                ('lastmodified', models.DateTimeField(db_index=True, default=django.utils.timezone.now, editable=False, verbose_name='Последнее обновление')),
                ('value', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('child', isc_common.fields.related.ForeignKeyCascade(on_delete=django.db.models.deletion.CASCADE, related_name='Tmp_operation_value_child', to='ckk.item')),
                ('launch', isc_common.fields.related.ForeignKeyCascade(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='production.launches')),
                ('parent', isc_common.fields.related.ForeignKeyCascade(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='Tmp_operation_value_parent', to='ckk.item')),
                ('user', isc_common.fields.related.ForeignKeyCascade(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'Временное хранилище для занесения выполнения',
            },
        ),
        migrations.AddConstraint(
            model_name='tmp_operation_value',
            constraint=models.UniqueConstraint(condition=models.Q(parent=None), fields=('child', 'launch', 'user'), name='Tmp_operation_value_unique_constraint_0'),
        ),
        migrations.AddConstraint(
            model_name='tmp_operation_value',
            constraint=models.UniqueConstraint(fields=('child', 'launch', 'parent', 'user'), name='Tmp_operation_value_unique_constraint_1'),
        ),
    ]
