#!/usr/bin/env python3
#
# This file is execfile()d with the current directory set to its containing
# dir.
#
# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#
import os
import sys
import sphinx_rtd_theme
sys.path.insert(0, os.path.abspath('..'))

import parser201

# -- General configuration ---------------------------------------------

# If documentation needs a minimal Sphinx version, state it here.
# needs_sphinx = '1.0'

# Extensions
extensions = [
   'sphinx.ext.autodoc',
   'sphinx.ext.viewcode',
   'sphinx_rtd_theme'
]

# Paths that contain templates here, relative to this directory.
templates_path = [
   '_templates'
]

# Auto doc flags
autodoc_default_flags = [
   'members',
   'undoc-members',
   'special-members'
]

# Suffix(es) of source filenames. Specify multiple suffix as a list of string:
# source_suffix = ['.rst', '.md']
source_suffix = [
   '.rst'
]

# The master toctree document.
master_doc = 'index'

# General information about the project.
project   = 'parser201'
copyright = "2020, Peter Nardi"
author    = "Peter Nardi"

# Version info for the project; acts as replacement for |version| and
# |release|, also used in various other places throughout the built documents.
# 
# The short X.Y version.
version = parser201.__version__
# The full version, including alpha/beta/rc tags.
release = parser201.__version__

# The language for content autogenerated by Sphinx. Refer to documentation for
# a list of supported languages. This is also used if you do content
# translation via gettext catalogs. Usually you set "language" from the command
# line for these cases.
language = None

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files. This patterns also
# effect to html_static_path and html_extra_path
exclude_patterns = [
   '_build',
   'Thumbs.db',
   '.DS_Store'
]

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = 'sphinx'

# If true, `todo` and `todoList` produce output, else they produce nothing.
todo_include_todos = False

# -- Options for HTML output -------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for a
# list of builtin themes.
html_theme = 'sphinx_rtd_theme'

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
# html_theme_options = {}

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
# html_static_path = ['_static']
html_static_path = []

# -- Options for HTMLHelp output ---------------------------------------

# Output file base name for HTML help builder.
htmlhelp_basename = 'parser201doc'

# -- Options for LaTeX output ------------------------------------------

latex_elements = {
    # The paper size ('letterpaper' or 'a4paper').
    #
    # 'papersize': 'letterpaper',

    # The font size ('10pt', '11pt' or '12pt').
    #
    # 'pointsize': '10pt',

    # Additional stuff for the LaTeX preamble.
    #
    # 'preamble': '',

    # Latex figure (float) alignment
    #
    # 'figure_align': 'htbp',
}

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title, author, documentclass
# [howto, manual, or own class]).
latex_documents = [
    (master_doc, 'parser201.tex',
     'parser201 Documentation',
     'Peter Nardi', 'manual'),
]


# -- Options for manual page output ------------------------------------

# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
man_pages = [
    (master_doc, 'parser201',
     'parser201 Documentation',
     [author], 1)
]


# -- Options for Texinfo output ----------------------------------------

# Grouping the document tree into Texinfo files. List of tuples
# (source start file, target name, title, author,
#  dir menu entry, description, category)
texinfo_documents = [
    (master_doc, 'parser201',
     'parser201 Documentation',
     author,
     'parser201',
     'One line description of project.',
     'Miscellaneous'),
]
