# This an autogenerated file
# 
# Generated with WorkflowContainerPackage
from __future__ import annotations
from typing import Dict,Sequence,List
from dmt.entity import Entity
from dmt.blueprint import Blueprint
from .blueprints.workflowcontainerpackage import WorkflowContainerPackageBlueprint
from sima.sima.moao import MOAO
from sima.sima.scriptablevalue import ScriptableValue
from sima.workflow.workflow import Workflow

class WorkflowContainerPackage(MOAO):
    """
    Keyword arguments
    -----------------
    name : str
         (default "")
    description : str
         (default "")
    _id : str
         (default "")
    scriptableValues : List[ScriptableValue]
    packages : List[WorkflowContainerPackage]
    workflows : List[Workflow]
    visible : bool
         Make all workflows directly contained in this package visible outside of the task(default False)
    """

    def __init__(self , name:str="", description:str="", _id:str="", visible:bool=False, **kwargs):
        super().__init__(**kwargs)
        self.__name = name
        self.__description = description
        self.___id = _id
        self.__scriptableValues = list()
        self.__packages = list()
        self.__workflows = list()
        self.__visible = visible
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return WorkflowContainerPackageBlueprint()


    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = str(value)

    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = str(value)

    @property
    def _id(self) -> str:
        """"""
        return self.___id

    @_id.setter
    def _id(self, value: str):
        """Set _id"""
        self.___id = str(value)

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def packages(self) -> List[WorkflowContainerPackage]:
        """"""
        return self.__packages

    @packages.setter
    def packages(self, value: List[WorkflowContainerPackage]):
        """Set packages"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__packages = value

    @property
    def workflows(self) -> List[Workflow]:
        """"""
        return self.__workflows

    @workflows.setter
    def workflows(self, value: List[Workflow]):
        """Set workflows"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__workflows = value

    @property
    def visible(self) -> bool:
        """Make all workflows directly contained in this package visible outside of the task"""
        return self.__visible

    @visible.setter
    def visible(self, value: bool):
        """Set visible"""
        self.__visible = bool(value)
