# This an autogenerated file
# 
# Generated with WamitBody
from typing import Dict,Sequence,List
from dmt.entity import Entity
from dmt.blueprint import Blueprint
from .blueprints.wamitbody import WamitBodyBlueprint
from sima.hydro.hydrostaticstiffnessmatrix import HydrostaticStiffnessMatrix
from sima.hydro.lineardampingmatrix import LinearDampingMatrix
from sima.hydro.massmatrix import MassMatrix
from sima.sima.appearance import Appearance
from sima.sima.body import Body
from sima.sima.bodyviewpoint import BodyViewpoint
from sima.sima.point3 import Point3
from sima.sima.position import Position
from sima.sima.scriptablevalue import ScriptableValue
from sima.wamit.directionsofnormalsoption import DirectionsOfNormalsOption
from sima.wamit.evaluationmodeoption import EvaluationModeOption
from sima.wamit.modesofmotion import ModesOfMotion
from sima.wamit.parameterlines import ParameterLines
from sima.wamit.removeirregularfrequenciesoption import RemoveIrregularFrequenciesOption
from sima.wamit.surfacestoincludefromms2fileoption import SurfacesToIncludeFromMs2FileOption
from sima.wamit.wamitcontrolsurface import WamitControlSurface

class WamitBody(Body):
    """
    Keyword arguments
    -----------------
    name : str
         (default "")
    description : str
         (default "")
    _id : str
         (default "")
    scriptableValues : List[ScriptableValue]
    length : float
         Length(default 10.0)
    width : float
         Width(default 5.0)
    height : float
         Height(default 5.0)
    appearance : Appearance
    initialPosition : Position
    viewpoints : List[BodyViewpoint]
    geometryFilename : str
         GDF Geometry(default "")
    surfacesToIncludeFromMs2File : SurfacesToIncludeFromMs2FileOption
    symmetryAboutX : bool
         (default False)
    symmetryAboutY : bool
         (default False)
    entitySelectionList : str
         (default "")
    evaluationMode : EvaluationModeOption
    divisionsMultiplier : int
         (default 0)
    directionOfNormals : DirectionsOfNormalsOption
    parameterLines : List[ParameterLines]
    cog : Point3
         Coordinates of centre of gravity, (L)
    massData : MassMatrix
    externalStiffness : HydrostaticStiffnessMatrix
    linearDamping : LinearDampingMatrix
    includeExternalDampingMatrix : bool
         Use external damping(default False)
    includeExternalStiffnessMatrix : bool
         Use external stiffness(default False)
    includeExternalMassMatrix : bool
         Use external mass matrix(default False)
    modes : ModesOfMotion
    characteristicLength : float
         Characteristic Length (ULEN)(default 1.0)
    controlSurface : WamitControlSurface
    removeIrregularFrequencies : RemoveIrregularFrequenciesOption
    trimWaterline : bool
         The static orientation of the body is shifted relative to the horizontal plane of the free surface, first by a prescribed vertical elevation, then by a pitch angle (often referred to as the trim angle), and then by a roll angle (heel).(default False)
    draftChange : float
         (default 0.0)
    heelChange : float
         (default 0.0)
    trimChange : float
         (default 0.0)
    """

    def __init__(self , name:str="", description:str="", _id:str="", length:float=10.0, width:float=5.0, height:float=5.0, geometryFilename:str="", surfacesToIncludeFromMs2File:SurfacesToIncludeFromMs2FileOption=SurfacesToIncludeFromMs2FileOption.ALLVISIBLESURFACES, symmetryAboutX:bool=False, symmetryAboutY:bool=False, entitySelectionList:str="", evaluationMode:EvaluationModeOption=EvaluationModeOption.FAST, divisionsMultiplier:int=0, directionOfNormals:DirectionsOfNormalsOption=DirectionsOfNormalsOption.OUTWARD, includeExternalDampingMatrix:bool=False, includeExternalStiffnessMatrix:bool=False, includeExternalMassMatrix:bool=False, characteristicLength:float=1.0, removeIrregularFrequencies:RemoveIrregularFrequenciesOption=RemoveIrregularFrequenciesOption.NO, trimWaterline:bool=False, draftChange:float=0.0, heelChange:float=0.0, trimChange:float=0.0, **kwargs):
        super().__init__(**kwargs)
        self.__name = name
        self.__description = description
        self.___id = _id
        self.__scriptableValues = list()
        self.__length = length
        self.__width = width
        self.__height = height
        self.__appearance = Appearance()
        self.__initialPosition = Position()
        self.__viewpoints = list()
        self.__geometryFilename = geometryFilename
        self.__surfacesToIncludeFromMs2File = surfacesToIncludeFromMs2File
        self.__symmetryAboutX = symmetryAboutX
        self.__symmetryAboutY = symmetryAboutY
        self.__entitySelectionList = entitySelectionList
        self.__evaluationMode = evaluationMode
        self.__divisionsMultiplier = divisionsMultiplier
        self.__directionOfNormals = directionOfNormals
        self.__parameterLines = list()
        self.__cog = Point3()
        self.__massData = MassMatrix()
        self.__externalStiffness = HydrostaticStiffnessMatrix()
        self.__linearDamping = LinearDampingMatrix()
        self.__includeExternalDampingMatrix = includeExternalDampingMatrix
        self.__includeExternalStiffnessMatrix = includeExternalStiffnessMatrix
        self.__includeExternalMassMatrix = includeExternalMassMatrix
        self.__modes = ModesOfMotion()
        self.__characteristicLength = characteristicLength
        self.__controlSurface = None
        self.__removeIrregularFrequencies = removeIrregularFrequencies
        self.__trimWaterline = trimWaterline
        self.__draftChange = draftChange
        self.__heelChange = heelChange
        self.__trimChange = trimChange
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return WamitBodyBlueprint()


    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = str(value)

    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = str(value)

    @property
    def _id(self) -> str:
        """"""
        return self.___id

    @_id.setter
    def _id(self, value: str):
        """Set _id"""
        self.___id = str(value)

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def length(self) -> float:
        """Length"""
        return self.__length

    @length.setter
    def length(self, value: float):
        """Set length"""
        self.__length = float(value)

    @property
    def width(self) -> float:
        """Width"""
        return self.__width

    @width.setter
    def width(self, value: float):
        """Set width"""
        self.__width = float(value)

    @property
    def height(self) -> float:
        """Height"""
        return self.__height

    @height.setter
    def height(self, value: float):
        """Set height"""
        self.__height = float(value)

    @property
    def appearance(self) -> Appearance:
        """"""
        return self.__appearance

    @appearance.setter
    def appearance(self, value: Appearance):
        """Set appearance"""
        self.__appearance = value

    @property
    def initialPosition(self) -> Position:
        """"""
        return self.__initialPosition

    @initialPosition.setter
    def initialPosition(self, value: Position):
        """Set initialPosition"""
        self.__initialPosition = value

    @property
    def viewpoints(self) -> List[BodyViewpoint]:
        """"""
        return self.__viewpoints

    @viewpoints.setter
    def viewpoints(self, value: List[BodyViewpoint]):
        """Set viewpoints"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__viewpoints = value

    @property
    def geometryFilename(self) -> str:
        """GDF Geometry"""
        return self.__geometryFilename

    @geometryFilename.setter
    def geometryFilename(self, value: str):
        """Set geometryFilename"""
        self.__geometryFilename = str(value)

    @property
    def surfacesToIncludeFromMs2File(self) -> SurfacesToIncludeFromMs2FileOption:
        """"""
        return self.__surfacesToIncludeFromMs2File

    @surfacesToIncludeFromMs2File.setter
    def surfacesToIncludeFromMs2File(self, value: SurfacesToIncludeFromMs2FileOption):
        """Set surfacesToIncludeFromMs2File"""
        self.__surfacesToIncludeFromMs2File = value

    @property
    def symmetryAboutX(self) -> bool:
        """"""
        return self.__symmetryAboutX

    @symmetryAboutX.setter
    def symmetryAboutX(self, value: bool):
        """Set symmetryAboutX"""
        self.__symmetryAboutX = bool(value)

    @property
    def symmetryAboutY(self) -> bool:
        """"""
        return self.__symmetryAboutY

    @symmetryAboutY.setter
    def symmetryAboutY(self, value: bool):
        """Set symmetryAboutY"""
        self.__symmetryAboutY = bool(value)

    @property
    def entitySelectionList(self) -> str:
        """"""
        return self.__entitySelectionList

    @entitySelectionList.setter
    def entitySelectionList(self, value: str):
        """Set entitySelectionList"""
        self.__entitySelectionList = str(value)

    @property
    def evaluationMode(self) -> EvaluationModeOption:
        """"""
        return self.__evaluationMode

    @evaluationMode.setter
    def evaluationMode(self, value: EvaluationModeOption):
        """Set evaluationMode"""
        self.__evaluationMode = value

    @property
    def divisionsMultiplier(self) -> int:
        """"""
        return self.__divisionsMultiplier

    @divisionsMultiplier.setter
    def divisionsMultiplier(self, value: int):
        """Set divisionsMultiplier"""
        self.__divisionsMultiplier = int(value)

    @property
    def directionOfNormals(self) -> DirectionsOfNormalsOption:
        """"""
        return self.__directionOfNormals

    @directionOfNormals.setter
    def directionOfNormals(self, value: DirectionsOfNormalsOption):
        """Set directionOfNormals"""
        self.__directionOfNormals = value

    @property
    def parameterLines(self) -> List[ParameterLines]:
        """"""
        return self.__parameterLines

    @parameterLines.setter
    def parameterLines(self, value: List[ParameterLines]):
        """Set parameterLines"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__parameterLines = value

    @property
    def cog(self) -> Point3:
        """Coordinates of centre of gravity, (L)"""
        return self.__cog

    @cog.setter
    def cog(self, value: Point3):
        """Set cog"""
        self.__cog = value

    @property
    def massData(self) -> MassMatrix:
        """"""
        return self.__massData

    @massData.setter
    def massData(self, value: MassMatrix):
        """Set massData"""
        self.__massData = value

    @property
    def externalStiffness(self) -> HydrostaticStiffnessMatrix:
        """"""
        return self.__externalStiffness

    @externalStiffness.setter
    def externalStiffness(self, value: HydrostaticStiffnessMatrix):
        """Set externalStiffness"""
        self.__externalStiffness = value

    @property
    def linearDamping(self) -> LinearDampingMatrix:
        """"""
        return self.__linearDamping

    @linearDamping.setter
    def linearDamping(self, value: LinearDampingMatrix):
        """Set linearDamping"""
        self.__linearDamping = value

    @property
    def includeExternalDampingMatrix(self) -> bool:
        """Use external damping"""
        return self.__includeExternalDampingMatrix

    @includeExternalDampingMatrix.setter
    def includeExternalDampingMatrix(self, value: bool):
        """Set includeExternalDampingMatrix"""
        self.__includeExternalDampingMatrix = bool(value)

    @property
    def includeExternalStiffnessMatrix(self) -> bool:
        """Use external stiffness"""
        return self.__includeExternalStiffnessMatrix

    @includeExternalStiffnessMatrix.setter
    def includeExternalStiffnessMatrix(self, value: bool):
        """Set includeExternalStiffnessMatrix"""
        self.__includeExternalStiffnessMatrix = bool(value)

    @property
    def includeExternalMassMatrix(self) -> bool:
        """Use external mass matrix"""
        return self.__includeExternalMassMatrix

    @includeExternalMassMatrix.setter
    def includeExternalMassMatrix(self, value: bool):
        """Set includeExternalMassMatrix"""
        self.__includeExternalMassMatrix = bool(value)

    @property
    def modes(self) -> ModesOfMotion:
        """"""
        return self.__modes

    @modes.setter
    def modes(self, value: ModesOfMotion):
        """Set modes"""
        self.__modes = value

    @property
    def characteristicLength(self) -> float:
        """Characteristic Length (ULEN)"""
        return self.__characteristicLength

    @characteristicLength.setter
    def characteristicLength(self, value: float):
        """Set characteristicLength"""
        self.__characteristicLength = float(value)

    @property
    def controlSurface(self) -> WamitControlSurface:
        """"""
        return self.__controlSurface

    @controlSurface.setter
    def controlSurface(self, value: WamitControlSurface):
        """Set controlSurface"""
        self.__controlSurface = value

    @property
    def removeIrregularFrequencies(self) -> RemoveIrregularFrequenciesOption:
        """"""
        return self.__removeIrregularFrequencies

    @removeIrregularFrequencies.setter
    def removeIrregularFrequencies(self, value: RemoveIrregularFrequenciesOption):
        """Set removeIrregularFrequencies"""
        self.__removeIrregularFrequencies = value

    @property
    def trimWaterline(self) -> bool:
        """The static orientation of the body is shifted relative to the horizontal plane of the free surface, first by a prescribed vertical elevation, then by a pitch angle (often referred to as the trim angle), and then by a roll angle (heel)."""
        return self.__trimWaterline

    @trimWaterline.setter
    def trimWaterline(self, value: bool):
        """Set trimWaterline"""
        self.__trimWaterline = bool(value)

    @property
    def draftChange(self) -> float:
        """"""
        return self.__draftChange

    @draftChange.setter
    def draftChange(self, value: float):
        """Set draftChange"""
        self.__draftChange = float(value)

    @property
    def heelChange(self) -> float:
        """"""
        return self.__heelChange

    @heelChange.setter
    def heelChange(self, value: float):
        """Set heelChange"""
        self.__heelChange = float(value)

    @property
    def trimChange(self) -> float:
        """"""
        return self.__trimChange

    @trimChange.setter
    def trimChange(self, value: float):
        """Set trimChange"""
        self.__trimChange = float(value)
