# This an autogenerated file
# 
# Generated with Winch
from typing import Dict,Sequence,List
from dmt.entity import Entity
from dmt.blueprint import Blueprint
from .blueprints.winch import WinchBlueprint
from sima.sima.namedobject import NamedObject
from sima.sima.scriptablevalue import ScriptableValue
from sima.simo.winchcontrol import WinchControl
from sima.simo.winchruninterval import WinchRunInterval

class Winch(NamedObject):
    """
    Keyword arguments
    -----------------
    name : str
         (default "")
    description : str
         (default "")
    _id : str
         (default "")
    scriptableValues : List[ScriptableValue]
    controlType : WinchControl
         Type of coupling winch control
    maximumSpeed : float
         Max. run velocity for winch(default 0.0)
    acceleration : float
         Max. run acceleration for winch(default 0.0)
    maximumLength : float
         Max. wire length that can be added to drum(default 0.0)
    drumLength : float
         Initial wire length at drum(default 0.0)
    intervals : List[WinchRunInterval]
    """

    def __init__(self , name:str="", description:str="", _id:str="", controlType:WinchControl=WinchControl.PREDEFINED, maximumSpeed:float=0.0, acceleration:float=0.0, maximumLength:float=0.0, drumLength:float=0.0, **kwargs):
        super().__init__(**kwargs)
        self.__name = name
        self.__description = description
        self.___id = _id
        self.__scriptableValues = list()
        self.__controlType = controlType
        self.__maximumSpeed = maximumSpeed
        self.__acceleration = acceleration
        self.__maximumLength = maximumLength
        self.__drumLength = drumLength
        self.__intervals = list()
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return WinchBlueprint()


    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = str(value)

    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = str(value)

    @property
    def _id(self) -> str:
        """"""
        return self.___id

    @_id.setter
    def _id(self, value: str):
        """Set _id"""
        self.___id = str(value)

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def controlType(self) -> WinchControl:
        """Type of coupling winch control"""
        return self.__controlType

    @controlType.setter
    def controlType(self, value: WinchControl):
        """Set controlType"""
        self.__controlType = value

    @property
    def maximumSpeed(self) -> float:
        """Max. run velocity for winch"""
        return self.__maximumSpeed

    @maximumSpeed.setter
    def maximumSpeed(self, value: float):
        """Set maximumSpeed"""
        self.__maximumSpeed = float(value)

    @property
    def acceleration(self) -> float:
        """Max. run acceleration for winch"""
        return self.__acceleration

    @acceleration.setter
    def acceleration(self, value: float):
        """Set acceleration"""
        self.__acceleration = float(value)

    @property
    def maximumLength(self) -> float:
        """Max. wire length that can be added to drum"""
        return self.__maximumLength

    @maximumLength.setter
    def maximumLength(self, value: float):
        """Set maximumLength"""
        self.__maximumLength = float(value)

    @property
    def drumLength(self) -> float:
        """Initial wire length at drum"""
        return self.__drumLength

    @drumLength.setter
    def drumLength(self, value: float):
        """Set drumLength"""
        self.__drumLength = float(value)

    @property
    def intervals(self) -> List[WinchRunInterval]:
        """"""
        return self.__intervals

    @intervals.setter
    def intervals(self, value: List[WinchRunInterval]):
        """Set intervals"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__intervals = value
