# This an autogenerated file
# 
# Generated with ThrusterControl
from __future__ import annotations
from typing import Dict,Sequence,List
from dmt.entity import Entity
from dmt.blueprint import Blueprint
from .blueprints.thrustercontrol import ThrusterControlBlueprint
from sima.sima.moao import MOAO
from sima.sima.scriptablevalue import ScriptableValue
from sima.simo.dpthrustertype import DPThrusterType
from typing import TYPE_CHECKING
if TYPE_CHECKING:
    from sima.simo.ithruster import IThruster

class ThrusterControl(MOAO):
    """
    Keyword arguments
    -----------------
    name : str
         (default "")
    description : str
         (default "")
    _id : str
         (default "")
    scriptableValues : List[ScriptableValue]
    thruster : IThruster
         Thruster to be controlled
    thrusterControlType : DPThrusterType
         Thruster control type
    direction : float
         Direction of thruster. Start value for azimuthing thrusters.(default 0.0)
    minForce : float
         Minimum force(default 0.0)
    maxForce : float
         Maximum force(default 0.0)
    maxForceRate : float
         Maximum rate of force(default 0.0)
    maxAngleRate : float
         Maximum rate of azimuth angle(default 0.0)
    x : float
         X-coordinate of thruster in body system(default 0.0)
    y : float
         Y-coordinate of thruster in body system(default 0.0)
    z : float
         Z-coordinate of thruster in body system(default 0.0)
    """

    def __init__(self , name:str="", description:str="", _id:str="", thrusterControlType:DPThrusterType=DPThrusterType.FIXED, direction:float=0.0, minForce:float=0.0, maxForce:float=0.0, maxForceRate:float=0.0, maxAngleRate:float=0.0, x:float=0.0, y:float=0.0, z:float=0.0, **kwargs):
        super().__init__(**kwargs)
        self.__name = name
        self.__description = description
        self.___id = _id
        self.__scriptableValues = list()
        self.__thruster = None
        self.__thrusterControlType = thrusterControlType
        self.__direction = direction
        self.__minForce = minForce
        self.__maxForce = maxForce
        self.__maxForceRate = maxForceRate
        self.__maxAngleRate = maxAngleRate
        self.__x = x
        self.__y = y
        self.__z = z
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return ThrusterControlBlueprint()


    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = str(value)

    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = str(value)

    @property
    def _id(self) -> str:
        """"""
        return self.___id

    @_id.setter
    def _id(self, value: str):
        """Set _id"""
        self.___id = str(value)

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def thruster(self) -> IThruster:
        """Thruster to be controlled"""
        return self.__thruster

    @thruster.setter
    def thruster(self, value: IThruster):
        """Set thruster"""
        self.__thruster = value

    @property
    def thrusterControlType(self) -> DPThrusterType:
        """Thruster control type"""
        return self.__thrusterControlType

    @thrusterControlType.setter
    def thrusterControlType(self, value: DPThrusterType):
        """Set thrusterControlType"""
        self.__thrusterControlType = value

    @property
    def direction(self) -> float:
        """Direction of thruster. Start value for azimuthing thrusters."""
        return self.__direction

    @direction.setter
    def direction(self, value: float):
        """Set direction"""
        self.__direction = float(value)

    @property
    def minForce(self) -> float:
        """Minimum force"""
        return self.__minForce

    @minForce.setter
    def minForce(self, value: float):
        """Set minForce"""
        self.__minForce = float(value)

    @property
    def maxForce(self) -> float:
        """Maximum force"""
        return self.__maxForce

    @maxForce.setter
    def maxForce(self, value: float):
        """Set maxForce"""
        self.__maxForce = float(value)

    @property
    def maxForceRate(self) -> float:
        """Maximum rate of force"""
        return self.__maxForceRate

    @maxForceRate.setter
    def maxForceRate(self, value: float):
        """Set maxForceRate"""
        self.__maxForceRate = float(value)

    @property
    def maxAngleRate(self) -> float:
        """Maximum rate of azimuth angle"""
        return self.__maxAngleRate

    @maxAngleRate.setter
    def maxAngleRate(self, value: float):
        """Set maxAngleRate"""
        self.__maxAngleRate = float(value)

    @property
    def x(self) -> float:
        """X-coordinate of thruster in body system"""
        return self.__x

    @x.setter
    def x(self, value: float):
        """Set x"""
        self.__x = float(value)

    @property
    def y(self) -> float:
        """Y-coordinate of thruster in body system"""
        return self.__y

    @y.setter
    def y(self, value: float):
        """Set y"""
        self.__y = float(value)

    @property
    def z(self) -> float:
        """Z-coordinate of thruster in body system"""
        return self.__z

    @z.setter
    def z(self, value: float):
        """Set z"""
        self.__z = float(value)
