# This an autogenerated file
# 
# Generated with SpecifiedForce
from typing import Dict,Sequence,List
from dmt.entity import Entity
from dmt.blueprint import Blueprint
from .blueprints.specifiedforce import SpecifiedForceBlueprint
from sima.sima.namedobject import NamedObject
from sima.sima.point3 import Point3
from sima.sima.scriptablevalue import ScriptableValue
from sima.sima.vector3 import Vector3
from sima.simo.referenceframetype import ReferenceFrameType
from sima.simo.specifiedloadtype import SpecifiedLoadType

class SpecifiedForce(NamedObject):
    """
    Keyword arguments
    -----------------
    name : str
         (default "")
    description : str
         (default "")
    _id : str
         (default "")
    scriptableValues : List[ScriptableValue]
    referenceFrame : ReferenceFrameType
         Direction vector in local or global coordinate system
    directionVector : Vector3
    activationTime : float
         Time for switching component on(default 0.0)
    deactivationTime : float
         Time for switching component off(default 100000.0)
    loadType : SpecifiedLoadType
    period : float
         (default 0.0)
    phase : float
         (default 0.0)
    magnitude : float
         Force component magnitude parameter(default 0.0)
    forceDerivative : float
         Force component force derivative parameter(default 0.0)
    attachmentPoint : Point3
    """

    def __init__(self , name:str="", description:str="", _id:str="", referenceFrame:ReferenceFrameType=ReferenceFrameType.LOCAL, activationTime:float=0.0, deactivationTime:float=100000.0, loadType:SpecifiedLoadType=SpecifiedLoadType.CONSTANT, period:float=0.0, phase:float=0.0, magnitude:float=0.0, forceDerivative:float=0.0, **kwargs):
        super().__init__(**kwargs)
        self.__name = name
        self.__description = description
        self.___id = _id
        self.__scriptableValues = list()
        self.__referenceFrame = referenceFrame
        self.__directionVector = Vector3()
        self.__activationTime = activationTime
        self.__deactivationTime = deactivationTime
        self.__loadType = loadType
        self.__period = period
        self.__phase = phase
        self.__magnitude = magnitude
        self.__forceDerivative = forceDerivative
        self.__attachmentPoint = Point3()
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return SpecifiedForceBlueprint()


    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = str(value)

    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = str(value)

    @property
    def _id(self) -> str:
        """"""
        return self.___id

    @_id.setter
    def _id(self, value: str):
        """Set _id"""
        self.___id = str(value)

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def referenceFrame(self) -> ReferenceFrameType:
        """Direction vector in local or global coordinate system"""
        return self.__referenceFrame

    @referenceFrame.setter
    def referenceFrame(self, value: ReferenceFrameType):
        """Set referenceFrame"""
        self.__referenceFrame = value

    @property
    def directionVector(self) -> Vector3:
        """"""
        return self.__directionVector

    @directionVector.setter
    def directionVector(self, value: Vector3):
        """Set directionVector"""
        self.__directionVector = value

    @property
    def activationTime(self) -> float:
        """Time for switching component on"""
        return self.__activationTime

    @activationTime.setter
    def activationTime(self, value: float):
        """Set activationTime"""
        self.__activationTime = float(value)

    @property
    def deactivationTime(self) -> float:
        """Time for switching component off"""
        return self.__deactivationTime

    @deactivationTime.setter
    def deactivationTime(self, value: float):
        """Set deactivationTime"""
        self.__deactivationTime = float(value)

    @property
    def loadType(self) -> SpecifiedLoadType:
        """"""
        return self.__loadType

    @loadType.setter
    def loadType(self, value: SpecifiedLoadType):
        """Set loadType"""
        self.__loadType = value

    @property
    def period(self) -> float:
        """"""
        return self.__period

    @period.setter
    def period(self, value: float):
        """Set period"""
        self.__period = float(value)

    @property
    def phase(self) -> float:
        """"""
        return self.__phase

    @phase.setter
    def phase(self, value: float):
        """Set phase"""
        self.__phase = float(value)

    @property
    def magnitude(self) -> float:
        """Force component magnitude parameter"""
        return self.__magnitude

    @magnitude.setter
    def magnitude(self, value: float):
        """Set magnitude"""
        self.__magnitude = float(value)

    @property
    def forceDerivative(self) -> float:
        """Force component force derivative parameter"""
        return self.__forceDerivative

    @forceDerivative.setter
    def forceDerivative(self, value: float):
        """Set forceDerivative"""
        self.__forceDerivative = float(value)

    @property
    def attachmentPoint(self) -> Point3:
        """"""
        return self.__attachmentPoint

    @attachmentPoint.setter
    def attachmentPoint(self, value: Point3):
        """Set attachmentPoint"""
        self.__attachmentPoint = value
