# This an autogenerated file
# 
# Generated with SoilFrictionElement
from typing import Dict,Sequence,List
from dmt.entity import Entity
from dmt.blueprint import Blueprint
from .blueprints.soilfrictionelement import SoilFrictionElementBlueprint
from sima.sima.moao import MOAO
from sima.sima.scriptablevalue import ScriptableValue

class SoilFrictionElement(MOAO):
    """
    Keyword arguments
    -----------------
    name : str
         (default "")
    description : str
         (default "")
    _id : str
         (default "")
    scriptableValues : List[ScriptableValue]
    dfric : float
         Penetration relative to ZCONT (positive upwards)(default 0.0)
    ftipdo : float
         Depth dependent friction force for DOWNward motion(default 0.0)
    ftipup : float
         Depth dependent friction force for UPward motion(default 0.0)
    fwall : float
         Depth dependent friction force for both upwards and\ndownwards motion(default 0.0)
    frich : float
         Depth dependent friction force in horizontal direction (>=0)(default 0.0)
    """

    def __init__(self , name:str="", description:str="", _id:str="", dfric:float=0.0, ftipdo:float=0.0, ftipup:float=0.0, fwall:float=0.0, frich:float=0.0, **kwargs):
        super().__init__(**kwargs)
        self.__name = name
        self.__description = description
        self.___id = _id
        self.__scriptableValues = list()
        self.__dfric = dfric
        self.__ftipdo = ftipdo
        self.__ftipup = ftipup
        self.__fwall = fwall
        self.__frich = frich
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return SoilFrictionElementBlueprint()


    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = str(value)

    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = str(value)

    @property
    def _id(self) -> str:
        """"""
        return self.___id

    @_id.setter
    def _id(self, value: str):
        """Set _id"""
        self.___id = str(value)

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def dfric(self) -> float:
        """Penetration relative to ZCONT (positive upwards)"""
        return self.__dfric

    @dfric.setter
    def dfric(self, value: float):
        """Set dfric"""
        self.__dfric = float(value)

    @property
    def ftipdo(self) -> float:
        """Depth dependent friction force for DOWNward motion"""
        return self.__ftipdo

    @ftipdo.setter
    def ftipdo(self, value: float):
        """Set ftipdo"""
        self.__ftipdo = float(value)

    @property
    def ftipup(self) -> float:
        """Depth dependent friction force for UPward motion"""
        return self.__ftipup

    @ftipup.setter
    def ftipup(self, value: float):
        """Set ftipup"""
        self.__ftipup = float(value)

    @property
    def fwall(self) -> float:
        """Depth dependent friction force for both upwards and
downwards motion"""
        return self.__fwall

    @fwall.setter
    def fwall(self, value: float):
        """Set fwall"""
        self.__fwall = float(value)

    @property
    def frich(self) -> float:
        """Depth dependent friction force in horizontal direction (>=0)"""
        return self.__frich

    @frich.setter
    def frich(self, value: float):
        """Set frich"""
        self.__frich = float(value)
