# This an autogenerated file
# 
# Generated with SIMOHeaveCompensator
from typing import Dict,Sequence,List
from dmt.entity import Entity
from dmt.blueprint import Blueprint
from .blueprints.simoheavecompensator import SIMOHeaveCompensatorBlueprint
from sima.sima.namedobject import NamedObject
from sima.sima.scriptablevalue import ScriptableValue
from sima.simo.compensatorlimitation import CompensatorLimitation
from sima.simo.compensatortype import CompensatorType

class SIMOHeaveCompensator(NamedObject):
    """
    Keyword arguments
    -----------------
    name : str
         (default "")
    description : str
         (default "")
    _id : str
         (default "")
    scriptableValues : List[ScriptableValue]
    _type : CompensatorType
    limitationMode : CompensatorLimitation
         Limitation handling mode for the compensator
    factor : float
         Reduction factor for compensator action at high sea states(default 0.0)
    clippingLevel : float
         Clipping level for crane motion measurement(default 0.0)
    numWiresCylinder : int
         Number of wire parts around compensator cylinder(default 2)
    strokeLength : float
         Maximum range of elongation (stroke length)(default 0.0)
    cylinderArea : float
         Cylinder cross section area(default 0.0)
    feedbackGainFactor : float
         Gain factor in feedback(default 0.0)
    feedbackTimeDerivative : float
         Time derivative in feedback(default 0.0)
    feedforwardGainFactor : float
         Gain factor in feedforward(default 0.0)
    feedforwardTimeDerivative : float
         Time derivative in feedforward(default 0.0)
    valveCharacteristics : float
         Characteristics of valve(default 0.0)
    valveTimeConstant : float
         Valve time constant(default 0.0)
    lowPassTimeConstant : float
         Time constant in low-pass filter(default 0.0)
    numWiresTopHook : int
         Number of wire parts from crane top to hook(default 1)
    """

    def __init__(self , name:str="", description:str="", _id:str="", _type:CompensatorType=CompensatorType.GENERIC, limitationMode:CompensatorLimitation=CompensatorLimitation.FACTOR, factor:float=0.0, clippingLevel:float=0.0, numWiresCylinder:int=2, strokeLength:float=0.0, cylinderArea:float=0.0, feedbackGainFactor:float=0.0, feedbackTimeDerivative:float=0.0, feedforwardGainFactor:float=0.0, feedforwardTimeDerivative:float=0.0, valveCharacteristics:float=0.0, valveTimeConstant:float=0.0, lowPassTimeConstant:float=0.0, numWiresTopHook:int=1, **kwargs):
        super().__init__(**kwargs)
        self.__name = name
        self.__description = description
        self.___id = _id
        self.__scriptableValues = list()
        self.___type = _type
        self.__limitationMode = limitationMode
        self.__factor = factor
        self.__clippingLevel = clippingLevel
        self.__numWiresCylinder = numWiresCylinder
        self.__strokeLength = strokeLength
        self.__cylinderArea = cylinderArea
        self.__feedbackGainFactor = feedbackGainFactor
        self.__feedbackTimeDerivative = feedbackTimeDerivative
        self.__feedforwardGainFactor = feedforwardGainFactor
        self.__feedforwardTimeDerivative = feedforwardTimeDerivative
        self.__valveCharacteristics = valveCharacteristics
        self.__valveTimeConstant = valveTimeConstant
        self.__lowPassTimeConstant = lowPassTimeConstant
        self.__numWiresTopHook = numWiresTopHook
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return SIMOHeaveCompensatorBlueprint()


    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = str(value)

    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = str(value)

    @property
    def _id(self) -> str:
        """"""
        return self.___id

    @_id.setter
    def _id(self, value: str):
        """Set _id"""
        self.___id = str(value)

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def _type(self) -> CompensatorType:
        """"""
        return self.___type

    @_type.setter
    def _type(self, value: CompensatorType):
        """Set _type"""
        self.___type = value

    @property
    def limitationMode(self) -> CompensatorLimitation:
        """Limitation handling mode for the compensator"""
        return self.__limitationMode

    @limitationMode.setter
    def limitationMode(self, value: CompensatorLimitation):
        """Set limitationMode"""
        self.__limitationMode = value

    @property
    def factor(self) -> float:
        """Reduction factor for compensator action at high sea states"""
        return self.__factor

    @factor.setter
    def factor(self, value: float):
        """Set factor"""
        self.__factor = float(value)

    @property
    def clippingLevel(self) -> float:
        """Clipping level for crane motion measurement"""
        return self.__clippingLevel

    @clippingLevel.setter
    def clippingLevel(self, value: float):
        """Set clippingLevel"""
        self.__clippingLevel = float(value)

    @property
    def numWiresCylinder(self) -> int:
        """Number of wire parts around compensator cylinder"""
        return self.__numWiresCylinder

    @numWiresCylinder.setter
    def numWiresCylinder(self, value: int):
        """Set numWiresCylinder"""
        self.__numWiresCylinder = int(value)

    @property
    def strokeLength(self) -> float:
        """Maximum range of elongation (stroke length)"""
        return self.__strokeLength

    @strokeLength.setter
    def strokeLength(self, value: float):
        """Set strokeLength"""
        self.__strokeLength = float(value)

    @property
    def cylinderArea(self) -> float:
        """Cylinder cross section area"""
        return self.__cylinderArea

    @cylinderArea.setter
    def cylinderArea(self, value: float):
        """Set cylinderArea"""
        self.__cylinderArea = float(value)

    @property
    def feedbackGainFactor(self) -> float:
        """Gain factor in feedback"""
        return self.__feedbackGainFactor

    @feedbackGainFactor.setter
    def feedbackGainFactor(self, value: float):
        """Set feedbackGainFactor"""
        self.__feedbackGainFactor = float(value)

    @property
    def feedbackTimeDerivative(self) -> float:
        """Time derivative in feedback"""
        return self.__feedbackTimeDerivative

    @feedbackTimeDerivative.setter
    def feedbackTimeDerivative(self, value: float):
        """Set feedbackTimeDerivative"""
        self.__feedbackTimeDerivative = float(value)

    @property
    def feedforwardGainFactor(self) -> float:
        """Gain factor in feedforward"""
        return self.__feedforwardGainFactor

    @feedforwardGainFactor.setter
    def feedforwardGainFactor(self, value: float):
        """Set feedforwardGainFactor"""
        self.__feedforwardGainFactor = float(value)

    @property
    def feedforwardTimeDerivative(self) -> float:
        """Time derivative in feedforward"""
        return self.__feedforwardTimeDerivative

    @feedforwardTimeDerivative.setter
    def feedforwardTimeDerivative(self, value: float):
        """Set feedforwardTimeDerivative"""
        self.__feedforwardTimeDerivative = float(value)

    @property
    def valveCharacteristics(self) -> float:
        """Characteristics of valve"""
        return self.__valveCharacteristics

    @valveCharacteristics.setter
    def valveCharacteristics(self, value: float):
        """Set valveCharacteristics"""
        self.__valveCharacteristics = float(value)

    @property
    def valveTimeConstant(self) -> float:
        """Valve time constant"""
        return self.__valveTimeConstant

    @valveTimeConstant.setter
    def valveTimeConstant(self, value: float):
        """Set valveTimeConstant"""
        self.__valveTimeConstant = float(value)

    @property
    def lowPassTimeConstant(self) -> float:
        """Time constant in low-pass filter"""
        return self.__lowPassTimeConstant

    @lowPassTimeConstant.setter
    def lowPassTimeConstant(self, value: float):
        """Set lowPassTimeConstant"""
        self.__lowPassTimeConstant = float(value)

    @property
    def numWiresTopHook(self) -> int:
        """Number of wire parts from crane top to hook"""
        return self.__numWiresTopHook

    @numWiresTopHook.setter
    def numWiresTopHook(self, value: int):
        """Set numWiresTopHook"""
        self.__numWiresTopHook = int(value)
