# This an autogenerated file
# 
# Generated with PhysicalConstants
from typing import Dict,Sequence,List
from dmt.entity import Entity
from dmt.blueprint import Blueprint
from .blueprints.physicalconstants import PhysicalConstantsBlueprint
from sima.sima.moao import MOAO
from sima.sima.scriptablevalue import ScriptableValue

class PhysicalConstants(MOAO):
    """
    Keyword arguments
    -----------------
    name : str
         (default "")
    description : str
         (default "")
    _id : str
         (default "")
    scriptableValues : List[ScriptableValue]
    airDensity : float
         Air density - rho air(default 1.25)
    waterDensity : float
         Water density - rho water(default 1025.0)
    kinematicViscosityWater : float
         Kinematic viscosity of water(default 1.188e-06)
    kinematicViscosityAir : float
         Kinematic viscosity of air(default 1.516e-05)
    accOfGravity : float
         Acceleration of gravity - g(default 9.81)
    """

    def __init__(self , name:str="", description:str="", _id:str="", airDensity:float=1.25, waterDensity:float=1025.0, kinematicViscosityWater:float=1.188e-06, kinematicViscosityAir:float=1.516e-05, accOfGravity:float=9.81, **kwargs):
        super().__init__(**kwargs)
        self.__name = name
        self.__description = description
        self.___id = _id
        self.__scriptableValues = list()
        self.__airDensity = airDensity
        self.__waterDensity = waterDensity
        self.__kinematicViscosityWater = kinematicViscosityWater
        self.__kinematicViscosityAir = kinematicViscosityAir
        self.__accOfGravity = accOfGravity
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return PhysicalConstantsBlueprint()


    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = str(value)

    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = str(value)

    @property
    def _id(self) -> str:
        """"""
        return self.___id

    @_id.setter
    def _id(self, value: str):
        """Set _id"""
        self.___id = str(value)

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def airDensity(self) -> float:
        """Air density - rho air"""
        return self.__airDensity

    @airDensity.setter
    def airDensity(self, value: float):
        """Set airDensity"""
        self.__airDensity = float(value)

    @property
    def waterDensity(self) -> float:
        """Water density - rho water"""
        return self.__waterDensity

    @waterDensity.setter
    def waterDensity(self, value: float):
        """Set waterDensity"""
        self.__waterDensity = float(value)

    @property
    def kinematicViscosityWater(self) -> float:
        """Kinematic viscosity of water"""
        return self.__kinematicViscosityWater

    @kinematicViscosityWater.setter
    def kinematicViscosityWater(self, value: float):
        """Set kinematicViscosityWater"""
        self.__kinematicViscosityWater = float(value)

    @property
    def kinematicViscosityAir(self) -> float:
        """Kinematic viscosity of air"""
        return self.__kinematicViscosityAir

    @kinematicViscosityAir.setter
    def kinematicViscosityAir(self, value: float):
        """Set kinematicViscosityAir"""
        self.__kinematicViscosityAir = float(value)

    @property
    def accOfGravity(self) -> float:
        """Acceleration of gravity - g"""
        return self.__accOfGravity

    @accOfGravity.setter
    def accOfGravity(self, value: float):
        """Set accOfGravity"""
        self.__accOfGravity = float(value)
