# This an autogenerated file
# 
# Generated with FixedForceElongation
from typing import Dict,Sequence,List
from dmt.entity import Entity
from dmt.blueprint import Blueprint
from .blueprints.fixedforceelongation import FixedForceElongationBlueprint
from sima.sima.point3 import Point3
from sima.sima.scriptablevalue import ScriptableValue
from sima.simo.activationfailuremode import ActivationFailureMode
from sima.simo.fixedforceelongationmethod import FixedForceElongationMethod
from sima.simo.forcedampingcharacteristic import ForceDampingCharacteristic
from sima.simo.positioningelement import PositioningElement

class FixedForceElongation(PositioningElement):
    """
    Keyword arguments
    -----------------
    name : str
         (default "")
    description : str
         (default "")
    _id : str
         (default "")
    scriptableValues : List[ScriptableValue]
    localPoint : Point3
    globalPoint : Point3
    failureMode : ActivationFailureMode
         Failure mode:\n - No failure\n - Failure by exceeding the breaking strength after specified time\n - Activation of element after specified time if absolute value of force is below breaking strength
    failureTime : float
         Earliest possible time of failure(default 0.0)
    breakingStrength : float
         Breaking strength(default 0.0)
    method : FixedForceElongationMethod
         Method for initialisation of the fixed force elongation
    pretension : float
         Pretension(default 0.0)
    direction : float
         Direction of line in horizontal plane(default 0.0)
    angle : float
         Angle of line from horizontal plane (positive downwards)(default 0.0)
    velocityLimit : float
         Velocity limit for friction force (Damping Exponent = 0)(default 0.0)
    characteristic : ForceDampingCharacteristic
    """

    def __init__(self , name:str="", description:str="", _id:str="", failureMode:ActivationFailureMode=ActivationFailureMode.NONE, failureTime:float=0.0, breakingStrength:float=0.0, method:FixedForceElongationMethod=FixedForceElongationMethod.PRETENSION_LOCAL, pretension:float=0.0, direction:float=0.0, angle:float=0.0, velocityLimit:float=0.0, **kwargs):
        super().__init__(**kwargs)
        self.__name = name
        self.__description = description
        self.___id = _id
        self.__scriptableValues = list()
        self.__localPoint = Point3()
        self.__globalPoint = Point3()
        self.__failureMode = failureMode
        self.__failureTime = failureTime
        self.__breakingStrength = breakingStrength
        self.__method = method
        self.__pretension = pretension
        self.__direction = direction
        self.__angle = angle
        self.__velocityLimit = velocityLimit
        self.__characteristic = ForceDampingCharacteristic()
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return FixedForceElongationBlueprint()


    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = str(value)

    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = str(value)

    @property
    def _id(self) -> str:
        """"""
        return self.___id

    @_id.setter
    def _id(self, value: str):
        """Set _id"""
        self.___id = str(value)

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def localPoint(self) -> Point3:
        """"""
        return self.__localPoint

    @localPoint.setter
    def localPoint(self, value: Point3):
        """Set localPoint"""
        self.__localPoint = value

    @property
    def globalPoint(self) -> Point3:
        """"""
        return self.__globalPoint

    @globalPoint.setter
    def globalPoint(self, value: Point3):
        """Set globalPoint"""
        self.__globalPoint = value

    @property
    def failureMode(self) -> ActivationFailureMode:
        """Failure mode:
 - No failure
 - Failure by exceeding the breaking strength after specified time
 - Activation of element after specified time if absolute value of force is below breaking strength"""
        return self.__failureMode

    @failureMode.setter
    def failureMode(self, value: ActivationFailureMode):
        """Set failureMode"""
        self.__failureMode = value

    @property
    def failureTime(self) -> float:
        """Earliest possible time of failure"""
        return self.__failureTime

    @failureTime.setter
    def failureTime(self, value: float):
        """Set failureTime"""
        self.__failureTime = float(value)

    @property
    def breakingStrength(self) -> float:
        """Breaking strength"""
        return self.__breakingStrength

    @breakingStrength.setter
    def breakingStrength(self, value: float):
        """Set breakingStrength"""
        self.__breakingStrength = float(value)

    @property
    def method(self) -> FixedForceElongationMethod:
        """Method for initialisation of the fixed force elongation"""
        return self.__method

    @method.setter
    def method(self, value: FixedForceElongationMethod):
        """Set method"""
        self.__method = value

    @property
    def pretension(self) -> float:
        """Pretension"""
        return self.__pretension

    @pretension.setter
    def pretension(self, value: float):
        """Set pretension"""
        self.__pretension = float(value)

    @property
    def direction(self) -> float:
        """Direction of line in horizontal plane"""
        return self.__direction

    @direction.setter
    def direction(self, value: float):
        """Set direction"""
        self.__direction = float(value)

    @property
    def angle(self) -> float:
        """Angle of line from horizontal plane (positive downwards)"""
        return self.__angle

    @angle.setter
    def angle(self, value: float):
        """Set angle"""
        self.__angle = float(value)

    @property
    def velocityLimit(self) -> float:
        """Velocity limit for friction force (Damping Exponent = 0)"""
        return self.__velocityLimit

    @velocityLimit.setter
    def velocityLimit(self, value: float):
        """Set velocityLimit"""
        self.__velocityLimit = float(value)

    @property
    def characteristic(self) -> ForceDampingCharacteristic:
        """"""
        return self.__characteristic

    @characteristic.setter
    def characteristic(self, value: ForceDampingCharacteristic):
        """Set characteristic"""
        self.__characteristic = value
