# This an autogenerated file
# 
# Generated with DockingCone
from __future__ import annotations
from typing import Dict,Sequence,List
from dmt.entity import Entity
from dmt.blueprint import Blueprint
from .blueprints.dockingcone import DockingConeBlueprint
from sima.sima.namedobject import NamedObject
from sima.sima.point3 import Point3
from sima.sima.scriptablevalue import ScriptableValue
from sima.sima.vector3 import Vector3
from sima.simo.activationfailuremode import ActivationFailureMode
from sima.simo.dockingconecrosssection import DockingConeCrossSection
from sima.simo.interpolation import Interpolation
from typing import TYPE_CHECKING
if TYPE_CHECKING:
    from sima.simo.simobody import SIMOBody

class DockingCone(NamedObject):
    """
    Keyword arguments
    -----------------
    name : str
         (default "")
    description : str
         (default "")
    _id : str
         (default "")
    scriptableValues : List[ScriptableValue]
    dampingExponent : float
         Exponent of velocity in damping term(default 1.0)
    dampingInterpolation : Interpolation
         Interpolation method for damping
    forceInterpolation : Interpolation
         Interpolation method for force
    velocityLimit : float
         Velocity limit for friction force (Damping Exponent = 0)(default 0.0)
    maxRadialDistance : float
         Maximum radial distance at entry(default 0.0)
    friction : float
         Friction coefficient for sliding along the cone or cylinder surface(default 0.0)
    failureMode : ActivationFailureMode
         Failure mode of coupling element
    failureTime : float
         Earliest possible time of failure(default 0.0)
    breakingStrength : float
         Breaking strength(default 0.0)
    dockingPinBody : SIMOBody
    dockingPinPoint : Point3
    dockingConePoint : Point3
    dockingConeDirectionVector : Vector3
    dockingConeBody : SIMOBody
    crossSections : List[DockingConeCrossSection]
    """

    def __init__(self , name:str="", description:str="", _id:str="", dampingExponent:float=1.0, dampingInterpolation:Interpolation=Interpolation.LINEAR, forceInterpolation:Interpolation=Interpolation.LINEAR, velocityLimit:float=0.0, maxRadialDistance:float=0.0, friction:float=0.0, failureMode:ActivationFailureMode=ActivationFailureMode.NONE, failureTime:float=0.0, breakingStrength:float=0.0, **kwargs):
        super().__init__(**kwargs)
        self.__name = name
        self.__description = description
        self.___id = _id
        self.__scriptableValues = list()
        self.__dampingExponent = dampingExponent
        self.__dampingInterpolation = dampingInterpolation
        self.__forceInterpolation = forceInterpolation
        self.__velocityLimit = velocityLimit
        self.__maxRadialDistance = maxRadialDistance
        self.__friction = friction
        self.__failureMode = failureMode
        self.__failureTime = failureTime
        self.__breakingStrength = breakingStrength
        self.__dockingPinBody = None
        self.__dockingPinPoint = Point3()
        self.__dockingConePoint = Point3()
        self.__dockingConeDirectionVector = Vector3()
        self.__dockingConeBody = None
        self.__crossSections = list()
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return DockingConeBlueprint()


    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = str(value)

    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = str(value)

    @property
    def _id(self) -> str:
        """"""
        return self.___id

    @_id.setter
    def _id(self, value: str):
        """Set _id"""
        self.___id = str(value)

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def dampingExponent(self) -> float:
        """Exponent of velocity in damping term"""
        return self.__dampingExponent

    @dampingExponent.setter
    def dampingExponent(self, value: float):
        """Set dampingExponent"""
        self.__dampingExponent = float(value)

    @property
    def dampingInterpolation(self) -> Interpolation:
        """Interpolation method for damping"""
        return self.__dampingInterpolation

    @dampingInterpolation.setter
    def dampingInterpolation(self, value: Interpolation):
        """Set dampingInterpolation"""
        self.__dampingInterpolation = value

    @property
    def forceInterpolation(self) -> Interpolation:
        """Interpolation method for force"""
        return self.__forceInterpolation

    @forceInterpolation.setter
    def forceInterpolation(self, value: Interpolation):
        """Set forceInterpolation"""
        self.__forceInterpolation = value

    @property
    def velocityLimit(self) -> float:
        """Velocity limit for friction force (Damping Exponent = 0)"""
        return self.__velocityLimit

    @velocityLimit.setter
    def velocityLimit(self, value: float):
        """Set velocityLimit"""
        self.__velocityLimit = float(value)

    @property
    def maxRadialDistance(self) -> float:
        """Maximum radial distance at entry"""
        return self.__maxRadialDistance

    @maxRadialDistance.setter
    def maxRadialDistance(self, value: float):
        """Set maxRadialDistance"""
        self.__maxRadialDistance = float(value)

    @property
    def friction(self) -> float:
        """Friction coefficient for sliding along the cone or cylinder surface"""
        return self.__friction

    @friction.setter
    def friction(self, value: float):
        """Set friction"""
        self.__friction = float(value)

    @property
    def failureMode(self) -> ActivationFailureMode:
        """Failure mode of coupling element"""
        return self.__failureMode

    @failureMode.setter
    def failureMode(self, value: ActivationFailureMode):
        """Set failureMode"""
        self.__failureMode = value

    @property
    def failureTime(self) -> float:
        """Earliest possible time of failure"""
        return self.__failureTime

    @failureTime.setter
    def failureTime(self, value: float):
        """Set failureTime"""
        self.__failureTime = float(value)

    @property
    def breakingStrength(self) -> float:
        """Breaking strength"""
        return self.__breakingStrength

    @breakingStrength.setter
    def breakingStrength(self, value: float):
        """Set breakingStrength"""
        self.__breakingStrength = float(value)

    @property
    def dockingPinBody(self) -> SIMOBody:
        """"""
        return self.__dockingPinBody

    @dockingPinBody.setter
    def dockingPinBody(self, value: SIMOBody):
        """Set dockingPinBody"""
        self.__dockingPinBody = value

    @property
    def dockingPinPoint(self) -> Point3:
        """"""
        return self.__dockingPinPoint

    @dockingPinPoint.setter
    def dockingPinPoint(self, value: Point3):
        """Set dockingPinPoint"""
        self.__dockingPinPoint = value

    @property
    def dockingConePoint(self) -> Point3:
        """"""
        return self.__dockingConePoint

    @dockingConePoint.setter
    def dockingConePoint(self, value: Point3):
        """Set dockingConePoint"""
        self.__dockingConePoint = value

    @property
    def dockingConeDirectionVector(self) -> Vector3:
        """"""
        return self.__dockingConeDirectionVector

    @dockingConeDirectionVector.setter
    def dockingConeDirectionVector(self, value: Vector3):
        """Set dockingConeDirectionVector"""
        self.__dockingConeDirectionVector = value

    @property
    def dockingConeBody(self) -> SIMOBody:
        """"""
        return self.__dockingConeBody

    @dockingConeBody.setter
    def dockingConeBody(self, value: SIMOBody):
        """Set dockingConeBody"""
        self.__dockingConeBody = value

    @property
    def crossSections(self) -> List[DockingConeCrossSection]:
        """"""
        return self.__crossSections

    @crossSections.setter
    def crossSections(self, value: List[DockingConeCrossSection]):
        """Set crossSections"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__crossSections = value
