# This an autogenerated file
# 
# Generated with BodyShapeData
from typing import Dict,Sequence,List
from dmt.entity import Entity
from dmt.blueprint import Blueprint
from .blueprints.bodyshapedata import BodyShapeDataBlueprint
from sima.sima.moao import MOAO
from sima.sima.scriptablevalue import ScriptableValue
from sima.simo.point2 import Point2

class BodyShapeData(MOAO):
    """
    Keyword arguments
    -----------------
    name : str
         (default "")
    description : str
         (default "")
    _id : str
         (default "")
    scriptableValues : List[ScriptableValue]
    lengthBetweenPerpendiculars : float
         Length between perpendiculars(default 0.0)
    maximumBeamAtWaterline : float
         Maximum beam at the waterline(default 0.0)
    draftAtAftPerpendicular : float
         Draft at aft perpendicular(default 0.0)
    draftAtForePerpendicular : float
         Draft at fore perpendicular(default 0.0)
    blockCoefficient : float
         Block coefficient, Cb = displacement / (LWL * BWL * T)(default 0.0)
    distanceAftPerpendicular : float
         Distance from aft perpendicular to the body fixed origin(default 0.0)
    distanceBaseline : float
         Distance from baseline to the body fixed origin(default 0.0)
    specifyWaterline : bool
         Should a waterline file be specified?(default True)
    waterlinePoints : List[Point2]
    """

    def __init__(self , name:str="", description:str="", _id:str="", lengthBetweenPerpendiculars:float=0.0, maximumBeamAtWaterline:float=0.0, draftAtAftPerpendicular:float=0.0, draftAtForePerpendicular:float=0.0, blockCoefficient:float=0.0, distanceAftPerpendicular:float=0.0, distanceBaseline:float=0.0, specifyWaterline:bool=True, **kwargs):
        super().__init__(**kwargs)
        self.__name = name
        self.__description = description
        self.___id = _id
        self.__scriptableValues = list()
        self.__lengthBetweenPerpendiculars = lengthBetweenPerpendiculars
        self.__maximumBeamAtWaterline = maximumBeamAtWaterline
        self.__draftAtAftPerpendicular = draftAtAftPerpendicular
        self.__draftAtForePerpendicular = draftAtForePerpendicular
        self.__blockCoefficient = blockCoefficient
        self.__distanceAftPerpendicular = distanceAftPerpendicular
        self.__distanceBaseline = distanceBaseline
        self.__specifyWaterline = specifyWaterline
        self.__waterlinePoints = list()
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return BodyShapeDataBlueprint()


    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = str(value)

    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = str(value)

    @property
    def _id(self) -> str:
        """"""
        return self.___id

    @_id.setter
    def _id(self, value: str):
        """Set _id"""
        self.___id = str(value)

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def lengthBetweenPerpendiculars(self) -> float:
        """Length between perpendiculars"""
        return self.__lengthBetweenPerpendiculars

    @lengthBetweenPerpendiculars.setter
    def lengthBetweenPerpendiculars(self, value: float):
        """Set lengthBetweenPerpendiculars"""
        self.__lengthBetweenPerpendiculars = float(value)

    @property
    def maximumBeamAtWaterline(self) -> float:
        """Maximum beam at the waterline"""
        return self.__maximumBeamAtWaterline

    @maximumBeamAtWaterline.setter
    def maximumBeamAtWaterline(self, value: float):
        """Set maximumBeamAtWaterline"""
        self.__maximumBeamAtWaterline = float(value)

    @property
    def draftAtAftPerpendicular(self) -> float:
        """Draft at aft perpendicular"""
        return self.__draftAtAftPerpendicular

    @draftAtAftPerpendicular.setter
    def draftAtAftPerpendicular(self, value: float):
        """Set draftAtAftPerpendicular"""
        self.__draftAtAftPerpendicular = float(value)

    @property
    def draftAtForePerpendicular(self) -> float:
        """Draft at fore perpendicular"""
        return self.__draftAtForePerpendicular

    @draftAtForePerpendicular.setter
    def draftAtForePerpendicular(self, value: float):
        """Set draftAtForePerpendicular"""
        self.__draftAtForePerpendicular = float(value)

    @property
    def blockCoefficient(self) -> float:
        """Block coefficient, Cb = displacement / (LWL * BWL * T)"""
        return self.__blockCoefficient

    @blockCoefficient.setter
    def blockCoefficient(self, value: float):
        """Set blockCoefficient"""
        self.__blockCoefficient = float(value)

    @property
    def distanceAftPerpendicular(self) -> float:
        """Distance from aft perpendicular to the body fixed origin"""
        return self.__distanceAftPerpendicular

    @distanceAftPerpendicular.setter
    def distanceAftPerpendicular(self, value: float):
        """Set distanceAftPerpendicular"""
        self.__distanceAftPerpendicular = float(value)

    @property
    def distanceBaseline(self) -> float:
        """Distance from baseline to the body fixed origin"""
        return self.__distanceBaseline

    @distanceBaseline.setter
    def distanceBaseline(self, value: float):
        """Set distanceBaseline"""
        self.__distanceBaseline = float(value)

    @property
    def specifyWaterline(self) -> bool:
        """Should a waterline file be specified?"""
        return self.__specifyWaterline

    @specifyWaterline.setter
    def specifyWaterline(self, value: bool):
        """Set specifyWaterline"""
        self.__specifyWaterline = bool(value)

    @property
    def waterlinePoints(self) -> List[Point2]:
        """"""
        return self.__waterlinePoints

    @waterlinePoints.setter
    def waterlinePoints(self, value: List[Point2]):
        """Set waterlinePoints"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__waterlinePoints = value
