# 
# Generated with SIMODynamicCalculationParametersBlueprint
from dmt.blueprint import Blueprint
from dmt.dimension import Dimension
from dmt.attribute import Attribute
from dmt.enum_attribute import EnumAttribute
from dmt.blueprint_attribute import BlueprintAttribute
from sima.sima.blueprints.moao import MOAOBlueprint

class SIMODynamicCalculationParametersBlueprint(MOAOBlueprint):
    """"""

    def __init__(self, name="SIMODynamicCalculationParameters", package_path="sima/simo", description=""):
        super().__init__(name,package_path,description)
        self.attributes.append(Attribute("name","string","",default=""))
        self.attributes.append(Attribute("description","string","",default=""))
        self.attributes.append(Attribute("_id","string","",default=""))
        self.attributes.append(BlueprintAttribute("scriptableValues","sima/sima/ScriptableValue","",True,Dimension("size","")))
        self.attributes.append(BlueprintAttribute("externalControlSetup","sima/simo/ExternalControlSetup","",True))
        self.attributes.append(BlueprintAttribute("multiEnvironmentSetup","sima/simo/MultiEnvironmentSetup","",True))
        self.attributes.append(Attribute("timeIncrement","number","Time increment for time series generation and storage",default=0.5))
        self.attributes.append(EnumAttribute("waveMethod","sima/simo/WaveMethod","Selected wave method"))
        self.attributes.append(EnumAttribute("integrationMethod","sima/simo/IntegrationMethod","Selected integration method"))
        self.attributes.append(Attribute("randomSeedWaves","integer","Random seed waves",default=1))
        self.attributes.append(Attribute("randomSeedWind","integer","Random seed wind",default=1))
        self.attributes.append(EnumAttribute("randomGenerator","sima/simo/RandomGenerator",""))
        self.attributes.append(Attribute("headingCorrection","boolean","Use correction due to heading change",default=True))
        self.attributes.append(Attribute("maxHeadingChange","number","Max heading change",default=45.0))
        self.attributes.append(Attribute("largePatchLength","number","Large visualization wave patch length",default=2048.0))
        self.attributes.append(Attribute("smallPatchLength","number","Small visualization wave patch length",default=256.0))
        self.attributes.append(Attribute("cutFactorWaves","integer","Cut factor for wave components",default=100))
        self.attributes.append(Attribute("pointsLargePatch","integer","Number of points in large wave patch",default=256))
        self.attributes.append(Attribute("pointsSmallPatch","integer","Number of points in small wave patch",default=128))
        self.attributes.append(Attribute("writeVisFile","boolean","write visualization file?",default=True))
        self.attributes.append(BlueprintAttribute("waveTimeSeries","sima/simo/WaveTimeSeries","",True))
        self.attributes.append(Attribute("waveTimeSeriesFile","boolean","Wave time series from file",default=True))
        self.attributes.append(BlueprintAttribute("bodyWaveMethodOptions","sima/simo/BodyWaveMethodOption","",True,Dimension("size","")))
        self.attributes.append(Attribute("hydroSystemPeriod","number","Hydrosystem filter period",default=0.0))
        self.attributes.append(EnumAttribute("hydroFilterMethod","sima/simo/HydroSystemFilterMethod","Hydro Filter Method"))
        self.attributes.append(Attribute("nWindSeaComponents","integer","Number of wind-sea components",default=2000))
        self.attributes.append(Attribute("nSwellSeaComponents","integer","Number of wind-sea components",default=400))
        self.attributes.append(EnumAttribute("windTimeSeriesMethod","sima/simo/WindTimeSeriesMethod","Wind Time Series Method"))
        self.attributes.append(EnumAttribute("windVelocityDimension","sima/simo/WindVelocityDimension","Wind Velocity Dimension"))
        self.attributes.append(EnumAttribute("windForceMethod","sima/simo/WindForceMethod","Wind Force Method"))
        self.attributes.append(EnumAttribute("windMethod","sima/simo/WindMethod",""))
        self.attributes.append(BlueprintAttribute("windSpectrumVerticalDomain","sima/simo/WindSpectrumVerticalDomain","",True))
        self.attributes.append(EnumAttribute("quadraticCurrentForceMethod","sima/simo/CurrentForceMethod","Quadratic Current Force Method"))
        self.attributes.append(EnumAttribute("linearCurrentForceMethod","sima/simo/CurrentForceMethod","Linear Current Force Method"))
        self.attributes.append(Attribute("exportResultsToWasim","boolean","",default=True))
        self.attributes.append(BlueprintAttribute("wasimResultExport","sima/simo/WasimResultExport","",True))
        self.attributes.append(Attribute("storeWindForces","boolean","Store wind forces?",default=True))
        self.attributes.append(Attribute("storeSumGeneralLineForces","boolean","Store sum general line forces?",default=True))
        self.attributes.append(Attribute("storeTotalForces","boolean","Store total forces?",default=True))
        self.attributes.append(Attribute("storeRetardationForces","boolean","Store retardation forces?",default=True))
        self.attributes.append(Attribute("storeHydrostaticStiffnessForces","boolean","Store hydrostatic stiffness forces?",default=True))
        self.attributes.append(Attribute("storeLinearDamping","boolean","Store linear damping?",default=True))
        self.attributes.append(Attribute("storeQuadraticDamping","boolean","Store quadratic damping?",default=True))
        self.attributes.append(Attribute("storeDistributedHydrodynamicForces","boolean","Store distributed hydrodynamic forces?",default=True))
        self.attributes.append(Attribute("storeFixedBodyAndSlenderElementStripResults","boolean","Store results for slender element strips and fixed body elements?",default=True))
        self.attributes.append(Attribute("storeWaveDriftDamping","boolean","Store wave-drift damping?",default=True))
        self.attributes.append(Attribute("storeLinearCurrentDrag","boolean","Store linear current drag?",default=True))
        self.attributes.append(Attribute("storeQuadraticCurrentDrag","boolean","Store quadratic current drag?",default=True))
        self.attributes.append(Attribute("storeSmallBodyHydrodynamicForces","boolean","Store small body hydrodynamic forces?",default=True))
        self.attributes.append(Attribute("storeResultantPositioningElementForces","boolean","Store resultant positioning element forces?",default=True))
        self.attributes.append(Attribute("storePositioningElementForceComponents","boolean","Store positioning element force components?",default=True))
        self.attributes.append(Attribute("storeTotalPositioningForces","boolean","Store total positioning element forces?",default=True))
        self.attributes.append(Attribute("storeThrusterForces","boolean","Store thruster forces?",default=True))
        self.attributes.append(Attribute("storeSumThrusterForces","boolean","Store sum thruster forces?",default=True))
        self.attributes.append(Attribute("storeDynamicPositioningEstimators","boolean","Store dynamic positioning estimators?",default=True))
        self.attributes.append(Attribute("storeSumSpecifiedForces","boolean","Store sum specified forces?",default=True))
        self.attributes.append(Attribute("storeSumExternalForces","boolean","Store sum external forces?",default=True))
        self.attributes.append(Attribute("storeSumCouplingForces","boolean","Store sum coupling forces?",default=True))
        self.attributes.append(Attribute("storeResultantCouplingElementForces","boolean","Store resultant coupling element forces?",default=True))
        self.attributes.append(Attribute("storeGlobalCouplingForceComponents","boolean","Store global coupling force components?",default=True))
        self.attributes.append(Attribute("storeLocalCouplingForceComponents","boolean","Store local coupling force components?",default=True))
        self.attributes.append(Attribute("storeGlobalLowFrequencyPosition","boolean","Store global low-frequency position?",default=True))
        self.attributes.append(Attribute("storeGlobalTotalPosition","boolean","Store global total position?",default=True))
        self.attributes.append(Attribute("storeGlobalAcceleration","boolean","Store global acceleration?",default=True))
        self.attributes.append(Attribute("storeLocalAccelerations","boolean","Store local acceleration?",default=True))
        self.attributes.append(Attribute("storeLocalVelocity","boolean","Store local velocity",default=True))
        self.attributes.append(Attribute("storeCatenarySystemForces","boolean","Store catenery system forces. Requires visualization storage",default=True))
        self.attributes.append(Attribute("storeCatenarySystemNodes","boolean","Store displacement of catenary system nodes. Requires visualization storage",default=True))
        self.attributes.append(Attribute("timeStep","number","Time integration step",default=0.5))
        self.attributes.append(Attribute("simulationLength","number","Simulation length",default=11000.0))
        self.attributes.append(Attribute("simulationStartTime","number","Time (in generated time series) that dynamic simulation will start from",default=0.0))
        self.attributes.append(Attribute("rampDuration","number","Determines the ramp duration in seconds",default=2.5))
        self.attributes.append(Attribute("requestedTimeSeriesLength","number","Length of generated time series",default=16384.0))