# This an autogenerated file
# 
# Generated with Appearance
from typing import Dict,Sequence,List
from dmt.entity import Entity
from dmt.blueprint import Blueprint
from .blueprints.appearance import AppearanceBlueprint
from sima.sima.geomrepresentationtype import GeomRepresentationType
from sima.sima.moao import MOAO
from sima.sima.scriptablevalue import ScriptableValue
from sima.sima.simacolor import SIMAColor
from sima.sima.symmetry import Symmetry
from sima.sima.vector3 import Vector3

class Appearance(MOAO):
    """
    Keyword arguments
    -----------------
    name : str
         (default "")
    description : str
         (default "")
    _id : str
         (default "")
    scriptableValues : List[ScriptableValue]
    graphicsfile : str
         Graphics file(default "")
    translation : Vector3
    rotation : Vector3
    scaling : Vector3
    color : SIMAColor
    geomRepresentationType : GeomRepresentationType
         Geometry representation type
    radius : float
         (default 1.0)
    transparency : float
         Transparency of geometry. No transparancy=0, Full transparency=1(default 0.0)
    symmetry : Symmetry
         Symmetric properties of the geometry
    """

    def __init__(self , name:str="", description:str="", _id:str="", graphicsfile:str="", geomRepresentationType:GeomRepresentationType=GeomRepresentationType.DEFAULT_BOX, radius:float=1.0, transparency:float=0.0, symmetry:Symmetry=Symmetry.NONE, **kwargs):
        super().__init__(**kwargs)
        self.__name = name
        self.__description = description
        self.___id = _id
        self.__scriptableValues = list()
        self.__graphicsfile = graphicsfile
        self.__translation = Vector3()
        self.__rotation = Vector3()
        self.__scaling = Vector3(x=1.0,y=1.0,z=1.0)
        self.__color = SIMAColor()
        self.__geomRepresentationType = geomRepresentationType
        self.__radius = radius
        self.__transparency = transparency
        self.__symmetry = symmetry
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return AppearanceBlueprint()


    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = str(value)

    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = str(value)

    @property
    def _id(self) -> str:
        """"""
        return self.___id

    @_id.setter
    def _id(self, value: str):
        """Set _id"""
        self.___id = str(value)

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def graphicsfile(self) -> str:
        """Graphics file"""
        return self.__graphicsfile

    @graphicsfile.setter
    def graphicsfile(self, value: str):
        """Set graphicsfile"""
        self.__graphicsfile = str(value)

    @property
    def translation(self) -> Vector3:
        """"""
        return self.__translation

    @translation.setter
    def translation(self, value: Vector3):
        """Set translation"""
        self.__translation = value

    @property
    def rotation(self) -> Vector3:
        """"""
        return self.__rotation

    @rotation.setter
    def rotation(self, value: Vector3):
        """Set rotation"""
        self.__rotation = value

    @property
    def scaling(self) -> Vector3:
        """"""
        return self.__scaling

    @scaling.setter
    def scaling(self, value: Vector3):
        """Set scaling"""
        self.__scaling = value

    @property
    def color(self) -> SIMAColor:
        """"""
        return self.__color

    @color.setter
    def color(self, value: SIMAColor):
        """Set color"""
        self.__color = value

    @property
    def geomRepresentationType(self) -> GeomRepresentationType:
        """Geometry representation type"""
        return self.__geomRepresentationType

    @geomRepresentationType.setter
    def geomRepresentationType(self, value: GeomRepresentationType):
        """Set geomRepresentationType"""
        self.__geomRepresentationType = value

    @property
    def radius(self) -> float:
        """"""
        return self.__radius

    @radius.setter
    def radius(self, value: float):
        """Set radius"""
        self.__radius = float(value)

    @property
    def transparency(self) -> float:
        """Transparency of geometry. No transparancy=0, Full transparency=1"""
        return self.__transparency

    @transparency.setter
    def transparency(self, value: float):
        """Set transparency"""
        self.__transparency = float(value)

    @property
    def symmetry(self) -> Symmetry:
        """Symmetric properties of the geometry"""
        return self.__symmetry

    @symmetry.setter
    def symmetry(self, value: Symmetry):
        """Set symmetry"""
        self.__symmetry = value
