# This an autogenerated file
# 
# Generated with WaveTimeSeries
from typing import Dict,Sequence,List
from dmt.entity import Entity
from dmt.blueprint import Blueprint
from .blueprints.wavetimeseries import WaveTimeSeriesBlueprint
from sima.riflex.fileformatascistar import FileFormatAsciStar
from sima.sima.moao import MOAO
from sima.sima.scriptablevalue import ScriptableValue

class WaveTimeSeries(MOAO):
    """
    Keyword arguments
    -----------------
    name : str
         (default "")
    description : str
         (default "")
    _id : str
         (default "")
    scriptableValues : List[ScriptableValue]
    fileName : str
         Wave time series file(default "")
    fileFormat : FileFormatAsciStar
         Wave time series file format
    timeColumnNum : int
         Column number for time(default 1)
    waveColumnNum : int
         Column or time series number for wave elevation(default 2)
    starFileVersion : int
         Startimes file version(default 0)
    direction : float
         Wave direction(default 0.0)
    xgWav : float
         Global x-coordinate for position where time series is measured(default 0.0)
    ygWav : float
         Global y-coordinate for position where time series is measured(default 0.0)
    """

    def __init__(self , name:str="", description:str="", _id:str="", fileName:str="", fileFormat:FileFormatAsciStar=FileFormatAsciStar.ASCII, timeColumnNum:int=1, waveColumnNum:int=2, starFileVersion:int=0, direction:float=0.0, xgWav:float=0.0, ygWav:float=0.0, **kwargs):
        super().__init__(**kwargs)
        self.__name = name
        self.__description = description
        self.___id = _id
        self.__scriptableValues = list()
        self.__fileName = fileName
        self.__fileFormat = fileFormat
        self.__timeColumnNum = timeColumnNum
        self.__waveColumnNum = waveColumnNum
        self.__starFileVersion = starFileVersion
        self.__direction = direction
        self.__xgWav = xgWav
        self.__ygWav = ygWav
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return WaveTimeSeriesBlueprint()


    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = str(value)

    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = str(value)

    @property
    def _id(self) -> str:
        """"""
        return self.___id

    @_id.setter
    def _id(self, value: str):
        """Set _id"""
        self.___id = str(value)

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def fileName(self) -> str:
        """Wave time series file"""
        return self.__fileName

    @fileName.setter
    def fileName(self, value: str):
        """Set fileName"""
        self.__fileName = str(value)

    @property
    def fileFormat(self) -> FileFormatAsciStar:
        """Wave time series file format"""
        return self.__fileFormat

    @fileFormat.setter
    def fileFormat(self, value: FileFormatAsciStar):
        """Set fileFormat"""
        self.__fileFormat = value

    @property
    def timeColumnNum(self) -> int:
        """Column number for time"""
        return self.__timeColumnNum

    @timeColumnNum.setter
    def timeColumnNum(self, value: int):
        """Set timeColumnNum"""
        self.__timeColumnNum = int(value)

    @property
    def waveColumnNum(self) -> int:
        """Column or time series number for wave elevation"""
        return self.__waveColumnNum

    @waveColumnNum.setter
    def waveColumnNum(self, value: int):
        """Set waveColumnNum"""
        self.__waveColumnNum = int(value)

    @property
    def starFileVersion(self) -> int:
        """Startimes file version"""
        return self.__starFileVersion

    @starFileVersion.setter
    def starFileVersion(self, value: int):
        """Set starFileVersion"""
        self.__starFileVersion = int(value)

    @property
    def direction(self) -> float:
        """Wave direction"""
        return self.__direction

    @direction.setter
    def direction(self, value: float):
        """Set direction"""
        self.__direction = float(value)

    @property
    def xgWav(self) -> float:
        """Global x-coordinate for position where time series is measured"""
        return self.__xgWav

    @xgWav.setter
    def xgWav(self, value: float):
        """Set xgWav"""
        self.__xgWav = float(value)

    @property
    def ygWav(self) -> float:
        """Global y-coordinate for position where time series is measured"""
        return self.__ygWav

    @ygWav.setter
    def ygWav(self, value: float):
        """Set ygWav"""
        self.__ygWav = float(value)
