# This an autogenerated file
# 
# Generated with StressJointLineType
from __future__ import annotations
from typing import Dict,Sequence,List
from dmt.entity import Entity
from dmt.blueprint import Blueprint
from .blueprints.stressjointlinetype import StressJointLineTypeBlueprint
from sima.riflex.arlinetype import ARLineType
from sima.riflex.stressjointloadformulation import StressJointLoadFormulation
from sima.riflex.stressjointsegment import StressJointSegment
from sima.riflex.timedomainvivloadcoefficients import TimeDomainVIVLoadCoefficients
from sima.sima.scriptablevalue import ScriptableValue
from typing import TYPE_CHECKING
if TYPE_CHECKING:
    from sima.riflex.internalfluidtype import InternalFluidType

class StressJointLineType(ARLineType):
    """
    Keyword arguments
    -----------------
    name : str
         (default "")
    description : str
         (default "")
    _id : str
         (default "")
    scriptableValues : List[ScriptableValue]
    internalFluid : InternalFluidType
         Internal fluid component type.
    quadraticDrag : float
         Quadratic drag coefficient in normal direction, non-dimensional.(default 0.0)
    addedMass : float
         Added mass pr. unit length coefficient in normal direction, non-dimensional.(default 0.0)
    extDiameterEnd1 : float
         External diameter at 'first' end of first conical segment in stress joint.(default 0.0)
    wallThicknessEnd1 : float
         Wall thickness at 'first' end of first conical segment in stress joint.(default 0.0)
    segments : List[StressJointSegment]
    loadFormulation : StressJointLoadFormulation
    vivCoefficients : TimeDomainVIVLoadCoefficients
    """

    def __init__(self , name:str="", description:str="", _id:str="", quadraticDrag:float=0.0, addedMass:float=0.0, extDiameterEnd1:float=0.0, wallThicknessEnd1:float=0.0, loadFormulation:StressJointLoadFormulation=StressJointLoadFormulation.MORISON, **kwargs):
        super().__init__(**kwargs)
        self.__name = name
        self.__description = description
        self.___id = _id
        self.__scriptableValues = list()
        self.__internalFluid = None
        self.__quadraticDrag = quadraticDrag
        self.__addedMass = addedMass
        self.__extDiameterEnd1 = extDiameterEnd1
        self.__wallThicknessEnd1 = wallThicknessEnd1
        self.__segments = list()
        self.__loadFormulation = loadFormulation
        self.__vivCoefficients = TimeDomainVIVLoadCoefficients()
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return StressJointLineTypeBlueprint()


    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = str(value)

    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = str(value)

    @property
    def _id(self) -> str:
        """"""
        return self.___id

    @_id.setter
    def _id(self, value: str):
        """Set _id"""
        self.___id = str(value)

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def internalFluid(self) -> InternalFluidType:
        """Internal fluid component type."""
        return self.__internalFluid

    @internalFluid.setter
    def internalFluid(self, value: InternalFluidType):
        """Set internalFluid"""
        self.__internalFluid = value

    @property
    def quadraticDrag(self) -> float:
        """Quadratic drag coefficient in normal direction, non-dimensional."""
        return self.__quadraticDrag

    @quadraticDrag.setter
    def quadraticDrag(self, value: float):
        """Set quadraticDrag"""
        self.__quadraticDrag = float(value)

    @property
    def addedMass(self) -> float:
        """Added mass pr. unit length coefficient in normal direction, non-dimensional."""
        return self.__addedMass

    @addedMass.setter
    def addedMass(self, value: float):
        """Set addedMass"""
        self.__addedMass = float(value)

    @property
    def extDiameterEnd1(self) -> float:
        """External diameter at 'first' end of first conical segment in stress joint."""
        return self.__extDiameterEnd1

    @extDiameterEnd1.setter
    def extDiameterEnd1(self, value: float):
        """Set extDiameterEnd1"""
        self.__extDiameterEnd1 = float(value)

    @property
    def wallThicknessEnd1(self) -> float:
        """Wall thickness at 'first' end of first conical segment in stress joint."""
        return self.__wallThicknessEnd1

    @wallThicknessEnd1.setter
    def wallThicknessEnd1(self, value: float):
        """Set wallThicknessEnd1"""
        self.__wallThicknessEnd1 = float(value)

    @property
    def segments(self) -> List[StressJointSegment]:
        """"""
        return self.__segments

    @segments.setter
    def segments(self, value: List[StressJointSegment]):
        """Set segments"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__segments = value

    @property
    def loadFormulation(self) -> StressJointLoadFormulation:
        """"""
        return self.__loadFormulation

    @loadFormulation.setter
    def loadFormulation(self, value: StressJointLoadFormulation):
        """Set loadFormulation"""
        self.__loadFormulation = value

    @property
    def vivCoefficients(self) -> TimeDomainVIVLoadCoefficients:
        """"""
        return self.__vivCoefficients

    @vivCoefficients.setter
    def vivCoefficients(self, value: TimeDomainVIVLoadCoefficients):
        """Set vivCoefficients"""
        self.__vivCoefficients = value
