# This an autogenerated file
# 
# Generated with StrainStressItem
from typing import Dict,Sequence,List
from dmt.entity import Entity
from dmt.blueprint import Blueprint
from .blueprints.strainstressitem import StrainStressItemBlueprint
from sima.sima.moao import MOAO
from sima.sima.scriptablevalue import ScriptableValue

class StrainStressItem(MOAO):
    """
    Keyword arguments
    -----------------
    name : str
         (default "")
    description : str
         (default "")
    _id : str
         (default "")
    scriptableValues : List[ScriptableValue]
    strain : float
         Strain for a given point on strain-stress curve.(default 0.0)
    stress : float
         Stress for a given point on strain-stress curve.(default 0.0)
    """

    def __init__(self , name:str="", description:str="", _id:str="", strain:float=0.0, stress:float=0.0, **kwargs):
        super().__init__(**kwargs)
        self.__name = name
        self.__description = description
        self.___id = _id
        self.__scriptableValues = list()
        self.__strain = strain
        self.__stress = stress
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return StrainStressItemBlueprint()


    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = str(value)

    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = str(value)

    @property
    def _id(self) -> str:
        """"""
        return self.___id

    @_id.setter
    def _id(self, value: str):
        """Set _id"""
        self.___id = str(value)

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def strain(self) -> float:
        """Strain for a given point on strain-stress curve."""
        return self.__strain

    @strain.setter
    def strain(self, value: float):
        """Set strain"""
        self.__strain = float(value)

    @property
    def stress(self) -> float:
        """Stress for a given point on strain-stress curve."""
        return self.__stress

    @stress.setter
    def stress(self, value: float):
        """Set stress"""
        self.__stress = float(value)
