# This an autogenerated file
# 
# Generated with SlenderSystemConnection
from __future__ import annotations
from typing import Dict,Sequence,List
from dmt.entity import Entity
from dmt.blueprint import Blueprint
from .blueprints.slendersystemconnection import SlenderSystemConnectionBlueprint
from sima.riflex.bodylocation import BodyLocation
from sima.riflex.elementreference import ElementReference
from sima.riflex.end import End
from sima.riflex.nodeconstraint import NodeConstraint
from sima.riflex.nodereference import NodeReference
from sima.sima.position import Position
from sima.sima.scriptablevalue import ScriptableValue
from sima.simo.bodyslendersystemconnection import BodySlenderSystemConnection
from typing import TYPE_CHECKING
if TYPE_CHECKING:
    from sima.riflex.arline import ARLine
    from sima.riflex.supernode import SuperNode

class SlenderSystemConnection(ElementReference,NodeReference,BodySlenderSystemConnection):
    """
    Keyword arguments
    -----------------
    name : str
         (default "")
    description : str
         (default "")
    _id : str
         (default "")
    scriptableValues : List[ScriptableValue]
    line : ARLine
         Line
    segment : int
         Segment on given line(default 1)
    allSegments : bool
         All segments(default False)
    elementNumber : int
         Local element number on actual segment(default 1)
    allElements : bool
         All elements(default False)
    nodeNumber : int
         Local node number on actual segment(default 1)
    allNodes : bool
         All nodes(default False)
    allEnds : bool
         All ends(default False)
    elementEnd : End
         End number 1 or 2
    location : BodyLocation
         If a supernode is used as location option and it is not part of a line, a dummy line will be created automatically.
    superNode : SuperNode
         Line
    artificialStiffness : bool
         Artificial stiffness option(default False)
    stx : float
         Stiffness in global X-direction(default 0.0)
    sty : float
         Stiffness in global Y-direction(default 0.0)
    stz : float
         Stiffness in global Z-direction(default 0.0)
    srx : float
         Stiffness around global X-direction(default 0.0)
    sry : float
         Stiffness around global Y-direction(default 0.0)
    srz : float
         Stiffness around global Z-direction(default 0.0)
    constraint : NodeConstraint
         Supernode type.
    finalPosition : Position
    """

    def __init__(self , name:str="", description:str="", _id:str="", segment:int=1, allSegments:bool=False, elementNumber:int=1, allElements:bool=False, nodeNumber:int=1, allNodes:bool=False, allEnds:bool=False, elementEnd:End=End.ONE, location:BodyLocation=BodyLocation.ELEMENT, artificialStiffness:bool=False, stx:float=0.0, sty:float=0.0, stz:float=0.0, srx:float=0.0, sry:float=0.0, srz:float=0.0, constraint:NodeConstraint=NodeConstraint.FREE, **kwargs):
        super().__init__(**kwargs)
        self.__name = name
        self.__description = description
        self.___id = _id
        self.__scriptableValues = list()
        self.__line = None
        self.__segment = segment
        self.__allSegments = allSegments
        self.__elementNumber = elementNumber
        self.__allElements = allElements
        self.__nodeNumber = nodeNumber
        self.__allNodes = allNodes
        self.__allEnds = allEnds
        self.__elementEnd = elementEnd
        self.__location = location
        self.__superNode = None
        self.__artificialStiffness = artificialStiffness
        self.__stx = stx
        self.__sty = sty
        self.__stz = stz
        self.__srx = srx
        self.__sry = sry
        self.__srz = srz
        self.__constraint = constraint
        self.__finalPosition = Position()
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return SlenderSystemConnectionBlueprint()


    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = str(value)

    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = str(value)

    @property
    def _id(self) -> str:
        """"""
        return self.___id

    @_id.setter
    def _id(self, value: str):
        """Set _id"""
        self.___id = str(value)

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def line(self) -> ARLine:
        """Line"""
        return self.__line

    @line.setter
    def line(self, value: ARLine):
        """Set line"""
        self.__line = value

    @property
    def segment(self) -> int:
        """Segment on given line"""
        return self.__segment

    @segment.setter
    def segment(self, value: int):
        """Set segment"""
        self.__segment = int(value)

    @property
    def allSegments(self) -> bool:
        """All segments"""
        return self.__allSegments

    @allSegments.setter
    def allSegments(self, value: bool):
        """Set allSegments"""
        self.__allSegments = bool(value)

    @property
    def elementNumber(self) -> int:
        """Local element number on actual segment"""
        return self.__elementNumber

    @elementNumber.setter
    def elementNumber(self, value: int):
        """Set elementNumber"""
        self.__elementNumber = int(value)

    @property
    def allElements(self) -> bool:
        """All elements"""
        return self.__allElements

    @allElements.setter
    def allElements(self, value: bool):
        """Set allElements"""
        self.__allElements = bool(value)

    @property
    def nodeNumber(self) -> int:
        """Local node number on actual segment"""
        return self.__nodeNumber

    @nodeNumber.setter
    def nodeNumber(self, value: int):
        """Set nodeNumber"""
        self.__nodeNumber = int(value)

    @property
    def allNodes(self) -> bool:
        """All nodes"""
        return self.__allNodes

    @allNodes.setter
    def allNodes(self, value: bool):
        """Set allNodes"""
        self.__allNodes = bool(value)

    @property
    def allEnds(self) -> bool:
        """All ends"""
        return self.__allEnds

    @allEnds.setter
    def allEnds(self, value: bool):
        """Set allEnds"""
        self.__allEnds = bool(value)

    @property
    def elementEnd(self) -> End:
        """End number 1 or 2"""
        return self.__elementEnd

    @elementEnd.setter
    def elementEnd(self, value: End):
        """Set elementEnd"""
        self.__elementEnd = value

    @property
    def location(self) -> BodyLocation:
        """If a supernode is used as location option and it is not part of a line, a dummy line will be created automatically."""
        return self.__location

    @location.setter
    def location(self, value: BodyLocation):
        """Set location"""
        self.__location = value

    @property
    def superNode(self) -> SuperNode:
        """Line"""
        return self.__superNode

    @superNode.setter
    def superNode(self, value: SuperNode):
        """Set superNode"""
        self.__superNode = value

    @property
    def artificialStiffness(self) -> bool:
        """Artificial stiffness option"""
        return self.__artificialStiffness

    @artificialStiffness.setter
    def artificialStiffness(self, value: bool):
        """Set artificialStiffness"""
        self.__artificialStiffness = bool(value)

    @property
    def stx(self) -> float:
        """Stiffness in global X-direction"""
        return self.__stx

    @stx.setter
    def stx(self, value: float):
        """Set stx"""
        self.__stx = float(value)

    @property
    def sty(self) -> float:
        """Stiffness in global Y-direction"""
        return self.__sty

    @sty.setter
    def sty(self, value: float):
        """Set sty"""
        self.__sty = float(value)

    @property
    def stz(self) -> float:
        """Stiffness in global Z-direction"""
        return self.__stz

    @stz.setter
    def stz(self, value: float):
        """Set stz"""
        self.__stz = float(value)

    @property
    def srx(self) -> float:
        """Stiffness around global X-direction"""
        return self.__srx

    @srx.setter
    def srx(self, value: float):
        """Set srx"""
        self.__srx = float(value)

    @property
    def sry(self) -> float:
        """Stiffness around global Y-direction"""
        return self.__sry

    @sry.setter
    def sry(self, value: float):
        """Set sry"""
        self.__sry = float(value)

    @property
    def srz(self) -> float:
        """Stiffness around global Z-direction"""
        return self.__srz

    @srz.setter
    def srz(self, value: float):
        """Set srz"""
        self.__srz = float(value)

    @property
    def constraint(self) -> NodeConstraint:
        """Supernode type."""
        return self.__constraint

    @constraint.setter
    def constraint(self, value: NodeConstraint):
        """Set constraint"""
        self.__constraint = value

    @property
    def finalPosition(self) -> Position:
        """"""
        return self.__finalPosition

    @finalPosition.setter
    def finalPosition(self, value: Position):
        """Set finalPosition"""
        self.__finalPosition = value
