# This an autogenerated file
# 
# Generated with RegularSegment
from __future__ import annotations
from typing import Dict,Sequence,List
from dmt.entity import Entity
from dmt.blueprint import Blueprint
from .blueprints.regularsegment import RegularSegmentBlueprint
from sima.sima.moao import MOAO
from sima.sima.scriptablevalue import ScriptableValue
from typing import TYPE_CHECKING
if TYPE_CHECKING:
    from sima.riflex.crosssection import CrossSection
    from sima.riflex.nodalcomponenttype import NodalComponentType
    from sima.riflex.externalwrappingtype import ExternalWrappingType

class RegularSegment(MOAO):
    """
    Keyword arguments
    -----------------
    name : str
         (default "")
    description : str
         (default "")
    _id : str
         (default "")
    scriptableValues : List[ScriptableValue]
    length : float
         Length of the segment.(default 0.0)
    numElements : int
         Number of elements(default 10)
    crossSection : CrossSection
         Cross-sectional component type.
    nodalComponent : NodalComponentType
         Nodal component (body or connector) attached at end 1 of the segment.
    externalWrapping : ExternalWrappingType
         External wrapping (distributed weight or buoyancy) component.
    numSubElementsStatic : int
         Number of subelements each element is divided into for hydrodynamic calculation; static analysis.(default 3)
    numSubElementsDynamic : int
         Number of subelements each element is divided into for hydrodynamic load calculation; dynamic analysis.(default 5)
    stressfreeLength : float
         Actual stressfree segment length.(default 0.0)
    twistEnd1 : float
         Relative twist segment end 1(default 0.0)
    twistEnd2 : float
         Relative twist segment end 2(default 0.0)
    offsetY : float
         Offset in line local Y-axis segment end 2(default 0.0)
    offsetZ : float
         Offset in line local Z-axis segment end 2(default 0.0)
    """

    def __init__(self , name:str="", description:str="", _id:str="", length:float=0.0, numElements:int=10, numSubElementsStatic:int=3, numSubElementsDynamic:int=5, stressfreeLength:float=0.0, twistEnd1:float=0.0, twistEnd2:float=0.0, offsetY:float=0.0, offsetZ:float=0.0, **kwargs):
        super().__init__(**kwargs)
        self.__name = name
        self.__description = description
        self.___id = _id
        self.__scriptableValues = list()
        self.__length = length
        self.__numElements = numElements
        self.__crossSection = None
        self.__nodalComponent = None
        self.__externalWrapping = None
        self.__numSubElementsStatic = numSubElementsStatic
        self.__numSubElementsDynamic = numSubElementsDynamic
        self.__stressfreeLength = stressfreeLength
        self.__twistEnd1 = twistEnd1
        self.__twistEnd2 = twistEnd2
        self.__offsetY = offsetY
        self.__offsetZ = offsetZ
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return RegularSegmentBlueprint()


    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = str(value)

    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = str(value)

    @property
    def _id(self) -> str:
        """"""
        return self.___id

    @_id.setter
    def _id(self, value: str):
        """Set _id"""
        self.___id = str(value)

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def length(self) -> float:
        """Length of the segment."""
        return self.__length

    @length.setter
    def length(self, value: float):
        """Set length"""
        self.__length = float(value)

    @property
    def numElements(self) -> int:
        """Number of elements"""
        return self.__numElements

    @numElements.setter
    def numElements(self, value: int):
        """Set numElements"""
        self.__numElements = int(value)

    @property
    def crossSection(self) -> CrossSection:
        """Cross-sectional component type."""
        return self.__crossSection

    @crossSection.setter
    def crossSection(self, value: CrossSection):
        """Set crossSection"""
        self.__crossSection = value

    @property
    def nodalComponent(self) -> NodalComponentType:
        """Nodal component (body or connector) attached at end 1 of the segment."""
        return self.__nodalComponent

    @nodalComponent.setter
    def nodalComponent(self, value: NodalComponentType):
        """Set nodalComponent"""
        self.__nodalComponent = value

    @property
    def externalWrapping(self) -> ExternalWrappingType:
        """External wrapping (distributed weight or buoyancy) component."""
        return self.__externalWrapping

    @externalWrapping.setter
    def externalWrapping(self, value: ExternalWrappingType):
        """Set externalWrapping"""
        self.__externalWrapping = value

    @property
    def numSubElementsStatic(self) -> int:
        """Number of subelements each element is divided into for hydrodynamic calculation; static analysis."""
        return self.__numSubElementsStatic

    @numSubElementsStatic.setter
    def numSubElementsStatic(self, value: int):
        """Set numSubElementsStatic"""
        self.__numSubElementsStatic = int(value)

    @property
    def numSubElementsDynamic(self) -> int:
        """Number of subelements each element is divided into for hydrodynamic load calculation; dynamic analysis."""
        return self.__numSubElementsDynamic

    @numSubElementsDynamic.setter
    def numSubElementsDynamic(self, value: int):
        """Set numSubElementsDynamic"""
        self.__numSubElementsDynamic = int(value)

    @property
    def stressfreeLength(self) -> float:
        """Actual stressfree segment length."""
        return self.__stressfreeLength

    @stressfreeLength.setter
    def stressfreeLength(self, value: float):
        """Set stressfreeLength"""
        self.__stressfreeLength = float(value)

    @property
    def twistEnd1(self) -> float:
        """Relative twist segment end 1"""
        return self.__twistEnd1

    @twistEnd1.setter
    def twistEnd1(self, value: float):
        """Set twistEnd1"""
        self.__twistEnd1 = float(value)

    @property
    def twistEnd2(self) -> float:
        """Relative twist segment end 2"""
        return self.__twistEnd2

    @twistEnd2.setter
    def twistEnd2(self, value: float):
        """Set twistEnd2"""
        self.__twistEnd2 = float(value)

    @property
    def offsetY(self) -> float:
        """Offset in line local Y-axis segment end 2"""
        return self.__offsetY

    @offsetY.setter
    def offsetY(self, value: float):
        """Set offsetY"""
        self.__offsetY = float(value)

    @property
    def offsetZ(self) -> float:
        """Offset in line local Z-axis segment end 2"""
        return self.__offsetZ

    @offsetZ.setter
    def offsetZ(self, value: float):
        """Set offsetZ"""
        self.__offsetZ = float(value)
