# This an autogenerated file
# 
# Generated with ReferenceFrame
from __future__ import annotations
from typing import Dict,Sequence,List
from dmt.entity import Entity
from dmt.blueprint import Blueprint
from .blueprints.referenceframe import ReferenceFrameBlueprint
from sima.sima.namedobject import NamedObject
from sima.sima.scriptablevalue import ScriptableValue

class ReferenceFrame(NamedObject):
    """
    Keyword arguments
    -----------------
    name : str
         (default "")
    description : str
         (default "")
    _id : str
         (default "")
    scriptableValues : List[ScriptableValue]
    parent : ReferenceFrame
    xGlobal : float
         Global coordinate X(default 0.0)
    yGlobal : float
         Global coordinate Y(default 0.0)
    zGlobal : float
         Global coordinate Z(default 0.0)
    rxGlobal : float
         Global  X-axis rotation(default 0.0)
    ryGlobal : float
         Global  Y-axis rotation(default 0.0)
    rzGlobal : float
         Global  Z-axis rotation(default 0.0)
    """

    def __init__(self , name:str="", description:str="", _id:str="", xGlobal:float=0.0, yGlobal:float=0.0, zGlobal:float=0.0, rxGlobal:float=0.0, ryGlobal:float=0.0, rzGlobal:float=0.0, **kwargs):
        super().__init__(**kwargs)
        self.__name = name
        self.__description = description
        self.___id = _id
        self.__scriptableValues = list()
        self.__parent = None
        self.__xGlobal = xGlobal
        self.__yGlobal = yGlobal
        self.__zGlobal = zGlobal
        self.__rxGlobal = rxGlobal
        self.__ryGlobal = ryGlobal
        self.__rzGlobal = rzGlobal
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return ReferenceFrameBlueprint()


    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = str(value)

    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = str(value)

    @property
    def _id(self) -> str:
        """"""
        return self.___id

    @_id.setter
    def _id(self, value: str):
        """Set _id"""
        self.___id = str(value)

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def parent(self) -> ReferenceFrame:
        """"""
        return self.__parent

    @parent.setter
    def parent(self, value: ReferenceFrame):
        """Set parent"""
        self.__parent = value

    @property
    def xGlobal(self) -> float:
        """Global coordinate X"""
        return self.__xGlobal

    @xGlobal.setter
    def xGlobal(self, value: float):
        """Set xGlobal"""
        self.__xGlobal = float(value)

    @property
    def yGlobal(self) -> float:
        """Global coordinate Y"""
        return self.__yGlobal

    @yGlobal.setter
    def yGlobal(self, value: float):
        """Set yGlobal"""
        self.__yGlobal = float(value)

    @property
    def zGlobal(self) -> float:
        """Global coordinate Z"""
        return self.__zGlobal

    @zGlobal.setter
    def zGlobal(self, value: float):
        """Set zGlobal"""
        self.__zGlobal = float(value)

    @property
    def rxGlobal(self) -> float:
        """Global  X-axis rotation"""
        return self.__rxGlobal

    @rxGlobal.setter
    def rxGlobal(self, value: float):
        """Set rxGlobal"""
        self.__rxGlobal = float(value)

    @property
    def ryGlobal(self) -> float:
        """Global  Y-axis rotation"""
        return self.__ryGlobal

    @ryGlobal.setter
    def ryGlobal(self, value: float):
        """Set ryGlobal"""
        self.__ryGlobal = float(value)

    @property
    def rzGlobal(self) -> float:
        """Global  Z-axis rotation"""
        return self.__rzGlobal

    @rzGlobal.setter
    def rzGlobal(self, value: float):
        """Set rzGlobal"""
        self.__rzGlobal = float(value)
