# This an autogenerated file
# 
# Generated with PotentialFlowLibrary
from typing import Dict,Sequence,List
from dmt.entity import Entity
from dmt.blueprint import Blueprint
from .blueprints.potentialflowlibrary import PotentialFlowLibraryBlueprint
from sima.riflex.elementreference import ElementReference
from sima.sima.moao import MOAO
from sima.sima.scriptablevalue import ScriptableValue

class PotentialFlowLibrary(MOAO):
    """
    Keyword arguments
    -----------------
    name : str
         (default "")
    description : str
         (default "")
    _id : str
         (default "")
    scriptableValues : List[ScriptableValue]
    file : str
         Potential flow library file(default "")
    elements : List[ElementReference]
    """

    def __init__(self , name:str="", description:str="", _id:str="", file:str="", **kwargs):
        super().__init__(**kwargs)
        self.__name = name
        self.__description = description
        self.___id = _id
        self.__scriptableValues = list()
        self.__file = file
        self.__elements = list()
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return PotentialFlowLibraryBlueprint()


    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = str(value)

    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = str(value)

    @property
    def _id(self) -> str:
        """"""
        return self.___id

    @_id.setter
    def _id(self, value: str):
        """Set _id"""
        self.___id = str(value)

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def file(self) -> str:
        """Potential flow library file"""
        return self.__file

    @file.setter
    def file(self, value: str):
        """Set file"""
        self.__file = str(value)

    @property
    def elements(self) -> List[ElementReference]:
        """"""
        return self.__elements

    @elements.setter
    def elements(self, value: List[ElementReference]):
        """Set elements"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__elements = value
