# This an autogenerated file
# 
# Generated with NonLinearIntegrationProcedure
from typing import Dict,Sequence,List
from dmt.entity import Entity
from dmt.blueprint import Blueprint
from .blueprints.nonlinearintegrationprocedure import NonLinearIntegrationProcedureBlueprint
from sima.riflex.convergencenorm import ConvergenceNorm
from sima.riflex.iterationcontinuationcode import IterationContinuationCode
from sima.riflex.iterationtype import IterationType
from sima.sima.moao import MOAO
from sima.sima.scriptablevalue import ScriptableValue

class NonLinearIntegrationProcedure(MOAO):
    """
    Keyword arguments
    -----------------
    name : str
         (default "")
    description : str
         (default "")
    _id : str
         (default "")
    scriptableValues : List[ScriptableValue]
    equilibriumIterationFrequency : int
         Frequency of equilibrium iteration(default 1)
    iterationType : IterationType
         Type of iteration if iteration is to be performed
    maxIterations : int
         Maximum number of iterations for steps with iteration(default 10)
    convergenceNorm : ConvergenceNorm
    equilibriumIterationAccuracy : float
         Desired accuracy for equilibrium iteration measured by a modified euclidian displacement norm (norm of squared translations). Recommended values: 10e-6 - 10e-5.(default 1e-05)
    energyAccuracy : float
         Required accuracy measured by energy norm. This value is relevant only if Convergence Norm is 'Both'.(default 1e-05)
    iterationContinuation : IterationContinuationCode
         Code for continuation after iteration
    autoTimeStepSubdivision : int
         Code for automatic subdivision of time step(default 0)
    timeIntegrationInfo : int
         Code for time integration information(default 1)
    """

    def __init__(self , name:str="", description:str="", _id:str="", equilibriumIterationFrequency:int=1, iterationType:IterationType=IterationType.TRUE_NEWTON_RAPHSON, maxIterations:int=10, convergenceNorm:ConvergenceNorm=ConvergenceNorm.DISP, equilibriumIterationAccuracy:float=1e-05, energyAccuracy:float=1e-05, iterationContinuation:IterationContinuationCode=IterationContinuationCode.CONTINUED, autoTimeStepSubdivision:int=0, timeIntegrationInfo:int=1, **kwargs):
        super().__init__(**kwargs)
        self.__name = name
        self.__description = description
        self.___id = _id
        self.__scriptableValues = list()
        self.__equilibriumIterationFrequency = equilibriumIterationFrequency
        self.__iterationType = iterationType
        self.__maxIterations = maxIterations
        self.__convergenceNorm = convergenceNorm
        self.__equilibriumIterationAccuracy = equilibriumIterationAccuracy
        self.__energyAccuracy = energyAccuracy
        self.__iterationContinuation = iterationContinuation
        self.__autoTimeStepSubdivision = autoTimeStepSubdivision
        self.__timeIntegrationInfo = timeIntegrationInfo
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return NonLinearIntegrationProcedureBlueprint()


    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = str(value)

    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = str(value)

    @property
    def _id(self) -> str:
        """"""
        return self.___id

    @_id.setter
    def _id(self, value: str):
        """Set _id"""
        self.___id = str(value)

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def equilibriumIterationFrequency(self) -> int:
        """Frequency of equilibrium iteration"""
        return self.__equilibriumIterationFrequency

    @equilibriumIterationFrequency.setter
    def equilibriumIterationFrequency(self, value: int):
        """Set equilibriumIterationFrequency"""
        self.__equilibriumIterationFrequency = int(value)

    @property
    def iterationType(self) -> IterationType:
        """Type of iteration if iteration is to be performed"""
        return self.__iterationType

    @iterationType.setter
    def iterationType(self, value: IterationType):
        """Set iterationType"""
        self.__iterationType = value

    @property
    def maxIterations(self) -> int:
        """Maximum number of iterations for steps with iteration"""
        return self.__maxIterations

    @maxIterations.setter
    def maxIterations(self, value: int):
        """Set maxIterations"""
        self.__maxIterations = int(value)

    @property
    def convergenceNorm(self) -> ConvergenceNorm:
        """"""
        return self.__convergenceNorm

    @convergenceNorm.setter
    def convergenceNorm(self, value: ConvergenceNorm):
        """Set convergenceNorm"""
        self.__convergenceNorm = value

    @property
    def equilibriumIterationAccuracy(self) -> float:
        """Desired accuracy for equilibrium iteration measured by a modified euclidian displacement norm (norm of squared translations). Recommended values: 10e-6 - 10e-5."""
        return self.__equilibriumIterationAccuracy

    @equilibriumIterationAccuracy.setter
    def equilibriumIterationAccuracy(self, value: float):
        """Set equilibriumIterationAccuracy"""
        self.__equilibriumIterationAccuracy = float(value)

    @property
    def energyAccuracy(self) -> float:
        """Required accuracy measured by energy norm. This value is relevant only if Convergence Norm is 'Both'."""
        return self.__energyAccuracy

    @energyAccuracy.setter
    def energyAccuracy(self, value: float):
        """Set energyAccuracy"""
        self.__energyAccuracy = float(value)

    @property
    def iterationContinuation(self) -> IterationContinuationCode:
        """Code for continuation after iteration"""
        return self.__iterationContinuation

    @iterationContinuation.setter
    def iterationContinuation(self, value: IterationContinuationCode):
        """Set iterationContinuation"""
        self.__iterationContinuation = value

    @property
    def autoTimeStepSubdivision(self) -> int:
        """Code for automatic subdivision of time step"""
        return self.__autoTimeStepSubdivision

    @autoTimeStepSubdivision.setter
    def autoTimeStepSubdivision(self, value: int):
        """Set autoTimeStepSubdivision"""
        self.__autoTimeStepSubdivision = int(value)

    @property
    def timeIntegrationInfo(self) -> int:
        """Code for time integration information"""
        return self.__timeIntegrationInfo

    @timeIntegrationInfo.setter
    def timeIntegrationInfo(self, value: int):
        """Set timeIntegrationInfo"""
        self.__timeIntegrationInfo = int(value)
