# This an autogenerated file
# 
# Generated with IrregularResponseAnalysis
from typing import Dict,Sequence,List
from dmt.entity import Entity
from dmt.blueprint import Blueprint
from .blueprints.irregularresponseanalysis import IrregularResponseAnalysisBlueprint
from sima.riflex.irregularmotionindicator import IrregularMotionIndicator
from sima.riflex.irregularwaveindicator import IrregularWaveIndicator
from sima.riflex.irregularwaveprocedure import IrregularWaveProcedure
from sima.riflex.lfmotiontimeseries import LFMotionTimeSeries
from sima.riflex.lowfrequencymotionindicator import LowFrequencyMotionIndicator
from sima.riflex.supportvesselmotionscalingitem import SupportVesselMotionScalingItem
from sima.riflex.wavetimeseries import WaveTimeSeries
from sima.riflex.wfmotiontimeseries import WFMotionTimeSeries
from sima.sima.moao import MOAO
from sima.sima.scriptablevalue import ScriptableValue

class IrregularResponseAnalysis(MOAO):
    """
    Keyword arguments
    -----------------
    name : str
         (default "")
    description : str
         (default "")
    _id : str
         (default "")
    scriptableValues : List[ScriptableValue]
    waveTimeSeriesFile : bool
         Wave time series read from file(default False)
    simulationLength : float
         Length of simulation(default 11000.0)
    timeStep : float
         Simulation time step(default 0.1)
    irrWaveIndicator : IrregularWaveIndicator
         Irregular wave indicator
    irrMotionIndicator : IrregularMotionIndicator
         Irregular motion indicator
    lowFrequencyMotionIndicator : LowFrequencyMotionIndicator
         Low frequency motion indicator
    simulationStartTime : float
         Time (in generated time series) that dynamic simulation will start from(default 0.0)
    motionScaling : bool
         Switch for scaling of terminal point motions(default False)
    supportVesselMotionScalingItems : List[SupportVesselMotionScalingItem]
    irregularWaveProcedure : IrregularWaveProcedure
    waveTimeSeries : WaveTimeSeries
    wfMotionTimeSeries : List[WFMotionTimeSeries]
    lfMotionTimeSeries : List[LFMotionTimeSeries]
    """

    def __init__(self , name:str="", description:str="", _id:str="", waveTimeSeriesFile:bool=False, simulationLength:float=11000.0, timeStep:float=0.1, irrWaveIndicator:IrregularWaveIndicator=IrregularWaveIndicator.NEW, irrMotionIndicator:IrregularMotionIndicator=IrregularMotionIndicator.STAT, lowFrequencyMotionIndicator:LowFrequencyMotionIndicator=LowFrequencyMotionIndicator.NONE, simulationStartTime:float=0.0, motionScaling:bool=False, **kwargs):
        super().__init__(**kwargs)
        self.__name = name
        self.__description = description
        self.___id = _id
        self.__scriptableValues = list()
        self.__waveTimeSeriesFile = waveTimeSeriesFile
        self.__simulationLength = simulationLength
        self.__timeStep = timeStep
        self.__irrWaveIndicator = irrWaveIndicator
        self.__irrMotionIndicator = irrMotionIndicator
        self.__lowFrequencyMotionIndicator = lowFrequencyMotionIndicator
        self.__simulationStartTime = simulationStartTime
        self.__motionScaling = motionScaling
        self.__supportVesselMotionScalingItems = list()
        self.__irregularWaveProcedure = IrregularWaveProcedure()
        self.__waveTimeSeries = WaveTimeSeries()
        self.__wfMotionTimeSeries = list()
        self.__lfMotionTimeSeries = list()
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return IrregularResponseAnalysisBlueprint()


    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = str(value)

    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = str(value)

    @property
    def _id(self) -> str:
        """"""
        return self.___id

    @_id.setter
    def _id(self, value: str):
        """Set _id"""
        self.___id = str(value)

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def waveTimeSeriesFile(self) -> bool:
        """Wave time series read from file"""
        return self.__waveTimeSeriesFile

    @waveTimeSeriesFile.setter
    def waveTimeSeriesFile(self, value: bool):
        """Set waveTimeSeriesFile"""
        self.__waveTimeSeriesFile = bool(value)

    @property
    def simulationLength(self) -> float:
        """Length of simulation"""
        return self.__simulationLength

    @simulationLength.setter
    def simulationLength(self, value: float):
        """Set simulationLength"""
        self.__simulationLength = float(value)

    @property
    def timeStep(self) -> float:
        """Simulation time step"""
        return self.__timeStep

    @timeStep.setter
    def timeStep(self, value: float):
        """Set timeStep"""
        self.__timeStep = float(value)

    @property
    def irrWaveIndicator(self) -> IrregularWaveIndicator:
        """Irregular wave indicator"""
        return self.__irrWaveIndicator

    @irrWaveIndicator.setter
    def irrWaveIndicator(self, value: IrregularWaveIndicator):
        """Set irrWaveIndicator"""
        self.__irrWaveIndicator = value

    @property
    def irrMotionIndicator(self) -> IrregularMotionIndicator:
        """Irregular motion indicator"""
        return self.__irrMotionIndicator

    @irrMotionIndicator.setter
    def irrMotionIndicator(self, value: IrregularMotionIndicator):
        """Set irrMotionIndicator"""
        self.__irrMotionIndicator = value

    @property
    def lowFrequencyMotionIndicator(self) -> LowFrequencyMotionIndicator:
        """Low frequency motion indicator"""
        return self.__lowFrequencyMotionIndicator

    @lowFrequencyMotionIndicator.setter
    def lowFrequencyMotionIndicator(self, value: LowFrequencyMotionIndicator):
        """Set lowFrequencyMotionIndicator"""
        self.__lowFrequencyMotionIndicator = value

    @property
    def simulationStartTime(self) -> float:
        """Time (in generated time series) that dynamic simulation will start from"""
        return self.__simulationStartTime

    @simulationStartTime.setter
    def simulationStartTime(self, value: float):
        """Set simulationStartTime"""
        self.__simulationStartTime = float(value)

    @property
    def motionScaling(self) -> bool:
        """Switch for scaling of terminal point motions"""
        return self.__motionScaling

    @motionScaling.setter
    def motionScaling(self, value: bool):
        """Set motionScaling"""
        self.__motionScaling = bool(value)

    @property
    def supportVesselMotionScalingItems(self) -> List[SupportVesselMotionScalingItem]:
        """"""
        return self.__supportVesselMotionScalingItems

    @supportVesselMotionScalingItems.setter
    def supportVesselMotionScalingItems(self, value: List[SupportVesselMotionScalingItem]):
        """Set supportVesselMotionScalingItems"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__supportVesselMotionScalingItems = value

    @property
    def irregularWaveProcedure(self) -> IrregularWaveProcedure:
        """"""
        return self.__irregularWaveProcedure

    @irregularWaveProcedure.setter
    def irregularWaveProcedure(self, value: IrregularWaveProcedure):
        """Set irregularWaveProcedure"""
        self.__irregularWaveProcedure = value

    @property
    def waveTimeSeries(self) -> WaveTimeSeries:
        """"""
        return self.__waveTimeSeries

    @waveTimeSeries.setter
    def waveTimeSeries(self, value: WaveTimeSeries):
        """Set waveTimeSeries"""
        self.__waveTimeSeries = value

    @property
    def wfMotionTimeSeries(self) -> List[WFMotionTimeSeries]:
        """"""
        return self.__wfMotionTimeSeries

    @wfMotionTimeSeries.setter
    def wfMotionTimeSeries(self, value: List[WFMotionTimeSeries]):
        """Set wfMotionTimeSeries"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__wfMotionTimeSeries = value

    @property
    def lfMotionTimeSeries(self) -> List[LFMotionTimeSeries]:
        """"""
        return self.__lfMotionTimeSeries

    @lfMotionTimeSeries.setter
    def lfMotionTimeSeries(self, value: List[LFMotionTimeSeries]):
        """Set lfMotionTimeSeries"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__lfMotionTimeSeries = value
