# This an autogenerated file
# 
# Generated with GeotechnicalSpring
from __future__ import annotations
from typing import Dict,Sequence,List
from dmt.entity import Entity
from dmt.blueprint import Blueprint
from .blueprints.geotechnicalspring import GeotechnicalSpringBlueprint
from sima.riflex.dampingdisplacementitem import DampingDisplacementItem
from sima.riflex.geotechnicalspringstiffnessitem import GeotechnicalSpringStiffnessItem
from sima.riflex.nodereference import NodeReference
from sima.sima.namedobject import NamedObject
from sima.sima.scriptablevalue import ScriptableValue
from typing import TYPE_CHECKING
if TYPE_CHECKING:
    from sima.riflex.arline import ARLine

class GeotechnicalSpring(NodeReference,NamedObject):
    """
    Keyword arguments
    -----------------
    name : str
         (default "")
    description : str
         (default "")
    _id : str
         (default "")
    scriptableValues : List[ScriptableValue]
    line : ARLine
         Line
    segment : int
         Segment on given line(default 1)
    allSegments : bool
         All segments(default False)
    nodeNumber : int
         Local node number on actual segment(default 1)
    allNodes : bool
         All nodes(default False)
    stiffnessItems : List[GeotechnicalSpringStiffnessItem]
    dampingDisplacementItems : List[DampingDisplacementItem]
    strainVelocityExponent : float
         (default 1.0)
    relativeLength : float
         Relative length for result scaling(default 1.0)
    """

    def __init__(self , name:str="", description:str="", _id:str="", segment:int=1, allSegments:bool=False, nodeNumber:int=1, allNodes:bool=False, strainVelocityExponent:float=1.0, relativeLength:float=1.0, **kwargs):
        super().__init__(**kwargs)
        self.__name = name
        self.__description = description
        self.___id = _id
        self.__scriptableValues = list()
        self.__line = None
        self.__segment = segment
        self.__allSegments = allSegments
        self.__nodeNumber = nodeNumber
        self.__allNodes = allNodes
        self.__stiffnessItems = list()
        self.__dampingDisplacementItems = list()
        self.__strainVelocityExponent = strainVelocityExponent
        self.__relativeLength = relativeLength
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return GeotechnicalSpringBlueprint()


    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = str(value)

    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = str(value)

    @property
    def _id(self) -> str:
        """"""
        return self.___id

    @_id.setter
    def _id(self, value: str):
        """Set _id"""
        self.___id = str(value)

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def line(self) -> ARLine:
        """Line"""
        return self.__line

    @line.setter
    def line(self, value: ARLine):
        """Set line"""
        self.__line = value

    @property
    def segment(self) -> int:
        """Segment on given line"""
        return self.__segment

    @segment.setter
    def segment(self, value: int):
        """Set segment"""
        self.__segment = int(value)

    @property
    def allSegments(self) -> bool:
        """All segments"""
        return self.__allSegments

    @allSegments.setter
    def allSegments(self, value: bool):
        """Set allSegments"""
        self.__allSegments = bool(value)

    @property
    def nodeNumber(self) -> int:
        """Local node number on actual segment"""
        return self.__nodeNumber

    @nodeNumber.setter
    def nodeNumber(self, value: int):
        """Set nodeNumber"""
        self.__nodeNumber = int(value)

    @property
    def allNodes(self) -> bool:
        """All nodes"""
        return self.__allNodes

    @allNodes.setter
    def allNodes(self, value: bool):
        """Set allNodes"""
        self.__allNodes = bool(value)

    @property
    def stiffnessItems(self) -> List[GeotechnicalSpringStiffnessItem]:
        """"""
        return self.__stiffnessItems

    @stiffnessItems.setter
    def stiffnessItems(self, value: List[GeotechnicalSpringStiffnessItem]):
        """Set stiffnessItems"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__stiffnessItems = value

    @property
    def dampingDisplacementItems(self) -> List[DampingDisplacementItem]:
        """"""
        return self.__dampingDisplacementItems

    @dampingDisplacementItems.setter
    def dampingDisplacementItems(self, value: List[DampingDisplacementItem]):
        """Set dampingDisplacementItems"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__dampingDisplacementItems = value

    @property
    def strainVelocityExponent(self) -> float:
        """"""
        return self.__strainVelocityExponent

    @strainVelocityExponent.setter
    def strainVelocityExponent(self, value: float):
        """Set strainVelocityExponent"""
        self.__strainVelocityExponent = float(value)

    @property
    def relativeLength(self) -> float:
        """Relative length for result scaling"""
        return self.__relativeLength

    @relativeLength.setter
    def relativeLength(self, value: float):
        """Set relativeLength"""
        self.__relativeLength = float(value)
