# This an autogenerated file
# 
# Generated with DynamicWindChange
from typing import Dict,Sequence,List
from dmt.entity import Entity
from dmt.blueprint import Blueprint
from .blueprints.dynamicwindchange import DynamicWindChangeBlueprint
from sima.riflex.iec2005windeventtype import IEC2005WindEventType
from sima.riflex.iec2005windturbineclass import IEC2005WindTurbineClass
from sima.riflex.winddirection import WindDirection
from sima.sima.moao import MOAO
from sima.sima.scriptablevalue import ScriptableValue

class DynamicWindChange(MOAO):
    """
    Keyword arguments
    -----------------
    name : str
         (default "")
    description : str
         (default "")
    _id : str
         (default "")
    scriptableValues : List[ScriptableValue]
    include : bool
         (default False)
    eventType : IEC2005WindEventType
    eventStartTime : float
         Time for event to start(default 0.0)
    direction : WindDirection
    turbineClass : IEC2005WindTurbineClass
    vref : float
         Reference wind speed average over 10 minutes(default 0.0)
    iref : float
         Expected value of the turbulence intensity at 15 m/s(default 0.0)
    velocityChange : float
         (default 0.0)
    directionChange : float
         (default 0.0)
    durationOfEvent : float
         (default 0.0)
    gustMagnitude : float
         (default 0.0)
    """

    def __init__(self , name:str="", description:str="", _id:str="", include:bool=False, eventType:IEC2005WindEventType=IEC2005WindEventType.ECD, eventStartTime:float=0.0, direction:WindDirection=WindDirection.POSITIVE, turbineClass:IEC2005WindTurbineClass=IEC2005WindTurbineClass.NONE, vref:float=0.0, iref:float=0.0, velocityChange:float=0.0, directionChange:float=0.0, durationOfEvent:float=0.0, gustMagnitude:float=0.0, **kwargs):
        super().__init__(**kwargs)
        self.__name = name
        self.__description = description
        self.___id = _id
        self.__scriptableValues = list()
        self.__include = include
        self.__eventType = eventType
        self.__eventStartTime = eventStartTime
        self.__direction = direction
        self.__turbineClass = turbineClass
        self.__vref = vref
        self.__iref = iref
        self.__velocityChange = velocityChange
        self.__directionChange = directionChange
        self.__durationOfEvent = durationOfEvent
        self.__gustMagnitude = gustMagnitude
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return DynamicWindChangeBlueprint()


    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = str(value)

    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = str(value)

    @property
    def _id(self) -> str:
        """"""
        return self.___id

    @_id.setter
    def _id(self, value: str):
        """Set _id"""
        self.___id = str(value)

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def include(self) -> bool:
        """"""
        return self.__include

    @include.setter
    def include(self, value: bool):
        """Set include"""
        self.__include = bool(value)

    @property
    def eventType(self) -> IEC2005WindEventType:
        """"""
        return self.__eventType

    @eventType.setter
    def eventType(self, value: IEC2005WindEventType):
        """Set eventType"""
        self.__eventType = value

    @property
    def eventStartTime(self) -> float:
        """Time for event to start"""
        return self.__eventStartTime

    @eventStartTime.setter
    def eventStartTime(self, value: float):
        """Set eventStartTime"""
        self.__eventStartTime = float(value)

    @property
    def direction(self) -> WindDirection:
        """"""
        return self.__direction

    @direction.setter
    def direction(self, value: WindDirection):
        """Set direction"""
        self.__direction = value

    @property
    def turbineClass(self) -> IEC2005WindTurbineClass:
        """"""
        return self.__turbineClass

    @turbineClass.setter
    def turbineClass(self, value: IEC2005WindTurbineClass):
        """Set turbineClass"""
        self.__turbineClass = value

    @property
    def vref(self) -> float:
        """Reference wind speed average over 10 minutes"""
        return self.__vref

    @vref.setter
    def vref(self, value: float):
        """Set vref"""
        self.__vref = float(value)

    @property
    def iref(self) -> float:
        """Expected value of the turbulence intensity at 15 m/s"""
        return self.__iref

    @iref.setter
    def iref(self, value: float):
        """Set iref"""
        self.__iref = float(value)

    @property
    def velocityChange(self) -> float:
        """"""
        return self.__velocityChange

    @velocityChange.setter
    def velocityChange(self, value: float):
        """Set velocityChange"""
        self.__velocityChange = float(value)

    @property
    def directionChange(self) -> float:
        """"""
        return self.__directionChange

    @directionChange.setter
    def directionChange(self, value: float):
        """Set directionChange"""
        self.__directionChange = float(value)

    @property
    def durationOfEvent(self) -> float:
        """"""
        return self.__durationOfEvent

    @durationOfEvent.setter
    def durationOfEvent(self, value: float):
        """Set durationOfEvent"""
        self.__durationOfEvent = float(value)

    @property
    def gustMagnitude(self) -> float:
        """"""
        return self.__gustMagnitude

    @gustMagnitude.setter
    def gustMagnitude(self, value: float):
        """Set gustMagnitude"""
        self.__gustMagnitude = float(value)
