# This an autogenerated file
# 
# Generated with DisplacementResponseStorage
from typing import Dict,Sequence,List
from dmt.entity import Entity
from dmt.blueprint import Blueprint
from .blueprints.displacementresponsestorage import DisplacementResponseStorageBlueprint
from sima.riflex.fileformatcode import FileFormatCode
from sima.riflex.nodereference import NodeReference
from sima.sima.moao import MOAO
from sima.sima.scriptablevalue import ScriptableValue

class DisplacementResponseStorage(MOAO):
    """
    Keyword arguments
    -----------------
    name : str
         (default "")
    description : str
         (default "")
    _id : str
         (default "")
    scriptableValues : List[ScriptableValue]
    storageStep : int
         Code for storage of nodal displacements. Storage for every <storage step> given.(default 1)
    format : FileFormatCode
         Format code for additional output of nodal displacement time series
    nodes : List[NodeReference]
         Specification of nodes for displacement storage
    """

    def __init__(self , name:str="", description:str="", _id:str="", storageStep:int=1, format:FileFormatCode=FileFormatCode.BINARY_OUTPUT_ONLY, **kwargs):
        super().__init__(**kwargs)
        self.__name = name
        self.__description = description
        self.___id = _id
        self.__scriptableValues = list()
        self.__storageStep = storageStep
        self.__format = format
        self.__nodes = list()
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return DisplacementResponseStorageBlueprint()


    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = str(value)

    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = str(value)

    @property
    def _id(self) -> str:
        """"""
        return self.___id

    @_id.setter
    def _id(self, value: str):
        """Set _id"""
        self.___id = str(value)

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def storageStep(self) -> int:
        """Code for storage of nodal displacements. Storage for every <storage step> given."""
        return self.__storageStep

    @storageStep.setter
    def storageStep(self, value: int):
        """Set storageStep"""
        self.__storageStep = int(value)

    @property
    def format(self) -> FileFormatCode:
        """Format code for additional output of nodal displacement time series"""
        return self.__format

    @format.setter
    def format(self, value: FileFormatCode):
        """Set format"""
        self.__format = value

    @property
    def nodes(self) -> List[NodeReference]:
        """Specification of nodes for displacement storage"""
        return self.__nodes

    @nodes.setter
    def nodes(self, value: List[NodeReference]):
        """Set nodes"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__nodes = value
