# 
# Generated with DoubleSymmetricCrossSectionBlueprint
from dmt.blueprint import Blueprint
from dmt.dimension import Dimension
from dmt.attribute import Attribute
from dmt.enum_attribute import EnumAttribute
from dmt.blueprint_attribute import BlueprintAttribute
from .crosssection import CrossSectionBlueprint
from .crsaxialfrictionmodel import CRSAxialFrictionModelBlueprint

class DoubleSymmetricCrossSectionBlueprint(CrossSectionBlueprint,CRSAxialFrictionModelBlueprint):
    """"""

    def __init__(self, name="DoubleSymmetricCrossSection", package_path="sima/riflex", description=""):
        super().__init__(name,package_path,description)
        self.attributes.append(Attribute("name","string","",default=""))
        self.attributes.append(Attribute("description","string","",default=""))
        self.attributes.append(Attribute("_id","string","",default=""))
        self.attributes.append(BlueprintAttribute("scriptableValues","sima/sima/ScriptableValue","",True,Dimension("size","")))
        self.attributes.append(Attribute("staticFriction","number","Static friction force corresponding to elongation",default=0.0))
        self.attributes.append(Attribute("staticElongation","number","Relative elongation",default=0.0))
        self.attributes.append(Attribute("dynamicFriction","number","Dynamic friction force corresponding to elongation",default=0.0))
        self.attributes.append(Attribute("dynamicElongation","number","Relative elongation",default=0.0))
        self.attributes.append(Attribute("axialFriction","boolean","Local axial friction model",default=False))
        self.attributes.append(Attribute("scfkSpecification","boolean","Scaling of Froude-Krylov term in Morison’s equation in normal direction",default=True))
        self.attributes.append(EnumAttribute("loadFormulation","sima/riflex/LoadFormulation",""))
        self.attributes.append(Attribute("hydrodynamicDiameter","number","Hydrodynamic diameter",default=0.0))
        self.attributes.append(Attribute("addedMassTanDir","number","Added mass in tangential direction",default=0.0))
        self.attributes.append(Attribute("addedMassNormDir","number","Added mass in normal direction",default=0.0))
        self.attributes.append(Attribute("dampingNormDir","number","Damping coefficients in normal direction",default=0.0))
        self.attributes.append(Attribute("cdx","number","Quadratic drag force coefficient per unit length in tangential direction",default=0.0))
        self.attributes.append(Attribute("cdy","number","Quadratic drag force coefficient per unit length in local y-direction",default=0.0))
        self.attributes.append(Attribute("cdz","number","Quadratic drag force coefficient per unit length local z-direction",default=0.0))
        self.attributes.append(Attribute("amx","number","Added mass per unit length in tangential direction",default=0.0))
        self.attributes.append(Attribute("amy","number","Added mass per unit length in local y-direction",default=0.0))
        self.attributes.append(Attribute("amz","number","Added mass per unit length in local z-direction",default=0.0))
        self.attributes.append(Attribute("addedMass","number","Added mass per unit length for torsional rotation",default=0.0))
        self.attributes.append(Attribute("cdlx","number","Linear drag force coefficient per unit length in tangential direction",default=0.0))
        self.attributes.append(Attribute("cdly","number","Linear drag force coefficient per unit length in local y-direction",default=0.0))
        self.attributes.append(Attribute("cdlz","number","Linear drag force coefficient per unit length in local z-direction",default=0.0))
        self.attributes.append(Attribute("scfk","number","Scaling factor for Froude-Krylov term in Morison’s equation in normal direction",default=1.0))
        self.attributes.append(EnumAttribute("scfkt","sima/riflex/TangentialFroudeKrylovScaling","Scale for Froude-Krylov term in Morison’s equation in tangential direction"))
        self.attributes.append(EnumAttribute("hydrodynamicInputCode","sima/riflex/HydrodynamicInputCode","Hydrodynamic input code"))
        self.attributes.append(Attribute("cdt","number","Quadratic drag coefficient in tangential direction.",default=0.0))
        self.attributes.append(Attribute("cdn","number","Quadratic drag coefficient in normal direction.",default=0.0))
        self.attributes.append(Attribute("cdnz","number","Quadratic drag coefficient in normal direction.",default=0.0))
        self.attributes.append(Attribute("massDampingSpecification","boolean","Mass proportional Rayleigh damping",default=False))
        self.attributes.append(Attribute("stiffnessDampingSpecification","boolean","Stiffness proportional Rayleigh damping",default=False))
        self.attributes.append(Attribute("axialDampingSpecification","boolean","Local axial damping model",default=False))
        self.attributes.append(Attribute("cdax","number","Quadratic aerodynamic drag force coefficient per unit length in tangential direction",default=0.0))
        self.attributes.append(Attribute("cday","number","Quadratic aerodynamic drag force coefficient per unit length in normal direction",default=0.0))
        self.attributes.append(Attribute("cdaz","number","Quadratic aerodynamic drag force coefficient per unit length in z direction",default=0.0))
        self.attributes.append(EnumAttribute("aerodynamicInputCode","sima/riflex/AerodynamicInputCode","Aerodynamic input code"))
        self.attributes.append(Attribute("aerodynamicDiameter","number","Aerodynamic diameter",default=0.0))
        self.attributes.append(Attribute("temperature","number","Temperature at which the specification applies",default=0.0))
        self.attributes.append(Attribute("pressureDependency","integer","Pressure dependency parameter related to bending moment",default=0))
        self.attributes.append(Attribute("axialStiffness","number","Axial stiffness",default=0.0))
        self.attributes.append(Attribute("tensionCapacity","number","Tension capacity",default=0.0))
        self.attributes.append(Attribute("maxCurvatureY","number","Maximum curvature around local y-axis",default=0.0))
        self.attributes.append(Attribute("maxCurvatureZ","number","Maximum curvature around local z-axis",default=0.0))
        self.attributes.append(BlueprintAttribute("massDamping","sima/riflex/CRSMassDamping","",True))
        self.attributes.append(BlueprintAttribute("stiffnessDamping","sima/riflex/CRSStiffnessDamping","",True))
        self.attributes.append(BlueprintAttribute("axialDamping","sima/riflex/CRSAxialDamping","",True))
        self.attributes.append(BlueprintAttribute("airfoil","sima/windturbine/Airfoil","",False))
        self.attributes.append(Attribute("chordLength","number","",default=0.0))
        self.attributes.append(Attribute("foilOriginY","number","Y-coordinate of foil origin",default=0.0))
        self.attributes.append(Attribute("foilOriginZ","number","Z-coordinate of foil origin",default=0.0))
        self.attributes.append(Attribute("foilInclination","number","Inclination of foil system in the local cross section (strength) system.",default=0.0))
        self.attributes.append(EnumAttribute("aerodynamicForceType","sima/riflex/AerodynamicForceType",""))
        self.attributes.append(Attribute("coupledBendingTorsion","boolean","Geometric stiffness coupling between bending and torsion",default=False))
        self.attributes.append(EnumAttribute("barBeam","sima/riflex/BarBeam","Cross section type"))
        self.attributes.append(BlueprintAttribute("massVolume","sima/riflex/DoubleSymmetricCrossSectionMassVolume","",True))
        self.attributes.append(EnumAttribute("axialStiffnessInput","sima/riflex/AxialStiffness","Axial stiffness input specification"))
        self.attributes.append(EnumAttribute("bendingStiffnessInput","sima/riflex/BendingStiffness","Bending stiffness input specification"))
        self.attributes.append(EnumAttribute("torsionStiffnessInput","sima/riflex/TorsionStiffness","Torsion stiffness input specification"))
        self.attributes.append(BlueprintAttribute("axialStiffnessCharacteristics","sima/riflex/AxialStiffnessItem","",True,Dimension("size","")))
        self.attributes.append(BlueprintAttribute("bendingStiffnessCharacteristics","sima/riflex/BendingStiffnessYZ_Item","",True,Dimension("size","")))
        self.attributes.append(BlueprintAttribute("torsionStiffnessCharacteristics","sima/riflex/TorsionStiffnessItem","",True,Dimension("size","")))
        self.attributes.append(Attribute("negativeTorsionStiffness","number","Torsion stiffness for negative twist.",default=0.0))
        self.attributes.append(Attribute("positiveTorsionStiffness","number","Torsion stiffness for positive twist.",default=0.0))
        self.attributes.append(Attribute("submerged","boolean","Use formulation for partly submerged cross-section",default=False))
        self.attributes.append(Attribute("bendingStiffnessY","number","Bending stiffness around y-axis",default=0.0))
        self.attributes.append(Attribute("bendingStiffnessZ","number","Bending stiffness around z-axis",default=0.0))
        self.attributes.append(Attribute("shearStiffnessZ","number","Shear stiffness in Z-direction",default=0.0))
        self.attributes.append(Attribute("shearStiffnessY","number","Shear stiffness in Y-direction",default=0.0))
        self.attributes.append(EnumAttribute("hydrodynamicRadiationInputCode","sima/riflex/HydrodynamicRadiationInputCode","Code for input of simplified radiation force coefficients"))