# This an autogenerated file
# 
# Generated with QuadraticCurrentCoefficient
from typing import Dict,Sequence,List
from dmt.entity import Entity
from dmt.blueprint import Blueprint
from .blueprints.quadraticcurrentcoefficient import QuadraticCurrentCoefficientBlueprint
from sima.hydro.coefficienttype import CoefficientType
from sima.hydro.directionsymmetry import DirectionSymmetry
from sima.hydro.quadraticcurrentcoefficientitem import QuadraticCurrentCoefficientItem
from sima.sima.moao import MOAO
from sima.sima.scriptablevalue import ScriptableValue

class QuadraticCurrentCoefficient(MOAO):
    """
    Keyword arguments
    -----------------
    name : str
         (default "")
    description : str
         (default "")
    _id : str
         (default "")
    scriptableValues : List[ScriptableValue]
    symmetry : DirectionSymmetry
    items : List[QuadraticCurrentCoefficientItem]
    _type : CoefficientType
         Current coefficient type
    fileName : str
         Text file containing the current coefficients. The force coefficents in the file must be specified in [kN/(m/s)] for translational degrees of freedom and [kN.s] for rotational degrees of freedom.(default "")
    """

    def __init__(self , name:str="", description:str="", _id:str="", symmetry:DirectionSymmetry=DirectionSymmetry.NO_SYMMETRY, _type:CoefficientType=CoefficientType.CLASSIC, fileName:str="", **kwargs):
        super().__init__(**kwargs)
        self.__name = name
        self.__description = description
        self.___id = _id
        self.__scriptableValues = list()
        self.__symmetry = symmetry
        self.__items = list()
        self.___type = _type
        self.__fileName = fileName
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return QuadraticCurrentCoefficientBlueprint()


    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = str(value)

    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = str(value)

    @property
    def _id(self) -> str:
        """"""
        return self.___id

    @_id.setter
    def _id(self, value: str):
        """Set _id"""
        self.___id = str(value)

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def symmetry(self) -> DirectionSymmetry:
        """"""
        return self.__symmetry

    @symmetry.setter
    def symmetry(self, value: DirectionSymmetry):
        """Set symmetry"""
        self.__symmetry = value

    @property
    def items(self) -> List[QuadraticCurrentCoefficientItem]:
        """"""
        return self.__items

    @items.setter
    def items(self, value: List[QuadraticCurrentCoefficientItem]):
        """Set items"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__items = value

    @property
    def _type(self) -> CoefficientType:
        """Current coefficient type"""
        return self.___type

    @_type.setter
    def _type(self, value: CoefficientType):
        """Set _type"""
        self.___type = value

    @property
    def fileName(self) -> str:
        """Text file containing the current coefficients. The force coefficents in the file must be specified in [kN/(m/s)] for translational degrees of freedom and [kN.s] for rotational degrees of freedom."""
        return self.__fileName

    @fileName.setter
    def fileName(self, value: str):
        """Set fileName"""
        self.__fileName = str(value)
