# This an autogenerated file
# 
# Generated with HLASignalPlot
from typing import Dict,Sequence,List
from dmt.entity import Entity
from dmt.blueprint import Blueprint
from .blueprints.hlasignalplot import HLASignalPlotBlueprint
from sima.hla.hlasignal import HLASignal
from sima.post.figuretemplate import FigureTemplate
from sima.post.traceconfiguration import TraceConfiguration
from sima.sima.moao import MOAO
from sima.sima.scriptablevalue import ScriptableValue

class HLASignalPlot(MOAO):
    """
    Keyword arguments
    -----------------
    name : str
         (default "")
    description : str
         (default "")
    _id : str
         (default "")
    scriptableValues : List[ScriptableValue]
    figureTemplate : FigureTemplate
    traces : List[TraceConfiguration]
    fixed : bool
         (default False)
    title : str
         (default "")
    xLabel : str
         (default "")
    yLabel : str
         (default "")
    selectAll : bool
         Will export all signals as plot(default False)
    signals : List[HLASignal]
    timeWindow : float
         Maximum size of time window when displaying plot.(default 60.0)
    """

    def __init__(self , name:str="", description:str="", _id:str="", fixed:bool=False, title:str="", xLabel:str="", yLabel:str="", selectAll:bool=False, timeWindow:float=60.0, **kwargs):
        super().__init__(**kwargs)
        self.__name = name
        self.__description = description
        self.___id = _id
        self.__scriptableValues = list()
        self.__figureTemplate = FigureTemplate()
        self.__traces = list()
        self.__fixed = fixed
        self.__title = title
        self.__xLabel = xLabel
        self.__yLabel = yLabel
        self.__selectAll = selectAll
        self.__signals = list()
        self.__timeWindow = timeWindow
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return HLASignalPlotBlueprint()


    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = str(value)

    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = str(value)

    @property
    def _id(self) -> str:
        """"""
        return self.___id

    @_id.setter
    def _id(self, value: str):
        """Set _id"""
        self.___id = str(value)

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def figureTemplate(self) -> FigureTemplate:
        """"""
        return self.__figureTemplate

    @figureTemplate.setter
    def figureTemplate(self, value: FigureTemplate):
        """Set figureTemplate"""
        self.__figureTemplate = value

    @property
    def traces(self) -> List[TraceConfiguration]:
        """"""
        return self.__traces

    @traces.setter
    def traces(self, value: List[TraceConfiguration]):
        """Set traces"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__traces = value

    @property
    def fixed(self) -> bool:
        """"""
        return self.__fixed

    @fixed.setter
    def fixed(self, value: bool):
        """Set fixed"""
        self.__fixed = bool(value)

    @property
    def title(self) -> str:
        """"""
        return self.__title

    @title.setter
    def title(self, value: str):
        """Set title"""
        self.__title = str(value)

    @property
    def xLabel(self) -> str:
        """"""
        return self.__xLabel

    @xLabel.setter
    def xLabel(self, value: str):
        """Set xLabel"""
        self.__xLabel = str(value)

    @property
    def yLabel(self) -> str:
        """"""
        return self.__yLabel

    @yLabel.setter
    def yLabel(self, value: str):
        """Set yLabel"""
        self.__yLabel = str(value)

    @property
    def selectAll(self) -> bool:
        """Will export all signals as plot"""
        return self.__selectAll

    @selectAll.setter
    def selectAll(self, value: bool):
        """Set selectAll"""
        self.__selectAll = bool(value)

    @property
    def signals(self) -> List[HLASignal]:
        """"""
        return self.__signals

    @signals.setter
    def signals(self, value: List[HLASignal]):
        """Set signals"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__signals = value

    @property
    def timeWindow(self) -> float:
        """Maximum size of time window when displaying plot."""
        return self.__timeWindow

    @timeWindow.setter
    def timeWindow(self, value: float):
        """Set timeWindow"""
        self.__timeWindow = float(value)
