# This an autogenerated file
# 
# Generated with ExternalHLAFederate
from typing import Dict,Sequence,List
from dmt.entity import Entity
from dmt.blueprint import Blueprint
from .blueprints.externalhlafederate import ExternalHLAFederateBlueprint
from sima.hla.hlafederate import HLAFederate
from sima.hla.hlaobject import HLAObject
from sima.sima.scriptablevalue import ScriptableValue

class ExternalHLAFederate(HLAFederate):
    """
    Keyword arguments
    -----------------
    name : str
         (default "")
    description : str
         (default "")
    _id : str
         (default "")
    scriptableValues : List[ScriptableValue]
    timeStep : float
         (default 0.0)
    launch : bool
         Launch federate from provided class(default True)
    jarFile : str
         Path to jar file(default "")
    className : str
         Class name starting HLAFederate(default "")
    classPath : str
         Additional classpath needed by the external jar(default "")
    arguments : str
         Arguments passed to the class' main function(default "")
    libraryPath : str
         Sometimes needed when using native libraries. Corresponds to the -Djava.library.path argument(default "")
    showOutput : bool
         Show output from federate(default False)
    hlaObjects : List[HLAObject]
    """

    def __init__(self , name:str="", description:str="", _id:str="", timeStep:float=0.0, launch:bool=True, jarFile:str="", className:str="", classPath:str="", arguments:str="", libraryPath:str="", showOutput:bool=False, **kwargs):
        super().__init__(**kwargs)
        self.__name = name
        self.__description = description
        self.___id = _id
        self.__scriptableValues = list()
        self.__timeStep = timeStep
        self.__launch = launch
        self.__jarFile = jarFile
        self.__className = className
        self.__classPath = classPath
        self.__arguments = arguments
        self.__libraryPath = libraryPath
        self.__showOutput = showOutput
        self.__hlaObjects = list()
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return ExternalHLAFederateBlueprint()


    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = str(value)

    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = str(value)

    @property
    def _id(self) -> str:
        """"""
        return self.___id

    @_id.setter
    def _id(self, value: str):
        """Set _id"""
        self.___id = str(value)

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def timeStep(self) -> float:
        """"""
        return self.__timeStep

    @timeStep.setter
    def timeStep(self, value: float):
        """Set timeStep"""
        self.__timeStep = float(value)

    @property
    def launch(self) -> bool:
        """Launch federate from provided class"""
        return self.__launch

    @launch.setter
    def launch(self, value: bool):
        """Set launch"""
        self.__launch = bool(value)

    @property
    def jarFile(self) -> str:
        """Path to jar file"""
        return self.__jarFile

    @jarFile.setter
    def jarFile(self, value: str):
        """Set jarFile"""
        self.__jarFile = str(value)

    @property
    def className(self) -> str:
        """Class name starting HLAFederate"""
        return self.__className

    @className.setter
    def className(self, value: str):
        """Set className"""
        self.__className = str(value)

    @property
    def classPath(self) -> str:
        """Additional classpath needed by the external jar"""
        return self.__classPath

    @classPath.setter
    def classPath(self, value: str):
        """Set classPath"""
        self.__classPath = str(value)

    @property
    def arguments(self) -> str:
        """Arguments passed to the class' main function"""
        return self.__arguments

    @arguments.setter
    def arguments(self, value: str):
        """Set arguments"""
        self.__arguments = str(value)

    @property
    def libraryPath(self) -> str:
        """Sometimes needed when using native libraries. Corresponds to the -Djava.library.path argument"""
        return self.__libraryPath

    @libraryPath.setter
    def libraryPath(self, value: str):
        """Set libraryPath"""
        self.__libraryPath = str(value)

    @property
    def showOutput(self) -> bool:
        """Show output from federate"""
        return self.__showOutput

    @showOutput.setter
    def showOutput(self, value: bool):
        """Set showOutput"""
        self.__showOutput = bool(value)

    @property
    def hlaObjects(self) -> List[HLAObject]:
        """"""
        return self.__hlaObjects

    @hlaObjects.setter
    def hlaObjects(self, value: List[HLAObject]):
        """Set hlaObjects"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__hlaObjects = value
