# This an autogenerated file
# 
# Generated with DoubleModelSpectrum
from typing import Dict,Sequence,List
from dmt.entity import Entity
from dmt.blueprint import Blueprint
from .blueprints.doublemodelspectrum import DoubleModelSpectrumBlueprint
from sima.environment.wave import Wave
from sima.sima.scriptablevalue import ScriptableValue

class DoubleModelSpectrum(Wave):
    """
    Keyword arguments
    -----------------
    name : str
         (default "")
    description : str
         (default "")
    _id : str
         (default "")
    scriptableValues : List[ScriptableValue]
    significantWaveHeight : float
         Significant wave height(default 0.0)
    windDrivenRatio : float
         Ratio of wind driven sea to the total sea.(default 0.0)
    windPeakPeriod : float
         Peak period of the wind driven sea(default 0.0)
    swellPeakPeriod : float
         Peak period of the swell sea(default 0.0)
    gammaWind : float
         Gamma parameter for wind driven sea(default 3.3)
    gammaSwell : float
         Gamma parameter for swell sea(default 0.0)
    upperSlopeWind : float
         Slope of the upper frequency part of the wind driven part of wave spectrum(default 0.0)
    lowerSlopeWind : float
         Slope of the lower frequency part of the wind driven part of wave spectrum(default 0.0)
    upperSlopeSwell : float
         Slope of the upper frequency part of the swell part of wave spectrum(default 0.0)
    lowerSlopeSwell : float
         Slope of the lower frequency part of the swell part of wave spectrum(default 0.0)
    """

    def __init__(self , name:str="", description:str="", _id:str="", significantWaveHeight:float=0.0, windDrivenRatio:float=0.0, windPeakPeriod:float=0.0, swellPeakPeriod:float=0.0, gammaWind:float=3.3, gammaSwell:float=0.0, upperSlopeWind:float=0.0, lowerSlopeWind:float=0.0, upperSlopeSwell:float=0.0, lowerSlopeSwell:float=0.0, **kwargs):
        super().__init__(**kwargs)
        self.__name = name
        self.__description = description
        self.___id = _id
        self.__scriptableValues = list()
        self.__significantWaveHeight = significantWaveHeight
        self.__windDrivenRatio = windDrivenRatio
        self.__windPeakPeriod = windPeakPeriod
        self.__swellPeakPeriod = swellPeakPeriod
        self.__gammaWind = gammaWind
        self.__gammaSwell = gammaSwell
        self.__upperSlopeWind = upperSlopeWind
        self.__lowerSlopeWind = lowerSlopeWind
        self.__upperSlopeSwell = upperSlopeSwell
        self.__lowerSlopeSwell = lowerSlopeSwell
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return DoubleModelSpectrumBlueprint()


    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = str(value)

    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = str(value)

    @property
    def _id(self) -> str:
        """"""
        return self.___id

    @_id.setter
    def _id(self, value: str):
        """Set _id"""
        self.___id = str(value)

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def significantWaveHeight(self) -> float:
        """Significant wave height"""
        return self.__significantWaveHeight

    @significantWaveHeight.setter
    def significantWaveHeight(self, value: float):
        """Set significantWaveHeight"""
        self.__significantWaveHeight = float(value)

    @property
    def windDrivenRatio(self) -> float:
        """Ratio of wind driven sea to the total sea."""
        return self.__windDrivenRatio

    @windDrivenRatio.setter
    def windDrivenRatio(self, value: float):
        """Set windDrivenRatio"""
        self.__windDrivenRatio = float(value)

    @property
    def windPeakPeriod(self) -> float:
        """Peak period of the wind driven sea"""
        return self.__windPeakPeriod

    @windPeakPeriod.setter
    def windPeakPeriod(self, value: float):
        """Set windPeakPeriod"""
        self.__windPeakPeriod = float(value)

    @property
    def swellPeakPeriod(self) -> float:
        """Peak period of the swell sea"""
        return self.__swellPeakPeriod

    @swellPeakPeriod.setter
    def swellPeakPeriod(self, value: float):
        """Set swellPeakPeriod"""
        self.__swellPeakPeriod = float(value)

    @property
    def gammaWind(self) -> float:
        """Gamma parameter for wind driven sea"""
        return self.__gammaWind

    @gammaWind.setter
    def gammaWind(self, value: float):
        """Set gammaWind"""
        self.__gammaWind = float(value)

    @property
    def gammaSwell(self) -> float:
        """Gamma parameter for swell sea"""
        return self.__gammaSwell

    @gammaSwell.setter
    def gammaSwell(self, value: float):
        """Set gammaSwell"""
        self.__gammaSwell = float(value)

    @property
    def upperSlopeWind(self) -> float:
        """Slope of the upper frequency part of the wind driven part of wave spectrum"""
        return self.__upperSlopeWind

    @upperSlopeWind.setter
    def upperSlopeWind(self, value: float):
        """Set upperSlopeWind"""
        self.__upperSlopeWind = float(value)

    @property
    def lowerSlopeWind(self) -> float:
        """Slope of the lower frequency part of the wind driven part of wave spectrum"""
        return self.__lowerSlopeWind

    @lowerSlopeWind.setter
    def lowerSlopeWind(self, value: float):
        """Set lowerSlopeWind"""
        self.__lowerSlopeWind = float(value)

    @property
    def upperSlopeSwell(self) -> float:
        """Slope of the upper frequency part of the swell part of wave spectrum"""
        return self.__upperSlopeSwell

    @upperSlopeSwell.setter
    def upperSlopeSwell(self, value: float):
        """Set upperSlopeSwell"""
        self.__upperSlopeSwell = float(value)

    @property
    def lowerSlopeSwell(self) -> float:
        """Slope of the lower frequency part of the swell part of wave spectrum"""
        return self.__lowerSlopeSwell

    @lowerSlopeSwell.setter
    def lowerSlopeSwell(self, value: float):
        """Set lowerSlopeSwell"""
        self.__lowerSlopeSwell = float(value)
