# This an autogenerated file
# 
# Generated with StringArray
from dmt.entity import Entity
from dmt.blueprint import Blueprint
from .blueprints.stringarray import StringArrayBlueprint
from typing import Dict,Sequence,List
from marmo.containers.attribute import Attribute

class StringArray(Entity):
    """
    
    
    Keyword arguments
    -----------------
    name : str 
         (default "")
    description : str 
         (default "")
    attributes : List[Attribute] 
         
    value : Sequence[str] 
         
    """

    def __init__(self , name:str="", description:str="", **kwargs):
        self.__name = name
        self.__description = description
        self.__attributes = list()
        self.__value = list()
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return StringArrayBlueprint()


    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = str(value)

    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = str(value)

    @property
    def attributes(self) -> List[Attribute]:
        """"""
        return self.__attributes

    @attributes.setter
    def attributes(self, value: List[Attribute]):
        """Set attributes"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__attributes = value

    @property
    def value(self) -> Sequence[str]:
        """"""
        return self.__value

    @value.setter
    def value(self, value: Sequence[str]):
        """Set value"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__value = value
