Groundhog - A general-purpose geotechnical package
====================================================

[![PyPI version](https://badge.fury.io/py/groundhog.svg)](https://badge.fury.io/py/groundhog)

![alt text][logo]



[logo]: groundhog_banner_wide.png "Logo Title Text 2"

This Python package contains useful functionality for supporting automated geotechnical calculations.

Functionality for onshore and offshore geotechnical problems is included. This package is under constant
development so any request for additional functionality can always be submitted to the package author.

groundhog bundles a large amount of knowledge and provides it to end users through extensively documented functions. The aim of the package is as follows:

   - Improve correctness through unit-tested functions with parameter validation
   - Raise awareness on underlying test data and theories supporting engineering correlations and design formulae
   - Promoting development of open-source engineering software by the worldwide community of engineers

groundhog is developed using a set of 10 Golden rules which are reflected in the groundhog function
architecture and should also be followed by any contributors to the project.

For more information, consult the [documentation](http://snakesonabrain.com/docs/groundhog/index.html) or get started using the [tutorial notebooks](https://mybinder.org/v2/gh/snakesonabrain/groundhog/master). [![Binder](https://mybinder.org/badge_logo.svg)](https://mybinder.org/v2/gh/snakesonabrain/groundhog/master)

Installation requirements
-------------------------

groundhog is written for Python 3.7+. Downloading Anaconda3 is recommended for users not familiar with Python development.
Plotting functionality included in the package is built on plotly. The plotly package also needs to be installed and
is not included in the default Anaconda installation.

Installing groundhog is easily done with pip:`

```
pip install groundhog
```


Support groundhog
-------------------

You can support the development of groundhog by buying me a coffee

<a href="https://www.buymeacoffee.com/groundhog"><img src="https://img.buymeacoffee.com/button-api/?text=Buy me a coffee&emoji=&slug=groundhog&button_colour=FFDD00&font_colour=000000&font_family=Cookie&outline_colour=000000&coffee_colour=ffffff"></a>

License and copyright
-----------------------

groundhog is provided under a Creative Commons Attribution-NonCommercial-ShareAlike 4.0 International License. Please check the license terms below and in the license file.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

  Redistributions of source code must retain the above copyright notice, this
  list of conditions and the following disclaimer.

  Redistributions in binary form must reproduce the above copyright notice, this
  list of conditions and the following disclaimer in the documentation and/or
  other materials provided with the distribution.

  Neither the name of the software nor the names of its
  contributors may be used to endorse or promote products derived from
  this software without specific prior written permission.
  
<a rel="license" href="http://creativecommons.org/licenses/by-nc-sa/4.0/"><img alt="Creative Commons License" style="border-width:0" src="https://i.creativecommons.org/l/by-nc-sa/4.0/88x31.png" /></a><br />This work is licensed under a <a rel="license" href="http://creativecommons.org/licenses/by-nc-sa/4.0/">Creative Commons Attribution-NonCommercial-ShareAlike 4.0 International License</a>.

Copyright (c) 2017-2020, Bruno Stuyts
All rights reserved.

Disclaimer
-------------

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.