# coding: utf-8


"""
IGNORE:
    Nutanix Networking Versioned APIs

    Manage networking configuration on Nutanix clusters, including AHV and advanced networking.  # noqa: E501

    OpenAPI spec version: 4.0.1-alpha-1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ntnx_networking_py_client.api_client import ApiClient


class VpcApi(object):
    """IGNORE:
    NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    IGNORE
    """ # noqa: E501

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_vpc(self, body, **kwargs):  # noqa: E501
        """Create a VPC.
        Create a VPC.

        >>> response = api.create_vpc(body)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_vpc(body, async_req=True)
        >>> result = thread.get()

        :param networking.v4.config.Vpc body: Request schema to create the VPC. (required)
        :param bool async_req:
        :return: networking.v4.config.TaskReferenceApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_vpc_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_vpc_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_vpc_with_http_info(self, body, **kwargs):  # noqa: E501
        """Create a VPC.
        Create a VPC.

        >>> response = api.create_vpc(body)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_vpc_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param networking.v4.config.Vpc body: Request schema to create the VPC. (required)
        :param bool async_req:
        :return: networking.v4.config.TaskReferenceApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_vpc" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_vpc`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/networking/v4.0.a1/config/vpcs', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='networking.v4.config.TaskReferenceApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_vpc(self, extId, **kwargs):  # noqa: E501
        """Delete the specified VPC.
        Delete the specified VPC.

        >>> response = api.delete_vpc(extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_vpc(extId, async_req=True)
        >>> result = thread.get()

        :param str extId: The UUID of the VPC. (required)
        :param bool async_req:
        :return: networking.v4.config.TaskReferenceApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_vpc_with_http_info(extId, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_vpc_with_http_info(extId, **kwargs)  # noqa: E501
            return data

    def delete_vpc_with_http_info(self, extId, **kwargs):  # noqa: E501
        """Delete the specified VPC.
        Delete the specified VPC.

        >>> response = api.delete_vpc(extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_vpc_with_http_info(extId, async_req=True)
        >>> result = thread.get()

        :param str extId: The UUID of the VPC. (required)
        :param bool async_req:
        :return: networking.v4.config.TaskReferenceApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['extId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_vpc" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'extId' is set
        if ('extId' not in params or
                params['extId'] is None):
            raise ValueError("Missing the required parameter `extId` when calling `delete_vpc`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'extId' in params:
            path_params['extId'] = params['extId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/networking/v4.0.a1/config/vpcs/{extId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='networking.v4.config.TaskReferenceApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_vpc(self, extId, **kwargs):  # noqa: E501
        """Get the VPC with the specified UUID.
        Get the VPC for the specified UUID.

        >>> response = api.get_vpc(extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_vpc(extId, async_req=True)
        >>> result = thread.get()

        :param str extId: The UUID of the VPC. (required)
        :param bool async_req:
        :return: networking.v4.config.VpcApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_vpc_with_http_info(extId, **kwargs)  # noqa: E501
        else:
            (data) = self.get_vpc_with_http_info(extId, **kwargs)  # noqa: E501
            return data

    def get_vpc_with_http_info(self, extId, **kwargs):  # noqa: E501
        """Get the VPC with the specified UUID.
        Get the VPC for the specified UUID.

        >>> response = api.get_vpc(extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_vpc_with_http_info(extId, async_req=True)
        >>> result = thread.get()

        :param str extId: The UUID of the VPC. (required)
        :param bool async_req:
        :return: networking.v4.config.VpcApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['extId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_vpc" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'extId' is set
        if ('extId' not in params or
                params['extId'] is None):
            raise ValueError("Missing the required parameter `extId` when calling `get_vpc`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'extId' in params:
            path_params['extId'] = params['extId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/networking/v4.0.a1/config/vpcs/{extId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='networking.v4.config.VpcApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_vpcs(self, **kwargs):  # noqa: E501
        """Get the list of existing VPCs.
        Get the list of existing VPCs.

        >>> response = api.list_vpcs((optional) _page, (optional) _limit, (optional) _filter, (optional) _orderby)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_vpcs(async_req=True)
        >>> result = thread.get()

        :param int _page: A URL query parameter that specifies the page number of the result set.  Must be a positive integer between 0 and the maximum number of pages that are available for that resource. Any number out of this range will lead to no results being returned.

        :param int _limit: A URL query parameter that specifies the total number of records returned in the result set.  Must be a positive integer between 0 and 100. Any number out of this range will lead to a validation error. If the limit is not provided a default value of 50 records will be returned in the result set.

        :param str _filter: A URL query parameter that allows clients to filter a collection of resources. The expression specified with $filter is evaluated for each resource in the collection, and only items where the expression evaluates to true are included in the response. Expression specified with the $filter must conform to the OData V4.01 URL conventions.
        The filter can be applied on the following fields:
        
        - name
        
        :param str _orderby: A URL query parameter that allows clients to specify the sort criteria for the returned list of objects. Resources can be sorted in ascending order using asc or descending order using desc. If asc or desc are not specified the resources will be sorted in ascending order by default. For example, 'orderby=templateName desc' would get all templates sorted by templateName in desc order.
        The orderby can be applied to the following fields:
        
        - name
        
        :param bool async_req:
        :return: networking.v4.config.VpcListApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_vpcs_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_vpcs_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_vpcs_with_http_info(self, **kwargs):  # noqa: E501
        """Get the list of existing VPCs.
        Get the list of existing VPCs.

        >>> response = api.list_vpcs((optional) _page, (optional) _limit, (optional) _filter, (optional) _orderby)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_vpcs_with_http_info(async_req=True)
        >>> result = thread.get()

        :param int _page: A URL query parameter that specifies the page number of the result set.  Must be a positive integer between 0 and the maximum number of pages that are available for that resource. Any number out of this range will lead to no results being returned.

        :param int _limit: A URL query parameter that specifies the total number of records returned in the result set.  Must be a positive integer between 0 and 100. Any number out of this range will lead to a validation error. If the limit is not provided a default value of 50 records will be returned in the result set.

        :param str _filter: A URL query parameter that allows clients to filter a collection of resources. The expression specified with $filter is evaluated for each resource in the collection, and only items where the expression evaluates to true are included in the response. Expression specified with the $filter must conform to the OData V4.01 URL conventions.
        The filter can be applied on the following fields:
        
        - name
        
        :param str _orderby: A URL query parameter that allows clients to specify the sort criteria for the returned list of objects. Resources can be sorted in ascending order using asc or descending order using desc. If asc or desc are not specified the resources will be sorted in ascending order by default. For example, 'orderby=templateName desc' would get all templates sorted by templateName in desc order.
        The orderby can be applied to the following fields:
        
        - name
        
        :param bool async_req:
        :return: networking.v4.config.VpcListApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['_page', '_limit', '_filter', '_orderby']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_vpcs" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if '_page' in params:
            query_params.append(('$page', params['_page']))  # noqa: E501
        if '_limit' in params:
            query_params.append(('$limit', params['_limit']))  # noqa: E501
        if '_filter' in params:
            query_params.append(('$filter', params['_filter']))  # noqa: E501
        if '_orderby' in params:
            query_params.append(('$orderby', params['_orderby']))  # noqa: E501

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/networking/v4.0.a1/config/vpcs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='networking.v4.config.VpcListApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_vpc(self, body, extId, **kwargs):  # noqa: E501
        """Update the specified VPC.
        Update the specified VPC.

        >>> response = api.update_vpc(body, extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_vpc(body, extId, async_req=True)
        >>> result = thread.get()

        :param networking.v4.config.Vpc body: Request schema to update the specified VPC. (required)
        :param str extId: The UUID of the VPC. (required)
        :param bool async_req:
        :return: networking.v4.config.TaskReferenceApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_vpc_with_http_info(body, extId, **kwargs)  # noqa: E501
        else:
            (data) = self.update_vpc_with_http_info(body, extId, **kwargs)  # noqa: E501
            return data

    def update_vpc_with_http_info(self, body, extId, **kwargs):  # noqa: E501
        """Update the specified VPC.
        Update the specified VPC.

        >>> response = api.update_vpc(body, extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_vpc_with_http_info(body, extId, async_req=True)
        >>> result = thread.get()

        :param networking.v4.config.Vpc body: Request schema to update the specified VPC. (required)
        :param str extId: The UUID of the VPC. (required)
        :param bool async_req:
        :return: networking.v4.config.TaskReferenceApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'extId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_vpc" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_vpc`")  # noqa: E501
        # verify the required parameter 'extId' is set
        if ('extId' not in params or
                params['extId'] is None):
            raise ValueError("Missing the required parameter `extId` when calling `update_vpc`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'extId' in params:
            path_params['extId'] = params['extId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/networking/v4.0.a1/config/vpcs/{extId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='networking.v4.config.TaskReferenceApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
