# coding: utf-8


"""
IGNORE:
    Nutanix Networking Versioned APIs

    Manage networking configuration on Nutanix clusters, including AHV and advanced networking.  # noqa: E501

    OpenAPI spec version: 4.0.1-alpha-1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ntnx_networking_py_client.api_client import ApiClient


class NetworkControllerApi(object):
    """IGNORE:
    NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    IGNORE
    """ # noqa: E501

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_network_controller(self, body, **kwargs):  # noqa: E501
        """Create a network controller
        Create a network controller

        >>> response = api.create_network_controller(body)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_network_controller(body, async_req=True)
        >>> result = thread.get()

        :param networking.v4.config.NetworkController body: Network controller to create (required)
        :param bool async_req:
        :return: networking.v4.config.TaskReferenceApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_network_controller_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_network_controller_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_network_controller_with_http_info(self, body, **kwargs):  # noqa: E501
        """Create a network controller
        Create a network controller

        >>> response = api.create_network_controller(body)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_network_controller_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param networking.v4.config.NetworkController body: Network controller to create (required)
        :param bool async_req:
        :return: networking.v4.config.TaskReferenceApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_network_controller" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_network_controller`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/networking/v4.0.a1/config/controllers', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='networking.v4.config.TaskReferenceApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_network_controller(self, extId, **kwargs):  # noqa: E501
        """Delete a network controller
        Delete a network controller

        >>> response = api.delete_network_controller(extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_network_controller(extId, async_req=True)
        >>> result = thread.get()

        :param str extId: The UUID of the network controller (required)
        :param bool async_req:
        :return: networking.v4.config.TaskReferenceApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_network_controller_with_http_info(extId, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_network_controller_with_http_info(extId, **kwargs)  # noqa: E501
            return data

    def delete_network_controller_with_http_info(self, extId, **kwargs):  # noqa: E501
        """Delete a network controller
        Delete a network controller

        >>> response = api.delete_network_controller(extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_network_controller_with_http_info(extId, async_req=True)
        >>> result = thread.get()

        :param str extId: The UUID of the network controller (required)
        :param bool async_req:
        :return: networking.v4.config.TaskReferenceApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['extId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_network_controller" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'extId' is set
        if ('extId' not in params or
                params['extId'] is None):
            raise ValueError("Missing the required parameter `extId` when calling `delete_network_controller`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'extId' in params:
            path_params['extId'] = params['extId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/networking/v4.0.a1/config/controllers/{extId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='networking.v4.config.TaskReferenceApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_network_controller(self, extId, **kwargs):  # noqa: E501
        """Get the network controller with the specified UUID
        Get the network controller with the specified UUID

        >>> response = api.get_network_controller(extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_network_controller(extId, async_req=True)
        >>> result = thread.get()

        :param str extId: The UUID of the network controller (required)
        :param bool async_req:
        :return: networking.v4.config.NetworkControllerApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_network_controller_with_http_info(extId, **kwargs)  # noqa: E501
        else:
            (data) = self.get_network_controller_with_http_info(extId, **kwargs)  # noqa: E501
            return data

    def get_network_controller_with_http_info(self, extId, **kwargs):  # noqa: E501
        """Get the network controller with the specified UUID
        Get the network controller with the specified UUID

        >>> response = api.get_network_controller(extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_network_controller_with_http_info(extId, async_req=True)
        >>> result = thread.get()

        :param str extId: The UUID of the network controller (required)
        :param bool async_req:
        :return: networking.v4.config.NetworkControllerApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['extId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_network_controller" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'extId' is set
        if ('extId' not in params or
                params['extId'] is None):
            raise ValueError("Missing the required parameter `extId` when calling `get_network_controller`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'extId' in params:
            path_params['extId'] = params['extId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/networking/v4.0.a1/config/controllers/{extId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='networking.v4.config.NetworkControllerApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_network_controllers(self, **kwargs):  # noqa: E501
        """Gets the list of existing network controllers
        Gets the list of existing network controllers

        >>> response = api.list_network_controllers((optional) _page, (optional) _limit)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_network_controllers(async_req=True)
        >>> result = thread.get()

        :param int _page: A URL query parameter that specifies the page number of the result set.  Must be a positive integer between 0 and the maximum number of pages that are available for that resource. Any number out of this range will lead to no results being returned.

        :param int _limit: A URL query parameter that specifies the total number of records returned in the result set.  Must be a positive integer between 0 and 100. Any number out of this range will lead to a validation error. If the limit is not provided a default value of 50 records will be returned in the result set.

        :param bool async_req:
        :return: networking.v4.config.NetworkControllerListApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_network_controllers_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_network_controllers_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_network_controllers_with_http_info(self, **kwargs):  # noqa: E501
        """Gets the list of existing network controllers
        Gets the list of existing network controllers

        >>> response = api.list_network_controllers((optional) _page, (optional) _limit)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_network_controllers_with_http_info(async_req=True)
        >>> result = thread.get()

        :param int _page: A URL query parameter that specifies the page number of the result set.  Must be a positive integer between 0 and the maximum number of pages that are available for that resource. Any number out of this range will lead to no results being returned.

        :param int _limit: A URL query parameter that specifies the total number of records returned in the result set.  Must be a positive integer between 0 and 100. Any number out of this range will lead to a validation error. If the limit is not provided a default value of 50 records will be returned in the result set.

        :param bool async_req:
        :return: networking.v4.config.NetworkControllerListApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['_page', '_limit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_network_controllers" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if '_page' in params:
            query_params.append(('$page', params['_page']))  # noqa: E501
        if '_limit' in params:
            query_params.append(('$limit', params['_limit']))  # noqa: E501

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/networking/v4.0.a1/config/controllers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='networking.v4.config.NetworkControllerListApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
