# coding: utf-8


"""
IGNORE:
    Nutanix Networking Versioned APIs

    Manage networking configuration on Nutanix clusters, including AHV and advanced networking.  # noqa: E501

    OpenAPI spec version: 4.0.1-alpha-1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
import pprint
import json
import ast
import re  # noqa: F401

import six
from ntnx_networking_py_client.Ntnx.common.v1.config.IPAddress import IPAddress  # noqa: F401,E501
from ntnx_networking_py_client.Ntnx.common.v1.config.Metadata import Metadata  # noqa: F401,E501
from ntnx_networking_py_client.Ntnx.networking.v4.config.DhcpOptions import DhcpOptions  # noqa: F401,E501
from ntnx_networking_py_client.Ntnx.networking.v4.config.IPConfig import IPConfig  # noqa: F401,E501
from ntnx_networking_py_client.Ntnx.networking.v4.config.NetworkingBaseModel import NetworkingBaseModel  # noqa: F401,E501
from ntnx_networking_py_client.Ntnx.networking.v4.config.SubnetType import SubnetType  # noqa: F401,E501

"""
IGNORE:
NOTE: This class is auto generated by the swagger code generator program.

Do not edit the class manually.
IGNORE
"""


class Subnet(NetworkingBaseModel):
    """Subnet - a model defined in Swagger"""
    """
    IGNORE:
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    IGNORE
    """ # noqa: E501
    swagger_types = {
        'name': 'str',
        'description': 'str',
        'subnet_type': 'networking.v4.config.SubnetType',
        'network_id': 'int',
        'dhcp_options': 'networking.v4.config.DhcpOptions',
        'ip_config': 'list[networking.v4.config.IPConfig]',
        'cluster_reference': 'str',
        'virtual_switch_reference': 'str',
        'vpc_reference': 'str',
        'enable_nat': 'bool',
        'is_external': 'bool',
        'reserved_ip_addresses': 'list[common.v1.config.IPAddress]',
        'dynamic_ip_addresses': 'list[common.v1.config.IPAddress]',
        'network_function_chain_reference': 'str',
        'bridge_name': 'str',
        'advanced_networking': 'bool',
        'metadata': 'common.v1.config.Metadata',
        'ext_id': 'str',
        'links': 'list[common.v1.response.ApiLink]',
        'tenant_id': 'str',
        '_reserved': 'dict(str, object)',
        '_object_type': 'str',
        '_unknown_fields': 'dict(str, object)',
    }

    attribute_map = {
        'name': 'name',
        'description': 'description',
        'subnet_type': 'subnetType',
        'network_id': 'networkId',
        'dhcp_options': 'dhcpOptions',
        'ip_config': 'ipConfig',
        'cluster_reference': 'clusterReference',
        'virtual_switch_reference': 'virtualSwitchReference',
        'vpc_reference': 'vpcReference',
        'enable_nat': 'enableNat',
        'is_external': 'isExternal',
        'reserved_ip_addresses': 'reservedIpAddresses',
        'dynamic_ip_addresses': 'dynamicIpAddresses',
        'network_function_chain_reference': 'networkFunctionChainReference',
        'bridge_name': 'bridgeName',
        'advanced_networking': 'advancedNetworking',
        'metadata': 'metadata',
        'ext_id': 'extId',
        'links': 'links',
        'tenant_id': 'tenantId',
        '_reserved': '$reserved',
        '_object_type': '$objectType',
        '_unknown_fields': '$unknownFields',
    }



    def __init__(self, name=None, description=None, subnet_type=None, network_id=None, dhcp_options=None, ip_config=None, cluster_reference=None, virtual_switch_reference=None, vpc_reference=None, enable_nat=None, is_external=None, reserved_ip_addresses=None, dynamic_ip_addresses=None, network_function_chain_reference=None, bridge_name=None, advanced_networking=None, metadata=None, ext_id=None, links=None, tenant_id=None, *args, **kwargs):  # noqa: E501
        """Subnet - a model defined in Swagger
            
        """
        NetworkingBaseModel.__init__(self, metadata, ext_id, links, tenant_id, *args, **kwargs)
        self.__name = None
        self.__description = None
        self.__subnet_type = None
        self.__network_id = None
        self.__dhcp_options = None
        self.__ip_config = None
        self.__cluster_reference = None
        self.__virtual_switch_reference = None
        self.__vpc_reference = None
        self.__enable_nat = None
        self.__is_external = None
        self.__reserved_ip_addresses = None
        self.__dynamic_ip_addresses = None
        self.__network_function_chain_reference = None
        self.__bridge_name = None
        self.__advanced_networking = None
        self.discriminator = None
        self.__name = name
        if description is not None:
            self.__description = description
        self.__subnet_type = subnet_type
        if network_id is not None:
            self.__network_id = network_id
        if dhcp_options is not None:
            self.__dhcp_options = dhcp_options
        if ip_config is not None:
            self.__ip_config = ip_config
        if cluster_reference is not None:
            self.__cluster_reference = cluster_reference
        if virtual_switch_reference is not None:
            self.__virtual_switch_reference = virtual_switch_reference
        if vpc_reference is not None:
            self.__vpc_reference = vpc_reference
        if enable_nat is not None:
            self.__enable_nat = enable_nat
        if is_external is not None:
            self.__is_external = is_external
        if reserved_ip_addresses is not None:
            self.__reserved_ip_addresses = reserved_ip_addresses
        if dynamic_ip_addresses is not None:
            self.__dynamic_ip_addresses = dynamic_ip_addresses
        if network_function_chain_reference is not None:
            self.__network_function_chain_reference = network_function_chain_reference
        if bridge_name is not None:
            self.__bridge_name = bridge_name
        if advanced_networking is not None:
            self.__advanced_networking = advanced_networking

    def _initialize_object_type(self):
        return 'networking.v4.config.Subnet'

    def _initialize_fq_object_type(self):
        return 'networking.v4.r0.a1.config.Subnet'


    @property
    def name(self):
        """`{ str }`
            \nName of the subnet.
        """ # noqa: E501
        return self.__name

    @name.setter
    def name(self, name):
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501
        if name is not None and len(name) > 128:
            raise ValueError("Invalid value for `name`, length must be less than or equal to `128`")  # noqa: E501

        self.__name = name

    @property
    def description(self):
        """`{ str }`
            \nDescription of the subnet.
        """ # noqa: E501
        return self.__description

    @description.setter
    def description(self, description):
        if description is not None and len(description) > 1000:
            raise ValueError("Invalid value for `description`, length must be less than or equal to `1000`")  # noqa: E501

        self.__description = description

    @property
    def subnet_type(self):
        """`{ networking.v4.config.SubnetType }`
            
        """ # noqa: E501
        return self.__subnet_type

    @subnet_type.setter
    def subnet_type(self, subnet_type):
        if subnet_type is None:
            raise ValueError("Invalid value for `subnet_type`, must not be `None`")  # noqa: E501

        self.__subnet_type = subnet_type

    @property
    def network_id(self):
        """`{ int }`
            \nFor VLAN subnet, this field represents VLAN Id, valid range is from 0 to 4095; For overlay subnet, this field represents 24-bit VNI, this field is read-only.
        """ # noqa: E501
        return self.__network_id

    @network_id.setter
    def network_id(self, network_id):
        if network_id is not None and network_id > 16777215:  # noqa: E501
            raise ValueError("Invalid value for `network_id`, must be a value less than or equal to `16777215`")  # noqa: E501
        if network_id is not None and network_id < 0:  # noqa: E501
            raise ValueError("Invalid value for `network_id`, must be a value greater than or equal to `0`")  # noqa: E501

        self.__network_id = network_id

    @property
    def dhcp_options(self):
        """`{ networking.v4.config.DhcpOptions }`
            
        """ # noqa: E501
        return self.__dhcp_options

    @dhcp_options.setter
    def dhcp_options(self, dhcp_options):

        self.__dhcp_options = dhcp_options

    @property
    def ip_config(self):
        """`{ list[networking.v4.config.IPConfig] }`
            \nIP configuration for the subnet.
        """ # noqa: E501
        return self.__ip_config

    @ip_config.setter
    def ip_config(self, ip_config):

        self.__ip_config = ip_config

    @property
    def cluster_reference(self):
        """`{ str }`
            \nUUID of the cluster this subnet belongs to.
        """ # noqa: E501
        return self.__cluster_reference

    @cluster_reference.setter
    def cluster_reference(self, cluster_reference):
        if cluster_reference is not None and not re.search('^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$', cluster_reference):  # noqa: E501
            raise ValueError(r"Invalid value for `cluster_reference`, must be a follow pattern or equal to `/^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$/`")  # noqa: E501

        self.__cluster_reference = cluster_reference

    @property
    def virtual_switch_reference(self):
        """`{ str }`
            \nUUID of the virtual switch this subnet belongs to (type VLAN only).
        """ # noqa: E501
        return self.__virtual_switch_reference

    @virtual_switch_reference.setter
    def virtual_switch_reference(self, virtual_switch_reference):
        if virtual_switch_reference is not None and not re.search('^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$', virtual_switch_reference):  # noqa: E501
            raise ValueError(r"Invalid value for `virtual_switch_reference`, must be a follow pattern or equal to `/^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$/`")  # noqa: E501

        self.__virtual_switch_reference = virtual_switch_reference

    @property
    def vpc_reference(self):
        """`{ str }`
            \nUUID of Virtual Private Cloud this subnet belongs to (type Overlay only).
        """ # noqa: E501
        return self.__vpc_reference

    @vpc_reference.setter
    def vpc_reference(self, vpc_reference):
        if vpc_reference is not None and not re.search('^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$', vpc_reference):  # noqa: E501
            raise ValueError(r"Invalid value for `vpc_reference`, must be a follow pattern or equal to `/^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$/`")  # noqa: E501

        self.__vpc_reference = vpc_reference

    @property
    def enable_nat(self):
        """`{ bool }`
            \nIndicates whether NAT must be enabled for VPCs attached to the subnet. This is supported only for external subnets. NAT is enabled by default on external subnets.
        """ # noqa: E501
        return self.__enable_nat

    @enable_nat.setter
    def enable_nat(self, enable_nat):

        self.__enable_nat = enable_nat

    @property
    def is_external(self):
        """`{ bool }`
            \nIndicates whether the subnet is used for external connectivity.
        """ # noqa: E501
        return self.__is_external

    @is_external.setter
    def is_external(self, is_external):

        self.__is_external = is_external

    @property
    def reserved_ip_addresses(self):
        """`{ list[common.v1.config.IPAddress] }`
            \nList of IPs that are excluded while allocating IP addresses to VM ports.
        """ # noqa: E501
        return self.__reserved_ip_addresses

    @reserved_ip_addresses.setter
    def reserved_ip_addresses(self, reserved_ip_addresses):

        self.__reserved_ip_addresses = reserved_ip_addresses

    @property
    def dynamic_ip_addresses(self):
        """`{ list[common.v1.config.IPAddress] }`
            \nList of IPs, which are a subset from the reserved IP address list, that must be advertised to the SDN gateway.
        """ # noqa: E501
        return self.__dynamic_ip_addresses

    @dynamic_ip_addresses.setter
    def dynamic_ip_addresses(self, dynamic_ip_addresses):

        self.__dynamic_ip_addresses = dynamic_ip_addresses

    @property
    def network_function_chain_reference(self):
        """`{ str }`
            \nUUID of the Network function chain entity that this subnet belongs to (type VLAN only).
        """ # noqa: E501
        return self.__network_function_chain_reference

    @network_function_chain_reference.setter
    def network_function_chain_reference(self, network_function_chain_reference):
        if network_function_chain_reference is not None and not re.search('^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$', network_function_chain_reference):  # noqa: E501
            raise ValueError(r"Invalid value for `network_function_chain_reference`, must be a follow pattern or equal to `/^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$/`")  # noqa: E501

        self.__network_function_chain_reference = network_function_chain_reference

    @property
    def bridge_name(self):
        """`{ str }`
            \nName of the bridge on the host for the subnet.
        """ # noqa: E501
        return self.__bridge_name

    @bridge_name.setter
    def bridge_name(self, bridge_name):
        if bridge_name is not None and len(bridge_name) > 128:
            raise ValueError("Invalid value for `bridge_name`, length must be less than or equal to `128`")  # noqa: E501

        self.__bridge_name = bridge_name

    @property
    def advanced_networking(self):
        """`{ bool }`
            \nIndicates whether the subnet is used for advanced networking.
        """ # noqa: E501
        return self.__advanced_networking

    @advanced_networking.setter
    def advanced_networking(self, advanced_networking):

        self.__advanced_networking = advanced_networking

    def _to_dict(self, sanitize):
        """
        Returns the model properties as a dict. Omits None properties based on the provided "sanitize" parameter.
        :param bool sanitize
        """

        result = {}

        for attr, attr_type in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x._to_dict(sanitize) if hasattr(x, "_to_dict") else x,
                    value
                ))
            elif hasattr(value, "_to_dict"):
                result[attr] = value._to_dict(sanitize)
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1]._to_dict(sanitize))
                    if hasattr(item[1], "_to_dict") else item,
                    six.iteritems(value)
                ))
            else:
                if sanitize:
                    if value is not None:
                        result[attr] = value
                else:
                    result[attr] = value
        if issubclass(Subnet, dict):
            for key, value in six.iteritems(self):
                result[key] = value

        return result

    def to_dict(self):
        """Returns the model properties as a dict"""
        return self._to_dict(False)

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self._to_dict(True))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Subnet):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

