# coding: utf-8


"""
IGNORE:
    Nutanix Networking Versioned APIs

    Manage networking configuration on Nutanix clusters, including AHV and advanced networking.  # noqa: E501

    OpenAPI spec version: 4.0.1-alpha-1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
import pprint
import json
import ast
import re  # noqa: F401

import six
from ntnx_networking_py_client.Ntnx.common.v1.config.Metadata import Metadata  # noqa: F401,E501
from ntnx_networking_py_client.Ntnx.networking.v4.config.NetworkingBaseModel import NetworkingBaseModel  # noqa: F401,E501
from ntnx_networking_py_client.Ntnx.networking.v4.config.RoutingPolicyRule import RoutingPolicyRule  # noqa: F401,E501

"""
IGNORE:
NOTE: This class is auto generated by the swagger code generator program.

Do not edit the class manually.
IGNORE
"""


class RoutingPolicy(NetworkingBaseModel):
    """RoutingPolicy - a model defined in Swagger"""
    """
    IGNORE:
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    IGNORE
    """ # noqa: E501
    swagger_types = {
        'name': 'str',
        'description': 'str',
        'priority': 'int',
        'policies': 'list[networking.v4.config.RoutingPolicyRule]',
        'vpc_ext_id': 'str',
        'metadata': 'common.v1.config.Metadata',
        'ext_id': 'str',
        'links': 'list[common.v1.response.ApiLink]',
        'tenant_id': 'str',
        '_reserved': 'dict(str, object)',
        '_object_type': 'str',
        '_unknown_fields': 'dict(str, object)',
    }

    attribute_map = {
        'name': 'name',
        'description': 'description',
        'priority': 'priority',
        'policies': 'policies',
        'vpc_ext_id': 'vpcExtId',
        'metadata': 'metadata',
        'ext_id': 'extId',
        'links': 'links',
        'tenant_id': 'tenantId',
        '_reserved': '$reserved',
        '_object_type': '$objectType',
        '_unknown_fields': '$unknownFields',
    }



    def __init__(self, name=None, description=None, priority=None, policies=None, vpc_ext_id=None, metadata=None, ext_id=None, links=None, tenant_id=None, *args, **kwargs):  # noqa: E501
        """RoutingPolicy - a model defined in Swagger
            \nSchema to configure a routing policy.
        """
        NetworkingBaseModel.__init__(self, metadata, ext_id, links, tenant_id, *args, **kwargs)
        self.__name = None
        self.__description = None
        self.__priority = None
        self.__policies = None
        self.__vpc_ext_id = None
        self.discriminator = None
        self.__name = name
        if description is not None:
            self.__description = description
        self.__priority = priority
        self.__policies = policies
        self.__vpc_ext_id = vpc_ext_id

    def _initialize_object_type(self):
        return 'networking.v4.config.RoutingPolicy'

    def _initialize_fq_object_type(self):
        return 'networking.v4.r0.a1.config.RoutingPolicy'


    @property
    def name(self):
        """`{ str }`
            \nName of the routing policy.
        """ # noqa: E501
        return self.__name

    @name.setter
    def name(self, name):
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501
        if name is not None and len(name) > 128:
            raise ValueError("Invalid value for `name`, length must be less than or equal to `128`")  # noqa: E501

        self.__name = name

    @property
    def description(self):
        """`{ str }`
            \nA description of the routing policy.
        """ # noqa: E501
        return self.__description

    @description.setter
    def description(self, description):
        if description is not None and len(description) > 1000:
            raise ValueError("Invalid value for `description`, length must be less than or equal to `1000`")  # noqa: E501

        self.__description = description

    @property
    def priority(self):
        """`{ int }`
            \nPriority of the routing policy.
        """ # noqa: E501
        return self.__priority

    @priority.setter
    def priority(self, priority):
        if priority is None:
            raise ValueError("Invalid value for `priority`, must not be `None`")  # noqa: E501
        if priority is not None and priority > 1000:  # noqa: E501
            raise ValueError("Invalid value for `priority`, must be a value less than or equal to `1000`")  # noqa: E501
        if priority is not None and priority < 1:  # noqa: E501
            raise ValueError("Invalid value for `priority`, must be a value greater than or equal to `1`")  # noqa: E501

        self.__priority = priority

    @property
    def policies(self):
        """`{ list[networking.v4.config.RoutingPolicyRule] }`
            
        """ # noqa: E501
        return self.__policies

    @policies.setter
    def policies(self, policies):
        if policies is None:
            raise ValueError("Invalid value for `policies`, must not be `None`")  # noqa: E501

        self.__policies = policies

    @property
    def vpc_ext_id(self):
        """`{ str }`
            \nExtId of the VPC extId to which the routing policy belongs.
        """ # noqa: E501
        return self.__vpc_ext_id

    @vpc_ext_id.setter
    def vpc_ext_id(self, vpc_ext_id):
        if vpc_ext_id is None:
            raise ValueError("Invalid value for `vpc_ext_id`, must not be `None`")  # noqa: E501
        if vpc_ext_id is not None and not re.search('^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$', vpc_ext_id):  # noqa: E501
            raise ValueError(r"Invalid value for `vpc_ext_id`, must be a follow pattern or equal to `/^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$/`")  # noqa: E501

        self.__vpc_ext_id = vpc_ext_id

    def _to_dict(self, sanitize):
        """
        Returns the model properties as a dict. Omits None properties based on the provided "sanitize" parameter.
        :param bool sanitize
        """

        result = {}

        for attr, attr_type in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x._to_dict(sanitize) if hasattr(x, "_to_dict") else x,
                    value
                ))
            elif hasattr(value, "_to_dict"):
                result[attr] = value._to_dict(sanitize)
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1]._to_dict(sanitize))
                    if hasattr(item[1], "_to_dict") else item,
                    six.iteritems(value)
                ))
            else:
                if sanitize:
                    if value is not None:
                        result[attr] = value
                else:
                    result[attr] = value
        if issubclass(RoutingPolicy, dict):
            for key, value in six.iteritems(self):
                result[key] = value

        return result

    def to_dict(self):
        """Returns the model properties as a dict"""
        return self._to_dict(False)

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self._to_dict(True))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RoutingPolicy):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

