# coding: utf-8


"""
IGNORE:
    Nutanix Networking Versioned APIs

    Manage networking configuration on Nutanix clusters, including AHV and advanced networking.  # noqa: E501

    OpenAPI spec version: 4.0.1-alpha-1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
import pprint
import json
import ast
import re  # noqa: F401

import six
from ntnx_networking_py_client.Ntnx.common.v1.config.IPAddress import IPAddress  # noqa: F401,E501

"""
IGNORE:
NOTE: This class is auto generated by the swagger code generator program.

Do not edit the class manually.
IGNORE
"""


class NetworkGatewayManagementInterface(object):
    """NetworkGatewayManagementInterface - a model defined in Swagger"""
    """
    IGNORE:
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    IGNORE
    """ # noqa: E501
    swagger_types = {
        'subnet_reference': 'str',
        'vlan_id': 'int',
        'address': 'common.v1.config.IPAddress',
        'default_gateway': 'common.v1.config.IPAddress',
        'mtu': 'int',
        '_reserved': 'dict(str, object)',
        '_object_type': 'str',
        '_unknown_fields': 'dict(str, object)',
    }

    attribute_map = {
        'subnet_reference': 'subnetReference',
        'vlan_id': 'vlanId',
        'address': 'address',
        'default_gateway': 'defaultGateway',
        'mtu': 'mtu',
        '_reserved': '$reserved',
        '_object_type': '$objectType',
        '_unknown_fields': '$unknownFields',
    }



    def __init__(self, subnet_reference=None, vlan_id=None, address=None, default_gateway=None, mtu=None, *args, **kwargs):  # noqa: E501
        """NetworkGatewayManagementInterface - a model defined in Swagger
            \nNetwork interface used to deliver network services and for managing the gateway. If a VPC reference is supplied then the gateway will be deployed on a dedicated subnet within the VPC. If a VPC reference is not supplied, then this interface defines the subnet on which the gateway will be deployed, and the address it will be assigned. When a VPC reference is not present, either a subnet reference or a VLAN id must be supplied, along with the address and default gateway of the subnet. A VLAN network without IPAM may be used. 
        """
        self.__subnet_reference = None
        self.__vlan_id = None
        self.__address = None
        self.__default_gateway = None
        self.__mtu = None
        self.discriminator = None
        if subnet_reference is not None:
            self.__subnet_reference = subnet_reference
        if vlan_id is not None:
            self.__vlan_id = vlan_id
        if address is not None:
            self.__address = address
        if default_gateway is not None:
            self.__default_gateway = default_gateway
        if mtu is not None:
            self.__mtu = mtu
        # populate hidden vars if not empty
        self._populate_hidden_vars(kwargs)

    def _initialize_object_type(self):
        return 'networking.v4.config.NetworkGatewayManagementInterface'

    def _initialize_fq_object_type(self):
        return 'networking.v4.r0.a1.config.NetworkGatewayManagementInterface'

    def _populate_hidden_vars(self, kwargs):
        if "_reserved" in kwargs and kwargs["_reserved"] is not None:
            self.__dollar_reserved = kwargs["_reserved"]
        elif "_reserved" in self.attribute_map and self.attribute_map["_reserved"] in kwargs and kwargs[self.attribute_map["_reserved"]] is not None:
            self.__dollar_reserved = kwargs[self.attribute_map["_reserved"]]
        else :
            self.__dollar_reserved = {"$fqObjectType": self._initialize_fq_object_type()}
        if "_unknown_fields" in kwargs and kwargs["_unknown_fields"] is not None:
            self.__dollar_unknown_fields = kwargs["_unknown_fields"]
        elif "_unknown_fields" in self.attribute_map and self.attribute_map["_unknown_fields"] in kwargs and kwargs[self.attribute_map["_unknown_fields"]] is not None:
            self.__dollar_unknown_fields = kwargs[self.attribute_map["_unknown_fields"]]
        else :
            self.__dollar_unknown_fields = {}
        if "_object_type" in kwargs and kwargs["_object_type"] is not None:
            self.__dollar_object_type = kwargs["_object_type"]
        elif "_object_type" in self.attribute_map and self.attribute_map["_object_type"] in kwargs and kwargs[self.attribute_map["_object_type"]] is not None:
            self.__dollar_object_type = kwargs[self.attribute_map["_object_type"]]
        else:
            self.__dollar_object_type = self._initialize_object_type()

    def get_object_type(self):
        return self.__dollar_object_type

    def get_reserved(self):
        return self.__dollar_reserved

    def get_unknown_fields(self):
        return self.__dollar_unknown_fields

    @property
    def subnet_reference(self):
        """`{ str }`
            \nThe on-prem vlan subnet to deploy the network gateway VM on
        """ # noqa: E501
        return self.__subnet_reference

    @subnet_reference.setter
    def subnet_reference(self, subnet_reference):
        if subnet_reference is not None and not re.search('^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$', subnet_reference):  # noqa: E501
            raise ValueError(r"Invalid value for `subnet_reference`, must be a follow pattern or equal to `/^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$/`")  # noqa: E501

        self.__subnet_reference = subnet_reference

    @property
    def vlan_id(self):
        """`{ int }`
            \nThe on-prem VLAN to deploy the gateway on
        """ # noqa: E501
        return self.__vlan_id

    @vlan_id.setter
    def vlan_id(self, vlan_id):
        if vlan_id is not None and vlan_id > 4095:  # noqa: E501
            raise ValueError("Invalid value for `vlan_id`, must be a value less than or equal to `4095`")  # noqa: E501
        if vlan_id is not None and vlan_id < 0:  # noqa: E501
            raise ValueError("Invalid value for `vlan_id`, must be a value greater than or equal to `0`")  # noqa: E501

        self.__vlan_id = vlan_id

    @property
    def address(self):
        """`{ common.v1.config.IPAddress }`
            
        """ # noqa: E501
        return self.__address

    @address.setter
    def address(self, address):

        self.__address = address

    @property
    def default_gateway(self):
        """`{ common.v1.config.IPAddress }`
            
        """ # noqa: E501
        return self.__default_gateway

    @default_gateway.setter
    def default_gateway(self, default_gateway):

        self.__default_gateway = default_gateway

    @property
    def mtu(self):
        """`{ int }`
            \nMTU of management interface
        """ # noqa: E501
        return self.__mtu

    @mtu.setter
    def mtu(self, mtu):

        self.__mtu = mtu

    @property
    def _reserved(self):
        """`{ dict(str, object) }`
            
        """ # noqa: E501
        return self.__dollar_reserved

    @property
    def _object_type(self):
        """`{ str }`
            
        """ # noqa: E501
        return self.__dollar_object_type

    @property
    def _unknown_fields(self):
        """`{ dict(str, object) }`
            
        """ # noqa: E501
        return self.__dollar_unknown_fields

    def _to_dict(self, sanitize):
        """
        Returns the model properties as a dict. Omits None properties based on the provided "sanitize" parameter.
        :param bool sanitize
        """

        result = {}

        for attr, attr_type in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x._to_dict(sanitize) if hasattr(x, "_to_dict") else x,
                    value
                ))
            elif hasattr(value, "_to_dict"):
                result[attr] = value._to_dict(sanitize)
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1]._to_dict(sanitize))
                    if hasattr(item[1], "_to_dict") else item,
                    six.iteritems(value)
                ))
            else:
                if sanitize:
                    if value is not None:
                        result[attr] = value
                else:
                    result[attr] = value
        if issubclass(NetworkGatewayManagementInterface, dict):
            for key, value in six.iteritems(self):
                result[key] = value

        return result

    def to_dict(self):
        """Returns the model properties as a dict"""
        return self._to_dict(False)

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self._to_dict(True))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, NetworkGatewayManagementInterface):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

