# coding: utf-8


"""
IGNORE:
    Nutanix Networking Versioned APIs

    Manage networking configuration on Nutanix clusters, including AHV and advanced networking.  # noqa: E501

    OpenAPI spec version: 4.0.1-alpha-1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
import pprint
import json
import ast
import re  # noqa: F401

import six
from ntnx_networking_py_client.Ntnx.networking.v4.config.Layer2StretchSubnetInfo import Layer2StretchSubnetInfo  # noqa: F401,E501
from ntnx_networking_py_client.Ntnx.networking.v4.config.Layer2StretchVpnConnectionInfo import Layer2StretchVpnConnectionInfo  # noqa: F401,E501
from ntnx_networking_py_client.Ntnx.networking.v4.config.Layer2StretchVtepGatewayInfo import Layer2StretchVtepGatewayInfo  # noqa: F401,E501

"""
IGNORE:
NOTE: This class is auto generated by the swagger code generator program.

Do not edit the class manually.
IGNORE
"""


class Layer2StretchRelatedEntities(object):
    """Layer2StretchRelatedEntities - a model defined in Swagger"""
    """
    IGNORE:
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    IGNORE
    """ # noqa: E501
    swagger_types = {
        'subnets': 'list[networking.v4.config.Layer2StretchSubnetInfo]',
        'vpn_connections': 'list[networking.v4.config.Layer2StretchVpnConnectionInfo]',
        'vtep_gateways': 'list[networking.v4.config.Layer2StretchVtepGatewayInfo]',
        '_reserved': 'dict(str, object)',
        '_object_type': 'str',
        '_unknown_fields': 'dict(str, object)',
    }

    attribute_map = {
        'subnets': 'subnets',
        'vpn_connections': 'vpnConnections',
        'vtep_gateways': 'vtepGateways',
        '_reserved': '$reserved',
        '_object_type': '$objectType',
        '_unknown_fields': '$unknownFields',
    }



    def __init__(self, subnets=None, vpn_connections=None, vtep_gateways=None, *args, **kwargs):  # noqa: E501
        """Layer2StretchRelatedEntities - a model defined in Swagger
            \nLayer2 stretch-related entities retrieved from the specified Prism Central cluster.
        """
        self.__subnets = None
        self.__vpn_connections = None
        self.__vtep_gateways = None
        self.discriminator = None
        if subnets is not None:
            self.__subnets = subnets
        if vpn_connections is not None:
            self.__vpn_connections = vpn_connections
        if vtep_gateways is not None:
            self.__vtep_gateways = vtep_gateways
        # populate hidden vars if not empty
        self._populate_hidden_vars(kwargs)

    def _initialize_object_type(self):
        return 'networking.v4.config.Layer2StretchRelatedEntities'

    def _initialize_fq_object_type(self):
        return 'networking.v4.r0.a1.config.Layer2StretchRelatedEntities'

    def _populate_hidden_vars(self, kwargs):
        if "_reserved" in kwargs and kwargs["_reserved"] is not None:
            self.__dollar_reserved = kwargs["_reserved"]
        elif "_reserved" in self.attribute_map and self.attribute_map["_reserved"] in kwargs and kwargs[self.attribute_map["_reserved"]] is not None:
            self.__dollar_reserved = kwargs[self.attribute_map["_reserved"]]
        else :
            self.__dollar_reserved = {"$fqObjectType": self._initialize_fq_object_type()}
        if "_unknown_fields" in kwargs and kwargs["_unknown_fields"] is not None:
            self.__dollar_unknown_fields = kwargs["_unknown_fields"]
        elif "_unknown_fields" in self.attribute_map and self.attribute_map["_unknown_fields"] in kwargs and kwargs[self.attribute_map["_unknown_fields"]] is not None:
            self.__dollar_unknown_fields = kwargs[self.attribute_map["_unknown_fields"]]
        else :
            self.__dollar_unknown_fields = {}
        if "_object_type" in kwargs and kwargs["_object_type"] is not None:
            self.__dollar_object_type = kwargs["_object_type"]
        elif "_object_type" in self.attribute_map and self.attribute_map["_object_type"] in kwargs and kwargs[self.attribute_map["_object_type"]] is not None:
            self.__dollar_object_type = kwargs[self.attribute_map["_object_type"]]
        else:
            self.__dollar_object_type = self._initialize_object_type()

    def get_object_type(self):
        return self.__dollar_object_type

    def get_reserved(self):
        return self.__dollar_reserved

    def get_unknown_fields(self):
        return self.__dollar_unknown_fields

    @property
    def subnets(self):
        """`{ list[networking.v4.config.Layer2StretchSubnetInfo] }`
            
        """ # noqa: E501
        return self.__subnets

    @subnets.setter
    def subnets(self, subnets):

        self.__subnets = subnets

    @property
    def vpn_connections(self):
        """`{ list[networking.v4.config.Layer2StretchVpnConnectionInfo] }`
            
        """ # noqa: E501
        return self.__vpn_connections

    @vpn_connections.setter
    def vpn_connections(self, vpn_connections):

        self.__vpn_connections = vpn_connections

    @property
    def vtep_gateways(self):
        """`{ list[networking.v4.config.Layer2StretchVtepGatewayInfo] }`
            
        """ # noqa: E501
        return self.__vtep_gateways

    @vtep_gateways.setter
    def vtep_gateways(self, vtep_gateways):

        self.__vtep_gateways = vtep_gateways

    @property
    def _reserved(self):
        """`{ dict(str, object) }`
            
        """ # noqa: E501
        return self.__dollar_reserved

    @property
    def _object_type(self):
        """`{ str }`
            
        """ # noqa: E501
        return self.__dollar_object_type

    @property
    def _unknown_fields(self):
        """`{ dict(str, object) }`
            
        """ # noqa: E501
        return self.__dollar_unknown_fields

    def _to_dict(self, sanitize):
        """
        Returns the model properties as a dict. Omits None properties based on the provided "sanitize" parameter.
        :param bool sanitize
        """

        result = {}

        for attr, attr_type in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x._to_dict(sanitize) if hasattr(x, "_to_dict") else x,
                    value
                ))
            elif hasattr(value, "_to_dict"):
                result[attr] = value._to_dict(sanitize)
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1]._to_dict(sanitize))
                    if hasattr(item[1], "_to_dict") else item,
                    six.iteritems(value)
                ))
            else:
                if sanitize:
                    if value is not None:
                        result[attr] = value
                else:
                    result[attr] = value
        if issubclass(Layer2StretchRelatedEntities, dict):
            for key, value in six.iteritems(self):
                result[key] = value

        return result

    def to_dict(self):
        """Returns the model properties as a dict"""
        return self._to_dict(False)

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self._to_dict(True))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Layer2StretchRelatedEntities):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

