# coding: utf-8


"""
IGNORE:
    Nutanix Networking Versioned APIs

    Manage networking configuration on Nutanix clusters, including AHV and advanced networking.  # noqa: E501

    OpenAPI spec version: 4.0.1-alpha-1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
import pprint
import json
import ast
import re  # noqa: F401

import six
from ntnx_networking_py_client.Ntnx.common.v1.config.Metadata import Metadata  # noqa: F401,E501
from ntnx_networking_py_client.Ntnx.networking.v4.config.NetworkingBaseModel import NetworkingBaseModel  # noqa: F401,E501
from ntnx_networking_py_client.Ntnx.networking.v4.config.RemoteVtepStretchStatus import RemoteVtepStretchStatus  # noqa: F401,E501
from ntnx_networking_py_client.Ntnx.networking.v4.config.SiteParams import SiteParams  # noqa: F401,E501
from ntnx_networking_py_client.Ntnx.networking.v4.config.StretchConnectionType import StretchConnectionType  # noqa: F401,E501
from ntnx_networking_py_client.Ntnx.networking.v4.config.StretchStatus import StretchStatus  # noqa: F401,E501

"""
IGNORE:
NOTE: This class is auto generated by the swagger code generator program.

Do not edit the class manually.
IGNORE
"""


class Layer2Stretch(NetworkingBaseModel):
    """Layer2Stretch - a model defined in Swagger"""
    """
    IGNORE:
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    IGNORE
    """ # noqa: E501
    swagger_types = {
        'name': 'str',
        'description': 'str',
        'local_site_params': 'networking.v4.config.SiteParams',
        'remote_site_params': 'networking.v4.config.SiteParams',
        'connection_type': 'networking.v4.config.StretchConnectionType',
        'stretch_status': 'networking.v4.config.StretchStatus',
        'remote_stretch_status': 'list[networking.v4.config.RemoteVtepStretchStatus]',
        'mtu': 'int',
        'vni': 'int',
        'metadata': 'common.v1.config.Metadata',
        'ext_id': 'str',
        'links': 'list[common.v1.response.ApiLink]',
        'tenant_id': 'str',
        '_reserved': 'dict(str, object)',
        '_object_type': 'str',
        '_unknown_fields': 'dict(str, object)',
    }

    attribute_map = {
        'name': 'name',
        'description': 'description',
        'local_site_params': 'localSiteParams',
        'remote_site_params': 'remoteSiteParams',
        'connection_type': 'connectionType',
        'stretch_status': 'stretchStatus',
        'remote_stretch_status': 'remoteStretchStatus',
        'mtu': 'mtu',
        'vni': 'vni',
        'metadata': 'metadata',
        'ext_id': 'extId',
        'links': 'links',
        'tenant_id': 'tenantId',
        '_reserved': '$reserved',
        '_object_type': '$objectType',
        '_unknown_fields': '$unknownFields',
    }



    def __init__(self, name=None, description=None, local_site_params=None, remote_site_params=None, connection_type=None, stretch_status=None, remote_stretch_status=None, mtu=None, vni=None, metadata=None, ext_id=None, links=None, tenant_id=None, *args, **kwargs):  # noqa: E501
        """Layer2Stretch - a model defined in Swagger
            
        """
        NetworkingBaseModel.__init__(self, metadata, ext_id, links, tenant_id, *args, **kwargs)
        self.__name = None
        self.__description = None
        self.__local_site_params = None
        self.__remote_site_params = None
        self.__connection_type = None
        self.__stretch_status = None
        self.__remote_stretch_status = None
        self.__mtu = None
        self.__vni = None
        self.discriminator = None
        self.__name = name
        if description is not None:
            self.__description = description
        if local_site_params is not None:
            self.__local_site_params = local_site_params
        if remote_site_params is not None:
            self.__remote_site_params = remote_site_params
        if connection_type is not None:
            self.__connection_type = connection_type
        if stretch_status is not None:
            self.__stretch_status = stretch_status
        if remote_stretch_status is not None:
            self.__remote_stretch_status = remote_stretch_status
        if mtu is not None:
            self.__mtu = mtu
        if vni is not None:
            self.__vni = vni

    def _initialize_object_type(self):
        return 'networking.v4.config.Layer2Stretch'

    def _initialize_fq_object_type(self):
        return 'networking.v4.r0.a1.config.Layer2Stretch'


    @property
    def name(self):
        """`{ str }`
            \nLayer2 stretch configuration name.
        """ # noqa: E501
        return self.__name

    @name.setter
    def name(self, name):
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self.__name = name

    @property
    def description(self):
        """`{ str }`
            \nLayer2 stretch configuration details between subnets on two sites.
        """ # noqa: E501
        return self.__description

    @description.setter
    def description(self, description):

        self.__description = description

    @property
    def local_site_params(self):
        """`{ networking.v4.config.SiteParams }`
            
        """ # noqa: E501
        return self.__local_site_params

    @local_site_params.setter
    def local_site_params(self, local_site_params):

        self.__local_site_params = local_site_params

    @property
    def remote_site_params(self):
        """`{ networking.v4.config.SiteParams }`
            
        """ # noqa: E501
        return self.__remote_site_params

    @remote_site_params.setter
    def remote_site_params(self, remote_site_params):

        self.__remote_site_params = remote_site_params

    @property
    def connection_type(self):
        """`{ networking.v4.config.StretchConnectionType }`
            
        """ # noqa: E501
        return self.__connection_type

    @connection_type.setter
    def connection_type(self, connection_type):

        self.__connection_type = connection_type

    @property
    def stretch_status(self):
        """`{ networking.v4.config.StretchStatus }`
            
        """ # noqa: E501
        return self.__stretch_status

    @stretch_status.setter
    def stretch_status(self, stretch_status):

        self.__stretch_status = stretch_status

    @property
    def remote_stretch_status(self):
        """`{ list[networking.v4.config.RemoteVtepStretchStatus] }`
            
        """ # noqa: E501
        return self.__remote_stretch_status

    @remote_stretch_status.setter
    def remote_stretch_status(self, remote_stretch_status):

        self.__remote_stretch_status = remote_stretch_status

    @property
    def mtu(self):
        """`{ int }`
            \nThe MTU size setting for the VXLAN session.
        """ # noqa: E501
        return self.__mtu

    @mtu.setter
    def mtu(self, mtu):
        if mtu is not None and mtu > 8950:  # noqa: E501
            raise ValueError("Invalid value for `mtu`, must be a value less than or equal to `8950`")  # noqa: E501
        if mtu is not None and mtu < 500:  # noqa: E501
            raise ValueError("Invalid value for `mtu`, must be a value greater than or equal to `500`")  # noqa: E501

        self.__mtu = mtu

    @property
    def vni(self):
        """`{ int }`
            \nThe VXLAN network identifier used to uniquely identify the VXLAN tunnel.
        """ # noqa: E501
        return self.__vni

    @vni.setter
    def vni(self, vni):
        if vni is not None and vni > 16777215:  # noqa: E501
            raise ValueError("Invalid value for `vni`, must be a value less than or equal to `16777215`")  # noqa: E501
        if vni is not None and vni < 1:  # noqa: E501
            raise ValueError("Invalid value for `vni`, must be a value greater than or equal to `1`")  # noqa: E501

        self.__vni = vni

    def _to_dict(self, sanitize):
        """
        Returns the model properties as a dict. Omits None properties based on the provided "sanitize" parameter.
        :param bool sanitize
        """

        result = {}

        for attr, attr_type in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x._to_dict(sanitize) if hasattr(x, "_to_dict") else x,
                    value
                ))
            elif hasattr(value, "_to_dict"):
                result[attr] = value._to_dict(sanitize)
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1]._to_dict(sanitize))
                    if hasattr(item[1], "_to_dict") else item,
                    six.iteritems(value)
                ))
            else:
                if sanitize:
                    if value is not None:
                        result[attr] = value
                else:
                    result[attr] = value
        if issubclass(Layer2Stretch, dict):
            for key, value in six.iteritems(self):
                result[key] = value

        return result

    def to_dict(self):
        """Returns the model properties as a dict"""
        return self._to_dict(False)

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self._to_dict(True))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Layer2Stretch):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

