# coding: utf-8


"""
IGNORE:
    Nutanix Networking Versioned APIs

    Manage networking configuration on Nutanix clusters, including AHV and advanced networking.  # noqa: E501

    OpenAPI spec version: 4.0.1-alpha-1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
import pprint
import json
import ast
import re  # noqa: F401

import six
from ntnx_networking_py_client.Ntnx.networking.v4.config.IPConfig import IPConfig  # noqa: F401,E501
from ntnx_networking_py_client.Ntnx.networking.v4.config.PublicIpMapping import PublicIpMapping  # noqa: F401,E501

"""
IGNORE:
NOTE: This class is auto generated by the swagger code generator program.

Do not edit the class manually.
IGNORE
"""


class AzureExternalSubnetConfig(object):
    """AzureExternalSubnetConfig - a model defined in Swagger"""
    """
    IGNORE:
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    IGNORE
    """ # noqa: E501
    swagger_types = {
        'ip_config': 'networking.v4.config.IPConfig',
        'gateway_mac_address': 'str',
        'public_ip_mapping_list': 'list[networking.v4.config.PublicIpMapping]',
        '_reserved': 'dict(str, object)',
        '_object_type': 'str',
        '_unknown_fields': 'dict(str, object)',
    }

    attribute_map = {
        'ip_config': 'ipConfig',
        'gateway_mac_address': 'gatewayMacAddress',
        'public_ip_mapping_list': 'publicIpMappingList',
        '_reserved': '$reserved',
        '_object_type': '$objectType',
        '_unknown_fields': '$unknownFields',
    }



    def __init__(self, ip_config=None, gateway_mac_address=None, public_ip_mapping_list=None, *args, **kwargs):  # noqa: E501
        """AzureExternalSubnetConfig - a model defined in Swagger
            \nThe external subnet configuration for the Azure cloud.
        """
        self.__ip_config = None
        self.__gateway_mac_address = None
        self.__public_ip_mapping_list = None
        self.discriminator = None
        self.__ip_config = ip_config
        if gateway_mac_address is not None:
            self.__gateway_mac_address = gateway_mac_address
        if public_ip_mapping_list is not None:
            self.__public_ip_mapping_list = public_ip_mapping_list
        # populate hidden vars if not empty
        self._populate_hidden_vars(kwargs)

    def _initialize_object_type(self):
        return 'networking.v4.config.AzureExternalSubnetConfig'

    def _initialize_fq_object_type(self):
        return 'networking.v4.r0.a1.config.AzureExternalSubnetConfig'

    def _populate_hidden_vars(self, kwargs):
        if "_reserved" in kwargs and kwargs["_reserved"] is not None:
            self.__dollar_reserved = kwargs["_reserved"]
        elif "_reserved" in self.attribute_map and self.attribute_map["_reserved"] in kwargs and kwargs[self.attribute_map["_reserved"]] is not None:
            self.__dollar_reserved = kwargs[self.attribute_map["_reserved"]]
        else :
            self.__dollar_reserved = {"$fqObjectType": self._initialize_fq_object_type()}
        if "_unknown_fields" in kwargs and kwargs["_unknown_fields"] is not None:
            self.__dollar_unknown_fields = kwargs["_unknown_fields"]
        elif "_unknown_fields" in self.attribute_map and self.attribute_map["_unknown_fields"] in kwargs and kwargs[self.attribute_map["_unknown_fields"]] is not None:
            self.__dollar_unknown_fields = kwargs[self.attribute_map["_unknown_fields"]]
        else :
            self.__dollar_unknown_fields = {}
        if "_object_type" in kwargs and kwargs["_object_type"] is not None:
            self.__dollar_object_type = kwargs["_object_type"]
        elif "_object_type" in self.attribute_map and self.attribute_map["_object_type"] in kwargs and kwargs[self.attribute_map["_object_type"]] is not None:
            self.__dollar_object_type = kwargs[self.attribute_map["_object_type"]]
        else:
            self.__dollar_object_type = self._initialize_object_type()

    def get_object_type(self):
        return self.__dollar_object_type

    def get_reserved(self):
        return self.__dollar_reserved

    def get_unknown_fields(self):
        return self.__dollar_unknown_fields

    @property
    def ip_config(self):
        """`{ networking.v4.config.IPConfig }`
            
        """ # noqa: E501
        return self.__ip_config

    @ip_config.setter
    def ip_config(self, ip_config):
        if ip_config is None:
            raise ValueError("Invalid value for `ip_config`, must not be `None`")  # noqa: E501

        self.__ip_config = ip_config

    @property
    def gateway_mac_address(self):
        """`{ str }`
            \nGateway MAC address of the external subnet.
        """ # noqa: E501
        return self.__gateway_mac_address

    @gateway_mac_address.setter
    def gateway_mac_address(self, gateway_mac_address):
        if gateway_mac_address is not None and not re.search('^([0-9A-Fa-f]{2}[:-]){5}([0-9A-Fa-f]{2})$', gateway_mac_address):  # noqa: E501
            raise ValueError(r"Invalid value for `gateway_mac_address`, must be a follow pattern or equal to `/^([0-9A-Fa-f]{2}[:-]){5}([0-9A-Fa-f]{2})$/`")  # noqa: E501

        self.__gateway_mac_address = gateway_mac_address

    @property
    def public_ip_mapping_list(self):
        """`{ list[networking.v4.config.PublicIpMapping] }`
            \nList of mappings of private IP (SNAT or floating IP) to public IP.
        """ # noqa: E501
        return self.__public_ip_mapping_list

    @public_ip_mapping_list.setter
    def public_ip_mapping_list(self, public_ip_mapping_list):

        self.__public_ip_mapping_list = public_ip_mapping_list

    @property
    def _reserved(self):
        """`{ dict(str, object) }`
            
        """ # noqa: E501
        return self.__dollar_reserved

    @property
    def _object_type(self):
        """`{ str }`
            
        """ # noqa: E501
        return self.__dollar_object_type

    @property
    def _unknown_fields(self):
        """`{ dict(str, object) }`
            
        """ # noqa: E501
        return self.__dollar_unknown_fields

    def _to_dict(self, sanitize):
        """
        Returns the model properties as a dict. Omits None properties based on the provided "sanitize" parameter.
        :param bool sanitize
        """

        result = {}

        for attr, attr_type in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x._to_dict(sanitize) if hasattr(x, "_to_dict") else x,
                    value
                ))
            elif hasattr(value, "_to_dict"):
                result[attr] = value._to_dict(sanitize)
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1]._to_dict(sanitize))
                    if hasattr(item[1], "_to_dict") else item,
                    six.iteritems(value)
                ))
            else:
                if sanitize:
                    if value is not None:
                        result[attr] = value
                else:
                    result[attr] = value
        if issubclass(AzureExternalSubnetConfig, dict):
            for key, value in six.iteritems(self):
                result[key] = value

        return result

    def to_dict(self):
        """Returns the model properties as a dict"""
        return self._to_dict(False)

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self._to_dict(True))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AzureExternalSubnetConfig):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

