# coding: utf-8


"""
IGNORE:
    Nutanix Networking Versioned APIs

    Manage networking configuration on Nutanix clusters, including AHV and advanced networking.  # noqa: E501

    OpenAPI spec version: 4.0.1-alpha-1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
import pprint
import json
import ast
import re  # noqa: F401

import six
from ntnx_networking_py_client.Ntnx.common.v1.config.IPAddress import IPAddress  # noqa: F401,E501
from ntnx_networking_py_client.Ntnx.networking.v4.config.IPSubnet import IPSubnet  # noqa: F401,E501

"""
IGNORE:
NOTE: This class is auto generated by the swagger code generator program.

Do not edit the class manually.
IGNORE
"""


class AzureExternalSubnetBinding(object):
    """AzureExternalSubnetBinding - a model defined in Swagger"""
    """
    IGNORE:
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    IGNORE
    """ # noqa: E501
    swagger_types = {
        'router_port_mac': 'str',
        'azure_external_network_prefix': 'networking.v4.config.IPSubnet',
        'peer_to_peer_network_prefix': 'networking.v4.config.IPSubnet',
        'eni_primary_ip': 'common.v1.config.IPAddress',
        'eni_id': 'str',
        '_reserved': 'dict(str, object)',
        '_object_type': 'str',
        '_unknown_fields': 'dict(str, object)',
    }

    attribute_map = {
        'router_port_mac': 'routerPortMac',
        'azure_external_network_prefix': 'azureExternalNetworkPrefix',
        'peer_to_peer_network_prefix': 'peerToPeerNetworkPrefix',
        'eni_primary_ip': 'eniPrimaryIp',
        'eni_id': 'eniId',
        '_reserved': '$reserved',
        '_object_type': '$objectType',
        '_unknown_fields': '$unknownFields',
    }



    def __init__(self, router_port_mac=None, azure_external_network_prefix=None, peer_to_peer_network_prefix=None, eni_primary_ip=None, eni_id=None, *args, **kwargs):  # noqa: E501
        """AzureExternalSubnetBinding - a model defined in Swagger
            \nBinding of Atlas Flow Gateway external subnet with Azure external subnet.
        """
        self.__router_port_mac = None
        self.__azure_external_network_prefix = None
        self.__peer_to_peer_network_prefix = None
        self.__eni_primary_ip = None
        self.__eni_id = None
        self.discriminator = None
        self.__router_port_mac = router_port_mac
        self.__azure_external_network_prefix = azure_external_network_prefix
        if peer_to_peer_network_prefix is not None:
            self.__peer_to_peer_network_prefix = peer_to_peer_network_prefix
        if eni_primary_ip is not None:
            self.__eni_primary_ip = eni_primary_ip
        if eni_id is not None:
            self.__eni_id = eni_id
        # populate hidden vars if not empty
        self._populate_hidden_vars(kwargs)

    def _initialize_object_type(self):
        return 'networking.v4.config.AzureExternalSubnetBinding'

    def _initialize_fq_object_type(self):
        return 'networking.v4.r0.a1.config.AzureExternalSubnetBinding'

    def _populate_hidden_vars(self, kwargs):
        if "_reserved" in kwargs and kwargs["_reserved"] is not None:
            self.__dollar_reserved = kwargs["_reserved"]
        elif "_reserved" in self.attribute_map and self.attribute_map["_reserved"] in kwargs and kwargs[self.attribute_map["_reserved"]] is not None:
            self.__dollar_reserved = kwargs[self.attribute_map["_reserved"]]
        else :
            self.__dollar_reserved = {"$fqObjectType": self._initialize_fq_object_type()}
        if "_unknown_fields" in kwargs and kwargs["_unknown_fields"] is not None:
            self.__dollar_unknown_fields = kwargs["_unknown_fields"]
        elif "_unknown_fields" in self.attribute_map and self.attribute_map["_unknown_fields"] in kwargs and kwargs[self.attribute_map["_unknown_fields"]] is not None:
            self.__dollar_unknown_fields = kwargs[self.attribute_map["_unknown_fields"]]
        else :
            self.__dollar_unknown_fields = {}
        if "_object_type" in kwargs and kwargs["_object_type"] is not None:
            self.__dollar_object_type = kwargs["_object_type"]
        elif "_object_type" in self.attribute_map and self.attribute_map["_object_type"] in kwargs and kwargs[self.attribute_map["_object_type"]] is not None:
            self.__dollar_object_type = kwargs[self.attribute_map["_object_type"]]
        else:
            self.__dollar_object_type = self._initialize_object_type()

    def get_object_type(self):
        return self.__dollar_object_type

    def get_reserved(self):
        return self.__dollar_reserved

    def get_unknown_fields(self):
        return self.__dollar_unknown_fields

    @property
    def router_port_mac(self):
        """`{ str }`
            \nMAC address of the router port of Atlas Flow Gateway.
        """ # noqa: E501
        return self.__router_port_mac

    @router_port_mac.setter
    def router_port_mac(self, router_port_mac):
        if router_port_mac is None:
            raise ValueError("Invalid value for `router_port_mac`, must not be `None`")  # noqa: E501
        if router_port_mac is not None and not re.search('^([0-9A-Fa-f]{2}[:-]){5}([0-9A-Fa-f]{2})$', router_port_mac):  # noqa: E501
            raise ValueError(r"Invalid value for `router_port_mac`, must be a follow pattern or equal to `/^([0-9A-Fa-f]{2}[:-]){5}([0-9A-Fa-f]{2})$/`")  # noqa: E501

        self.__router_port_mac = router_port_mac

    @property
    def azure_external_network_prefix(self):
        """`{ networking.v4.config.IPSubnet }`
            
        """ # noqa: E501
        return self.__azure_external_network_prefix

    @azure_external_network_prefix.setter
    def azure_external_network_prefix(self, azure_external_network_prefix):
        if azure_external_network_prefix is None:
            raise ValueError("Invalid value for `azure_external_network_prefix`, must not be `None`")  # noqa: E501

        self.__azure_external_network_prefix = azure_external_network_prefix

    @property
    def peer_to_peer_network_prefix(self):
        """`{ networking.v4.config.IPSubnet }`
            
        """ # noqa: E501
        return self.__peer_to_peer_network_prefix

    @peer_to_peer_network_prefix.setter
    def peer_to_peer_network_prefix(self, peer_to_peer_network_prefix):

        self.__peer_to_peer_network_prefix = peer_to_peer_network_prefix

    @property
    def eni_primary_ip(self):
        """`{ common.v1.config.IPAddress }`
            
        """ # noqa: E501
        return self.__eni_primary_ip

    @eni_primary_ip.setter
    def eni_primary_ip(self, eni_primary_ip):

        self.__eni_primary_ip = eni_primary_ip

    @property
    def eni_id(self):
        """`{ str }`
            \nExternal network interface Id.
        """ # noqa: E501
        return self.__eni_id

    @eni_id.setter
    def eni_id(self, eni_id):

        self.__eni_id = eni_id

    @property
    def _reserved(self):
        """`{ dict(str, object) }`
            
        """ # noqa: E501
        return self.__dollar_reserved

    @property
    def _object_type(self):
        """`{ str }`
            
        """ # noqa: E501
        return self.__dollar_object_type

    @property
    def _unknown_fields(self):
        """`{ dict(str, object) }`
            
        """ # noqa: E501
        return self.__dollar_unknown_fields

    def _to_dict(self, sanitize):
        """
        Returns the model properties as a dict. Omits None properties based on the provided "sanitize" parameter.
        :param bool sanitize
        """

        result = {}

        for attr, attr_type in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x._to_dict(sanitize) if hasattr(x, "_to_dict") else x,
                    value
                ))
            elif hasattr(value, "_to_dict"):
                result[attr] = value._to_dict(sanitize)
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1]._to_dict(sanitize))
                    if hasattr(item[1], "_to_dict") else item,
                    six.iteritems(value)
                ))
            else:
                if sanitize:
                    if value is not None:
                        result[attr] = value
                else:
                    result[attr] = value
        if issubclass(AzureExternalSubnetBinding, dict):
            for key, value in six.iteritems(self):
                result[key] = value

        return result

    def to_dict(self):
        """Returns the model properties as a dict"""
        return self._to_dict(False)

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self._to_dict(True))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AzureExternalSubnetBinding):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

