# coding: utf-8


"""
IGNORE:
    Nutanix Networking Versioned APIs

    Manage networking configuration on Nutanix clusters, including AHV and advanced networking.  # noqa: E501

    OpenAPI spec version: 4.0.1-alpha-1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
import pprint
import json
import ast
import re  # noqa: F401

import six
from ntnx_networking_py_client.Ntnx.common.v1.config.IPAddress import IPAddress  # noqa: F401,E501
from ntnx_networking_py_client.Ntnx.common.v1.config.Metadata import Metadata  # noqa: F401,E501
from ntnx_networking_py_client.Ntnx.networking.v4.config.NetworkingBaseModel import NetworkingBaseModel  # noqa: F401,E501

"""
IGNORE:
NOTE: This class is auto generated by the swagger code generator program.

Do not edit the class manually.
IGNORE
"""


class AncConfig(NetworkingBaseModel):
    """AncConfig - a model defined in Swagger"""
    """
    IGNORE:
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    IGNORE
    """ # noqa: E501
    swagger_types = {
        'config_version': 'int',
        'atlas_networking_enabled': 'bool',
        'anc_url': 'str',
        'ovn_remote_address': 'str',
        'anc_domain_name_server_list': 'list[common.v1.config.IPAddress]',
        'metadata': 'common.v1.config.Metadata',
        'ext_id': 'str',
        'links': 'list[common.v1.response.ApiLink]',
        'tenant_id': 'str',
        '_reserved': 'dict(str, object)',
        '_object_type': 'str',
        '_unknown_fields': 'dict(str, object)',
    }

    attribute_map = {
        'config_version': 'configVersion',
        'atlas_networking_enabled': 'atlasNetworkingEnabled',
        'anc_url': 'ancUrl',
        'ovn_remote_address': 'ovnRemoteAddress',
        'anc_domain_name_server_list': 'ancDomainNameServerList',
        'metadata': 'metadata',
        'ext_id': 'extId',
        'links': 'links',
        'tenant_id': 'tenantId',
        '_reserved': '$reserved',
        '_object_type': '$objectType',
        '_unknown_fields': '$unknownFields',
    }



    def __init__(self, config_version=None, atlas_networking_enabled=None, anc_url=None, ovn_remote_address=None, anc_domain_name_server_list=None, metadata=None, ext_id=None, links=None, tenant_id=None, *args, **kwargs):  # noqa: E501
        """AncConfig - a model defined in Swagger
            
        """
        NetworkingBaseModel.__init__(self, metadata, ext_id, links, tenant_id, *args, **kwargs)
        self.__config_version = None
        self.__atlas_networking_enabled = None
        self.__anc_url = None
        self.__ovn_remote_address = None
        self.__anc_domain_name_server_list = None
        self.discriminator = None
        if config_version is not None:
            self.__config_version = config_version
        if atlas_networking_enabled is not None:
            self.__atlas_networking_enabled = atlas_networking_enabled
        if anc_url is not None:
            self.__anc_url = anc_url
        if ovn_remote_address is not None:
            self.__ovn_remote_address = ovn_remote_address
        if anc_domain_name_server_list is not None:
            self.__anc_domain_name_server_list = anc_domain_name_server_list

    def _initialize_object_type(self):
        return 'networking.v4.config.AncConfig'

    def _initialize_fq_object_type(self):
        return 'networking.v4.r0.a1.config.AncConfig'


    @property
    def config_version(self):
        """`{ int }`
            \nConfiguration version for the current ANC. It is the logical timestamp for the current V4 release and will be updated by the actual configuration version in future releases.
        """ # noqa: E501
        return self.__config_version

    @config_version.setter
    def config_version(self, config_version):

        self.__config_version = config_version

    @property
    def atlas_networking_enabled(self):
        """`{ bool }`
            \nTrue if atlas networking is enabled and false otherwise.
        """ # noqa: E501
        return self.__atlas_networking_enabled

    @atlas_networking_enabled.setter
    def atlas_networking_enabled(self, atlas_networking_enabled):

        self.__atlas_networking_enabled = atlas_networking_enabled

    @property
    def anc_url(self):
        """`{ str }`
            \nURL of Atlas Network Controller (ANC).
        """ # noqa: E501
        return self.__anc_url

    @anc_url.setter
    def anc_url(self, anc_url):

        self.__anc_url = anc_url

    @property
    def ovn_remote_address(self):
        """`{ str }`
            \nOVN remote address of the Atlas Network Controller (ANC).
        """ # noqa: E501
        return self.__ovn_remote_address

    @ovn_remote_address.setter
    def ovn_remote_address(self, ovn_remote_address):

        self.__ovn_remote_address = ovn_remote_address

    @property
    def anc_domain_name_server_list(self):
        """`{ list[common.v1.config.IPAddress] }`
            \nResolve name server for the ANC services.
        """ # noqa: E501
        return self.__anc_domain_name_server_list

    @anc_domain_name_server_list.setter
    def anc_domain_name_server_list(self, anc_domain_name_server_list):

        self.__anc_domain_name_server_list = anc_domain_name_server_list

    def _to_dict(self, sanitize):
        """
        Returns the model properties as a dict. Omits None properties based on the provided "sanitize" parameter.
        :param bool sanitize
        """

        result = {}

        for attr, attr_type in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x._to_dict(sanitize) if hasattr(x, "_to_dict") else x,
                    value
                ))
            elif hasattr(value, "_to_dict"):
                result[attr] = value._to_dict(sanitize)
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1]._to_dict(sanitize))
                    if hasattr(item[1], "_to_dict") else item,
                    six.iteritems(value)
                ))
            else:
                if sanitize:
                    if value is not None:
                        result[attr] = value
                else:
                    result[attr] = value
        if issubclass(AncConfig, dict):
            for key, value in six.iteritems(self):
                result[key] = value

        return result

    def to_dict(self):
        """Returns the model properties as a dict"""
        return self._to_dict(False)

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self._to_dict(True))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AncConfig):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

